/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.internal.viewer;

import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.launch.core.lm.LaunchManager;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.launch.ui.internal.viewer.LaunchNodeImageDescriptor;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class LaunchTreeLabelProvider
extends LabelProvider
implements ILabelDecorator,
IDescriptionProvider {
    public String getText(Object element) {
        if (element instanceof LaunchNode) {
            return ((LaunchNode)((Object)element)).getName();
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof LaunchNode) {
            Image image = null;
            LaunchNode node = (LaunchNode)((Object)element);
            if (node.isType("root")) {
                image = UIPlugin.getImage("OBJ_Launches_Root");
            } else if (node.isType("launchConfigType")) {
                image = DebugUITools.getImage((String)node.getLaunchConfigurationType().getIdentifier());
            } else if (node.isType("launchConfig")) {
                try {
                    image = DebugUITools.getImage((String)node.getLaunchConfiguration().getType().getIdentifier());
                }
                catch (Exception exception) {}
            }
            if (image != null) {
                return this.decorateImage(image, element);
            }
        }
        return null;
    }

    public Image decorateImage(Image image, Object element) {
        Image decoratedImage = null;
        if (image != null && element instanceof LaunchNode) {
            LaunchNodeImageDescriptor descriptor = new LaunchNodeImageDescriptor(UIPlugin.getDefault().getImageRegistry(), image, (LaunchNode)((Object)element));
            decoratedImage = UIPlugin.getSharedImage(descriptor);
        }
        return decoratedImage;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public String getDescription(Object element) {
        if (element instanceof LaunchNode) {
            ILaunchManagerDelegate delegate;
            if (((LaunchNode)((Object)element)).getLaunchConfiguration() != null && (delegate = LaunchManager.getInstance().getLaunchManagerDelegate(((LaunchNode)((Object)element)).getLaunchConfigurationType(), "")) != null) {
                return delegate.getDescription(((LaunchNode)((Object)element)).getLaunchConfiguration());
            }
            return this.getText(element);
        }
        return null;
    }
}

