/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui;

import org.eclipse.cdt.debug.core.model.IReverseResumeHandler;
import org.eclipse.cdt.debug.core.model.IReverseStepIntoHandler;
import org.eclipse.cdt.debug.core.model.IReverseStepOverHandler;
import org.eclipse.cdt.debug.core.model.IReverseToggleHandler;
import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.cdt.debug.core.model.IUncallHandler;
import org.eclipse.cdt.debug.internal.core.ICWatchpointTarget;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyBackend;
import org.eclipse.cdt.debug.ui.IPinProvider;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.tcf.internal.cdt.ui.TCFSteppingModeTarget;
import org.eclipse.tcf.internal.cdt.ui.TCFSuspendResumeAdapter;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFWatchpointTarget;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFPinViewCommand;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFReverseResumeCommand;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFReverseStepIntoCommand;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFReverseStepOverCommand;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFReverseStepReturnCommand;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFReverseToggleCommand;
import org.eclipse.tcf.internal.cdt.ui.disassembly.TCFDisassemblyBackend;
import org.eclipse.tcf.internal.cdt.ui.hover.TCFDebugTextHover;
import org.eclipse.tcf.internal.cdt.ui.sourcelookup.TCFSourceNotFoundPresentation;
import org.eclipse.tcf.internal.debug.ui.model.ISourceNotFoundPresentation;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;

public class TCFNodeAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] CLASSES = new Class[]{IDisassemblyBackend.class, ISteppingModeTarget.class, ISuspendResume.class, ICEditorTextHover.class, IReverseToggleHandler.class, IReverseStepIntoHandler.class, IReverseStepOverHandler.class, IReverseResumeHandler.class, IUncallHandler.class, IPinProvider.class, ICWatchpointTarget.class, ISourceNotFoundPresentation.class};
    private static final TCFSourceNotFoundPresentation fgSourceNotFoundPresentation = new TCFSourceNotFoundPresentation();

    public Object getAdapter(Object obj, Class type) {
        if (obj instanceof TCFNode) {
            TCFNode node = (TCFNode)obj;
            TCFModel model = node.getModel();
            if (IDisassemblyBackend.class == type) {
                TCFDisassemblyBackend backend = new TCFDisassemblyBackend();
                if (backend.supportsDebugContext((IAdaptable)((TCFNode)obj))) {
                    return backend;
                }
            } else {
                if (ISteppingModeTarget.class == type) {
                    ISteppingModeTarget target = (ISteppingModeTarget)model.getAdapter(type, node);
                    if (target == null) {
                        target = new TCFSteppingModeTarget(model);
                        model.setAdapter(type, (Object)target);
                    }
                    return target;
                }
                if (ISuspendResume.class == type) {
                    TCFNodeExecContext exec = null;
                    if (node instanceof TCFNodeExecContext) {
                        exec = (TCFNodeExecContext)node;
                    } else if (node instanceof TCFNodeStackFrame) {
                        exec = (TCFNodeExecContext)node.getParent();
                    }
                    if (exec != null) {
                        return new TCFSuspendResumeAdapter(exec);
                    }
                } else {
                    if (ICEditorTextHover.class == type) {
                        Object hover = (ICEditorTextHover)model.getAdapter(type, node);
                        if (hover == null) {
                            hover = new TCFDebugTextHover();
                            model.setAdapter(type, hover);
                        }
                        return hover;
                    }
                    if (IReverseToggleHandler.class == type) {
                        IReverseToggleHandler handler = (IReverseToggleHandler)model.getAdapter(type, node);
                        if (handler == null) {
                            handler = new TCFReverseToggleCommand();
                            model.setAdapter(type, (Object)handler);
                        }
                        return handler;
                    }
                    if (IReverseStepIntoHandler.class == type) {
                        IReverseStepIntoHandler handler = (IReverseStepIntoHandler)model.getAdapter(type, node);
                        if (handler == null) {
                            handler = new TCFReverseStepIntoCommand(model);
                            model.setAdapter(type, (Object)handler);
                        }
                        return handler;
                    }
                    if (IReverseStepOverHandler.class == type) {
                        IReverseStepOverHandler handler = (IReverseStepOverHandler)model.getAdapter(type, node);
                        if (handler == null) {
                            handler = new TCFReverseStepOverCommand(model);
                            model.setAdapter(type, (Object)handler);
                        }
                        return handler;
                    }
                    if (IUncallHandler.class == type) {
                        IUncallHandler handler = (IUncallHandler)model.getAdapter(type, node);
                        if (handler == null) {
                            handler = new TCFReverseStepReturnCommand(model);
                            model.setAdapter(type, (Object)handler);
                        }
                        return handler;
                    }
                    if (IReverseResumeHandler.class == type) {
                        IReverseResumeHandler handler = (IReverseResumeHandler)model.getAdapter(type, node);
                        if (handler == null) {
                            handler = new TCFReverseResumeCommand(model);
                            model.setAdapter(type, (Object)handler);
                        }
                        return handler;
                    }
                    if (IPinProvider.class == type) {
                        IPinProvider handler = (IPinProvider)model.getAdapter(type, node);
                        if (handler == null) {
                            handler = new TCFPinViewCommand(model);
                            model.setAdapter(type, (Object)handler);
                        }
                        return handler;
                    }
                    if (ICWatchpointTarget.class == type) {
                        if (node instanceof TCFNodeExpression) {
                            return new TCFWatchpointTarget((TCFNodeExpression)node);
                        }
                    } else if (ISourceNotFoundPresentation.class == type) {
                        return fgSourceNotFoundPresentation;
                    }
                }
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return CLASSES;
    }
}

