/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpointExtension;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tcf.internal.cdt.ui.Activator;

public class TCFBreakpointScopeExtension
implements ICBreakpointExtension {
    private String fContextIds;
    private String fProperties;
    private ICBreakpoint fBreakpoint;

    public void initialize(ICBreakpoint breakpoint) throws CoreException {
        this.fBreakpoint = breakpoint;
        IMarker m = breakpoint.getMarker();
        if (m != null && m.exists()) {
            this.fContextIds = m.getAttribute("org.eclipse.tcf.debug.ContextIds", null);
            this.fProperties = m.getAttribute("org.eclipse.tcf.debug.ContextQuery", null);
        }
    }

    public void setThreadFilter(String[] threadIds) {
        String attr;
        if (threadIds == null) {
            attr = null;
        } else if (threadIds.length == 0) {
            attr = " ";
        } else {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < threadIds.length - 1) {
                buf.append(threadIds[i]).append(',');
                ++i;
            }
            buf.append(threadIds[threadIds.length - 1]);
            attr = buf.toString();
        }
        this.setRawContextIds(attr);
    }

    String getRawContextIds() {
        return this.fContextIds;
    }

    void setRawContextIds(String contextIDs) {
        this.fContextIds = contextIDs;
        if (this.fBreakpoint != null) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IMarker m = TCFBreakpointScopeExtension.this.fBreakpoint.getMarker();
                        if (m == null || !m.exists()) {
                            return;
                        }
                        m.setAttribute("org.eclipse.tcf.debug.ContextIds", (Object)TCFBreakpointScopeExtension.this.fContextIds);
                    }
                }, null);
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    public void setPropertiesFilter(String properties) {
        this.fProperties = properties;
        if (this.fBreakpoint == null) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker m = TCFBreakpointScopeExtension.this.fBreakpoint.getMarker();
                    if (m == null || !m.exists()) {
                        return;
                    }
                    m.setAttribute("org.eclipse.tcf.debug.ContextQuery", (Object)TCFBreakpointScopeExtension.this.fProperties);
                }
            }, null);
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    public String getPropertiesFilter() {
        return this.fProperties;
    }

    public String[] getThreadFilters() {
        if (this.fContextIds != null) {
            return this.fContextIds.split(",\\s*");
        }
        return null;
    }
}

