/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.BreakpointScopeCategory;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFBreakpointScopeExtension;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFThreadFilterEditor;
import org.eclipse.ui.dialogs.PropertyPage;

public class TCFBreakpointThreadFilterPage
extends PropertyPage {
    private TCFThreadFilterEditor fThreadFilterEditor;
    private TCFBreakpointScopeExtension fCategoryScopeExtension;

    protected Control createContents(Composite parent) {
        BreakpointScopeCategory category = this.getScopeCategory();
        if (category != null) {
            this.fCategoryScopeExtension = new TCFBreakpointScopeExtension();
            this.fCategoryScopeExtension.setPropertiesFilter(category.getFilter());
            this.fCategoryScopeExtension.setRawContextIds(category.getContextIds());
        }
        this.noDefaultAndApplyButton();
        Composite fieldEditorComposite = new Composite(parent, 0);
        fieldEditorComposite.setLayout((Layout)new GridLayout(1, false));
        this.createThreadFilterEditor(fieldEditorComposite);
        this.setValid(true);
        return fieldEditorComposite;
    }

    protected ICBreakpoint getBreakpoint() {
        return (ICBreakpoint)this.getElement().getAdapter(ICBreakpoint.class);
    }

    protected BreakpointScopeCategory getScopeCategory() {
        if (this.getElement() instanceof BreakpointScopeCategory) {
            return (BreakpointScopeCategory)this.getElement();
        }
        return null;
    }

    protected TCFBreakpointScopeExtension getFilterExtension() {
        ICBreakpoint bp = this.getBreakpoint();
        if (bp != null) {
            try {
                TCFBreakpointScopeExtension filter = (TCFBreakpointScopeExtension)bp.getExtension("org.eclipse.tcf.debug", TCFBreakpointScopeExtension.class);
                filter.initialize(bp);
                return filter;
            }
            catch (CoreException coreException) {}
        }
        return this.fCategoryScopeExtension;
    }

    protected void createThreadFilterEditor(Composite parent) {
        this.fThreadFilterEditor = new TCFThreadFilterEditor(parent, this);
    }

    protected TCFThreadFilterEditor getThreadFilterEditor() {
        return this.fThreadFilterEditor;
    }

    public boolean performOk() {
        this.doStore();
        return super.performOk();
    }

    protected void doStore() {
        this.fThreadFilterEditor.doStore();
        if (this.fCategoryScopeExtension != null) {
            this.getScopeCategory().setFilter(this.fCategoryScopeExtension.getPropertiesFilter(), this.fCategoryScopeExtension.getRawContextIds());
        }
    }
}

