/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.adapters;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeModule;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeRegister;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IRegisters;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.IStackTrace;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class TCFNodePropertySource
implements IPropertySource {
    private final TCFNode node;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private IPropertyDescriptor[] descriptors;
    private static final long REFRESH_DELAY = 250L;
    private static boolean refresh_posted = false;
    private static long refresh_time = 0L;
    private static boolean need_refresh = false;

    public TCFNodePropertySource(TCFNode node) {
        this.node = node;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            if (this.node == null) {
                this.descriptors = new IPropertyDescriptor[0];
                return this.descriptors;
            }
            try {
                final ArrayList list = new ArrayList();
                this.descriptors = (IPropertyDescriptor[])new TCFTask<IPropertyDescriptor[]>(this.node.getChannel()){

                    public void run() {
                        list.clear();
                        TCFNodePropertySource.this.properties.clear();
                        if (TCFNodePropertySource.this.node instanceof TCFNodeLaunch) {
                            this.getLaunchDescriptors((TCFNodeLaunch)TCFNodePropertySource.this.node);
                        } else if (TCFNodePropertySource.this.node instanceof TCFNodeExecContext) {
                            this.getExecContextDescriptors((TCFNodeExecContext)TCFNodePropertySource.this.node);
                        } else if (TCFNodePropertySource.this.node instanceof TCFNodeStackFrame) {
                            this.getFrameDescriptors((TCFNodeStackFrame)TCFNodePropertySource.this.node);
                        } else if (TCFNodePropertySource.this.node instanceof TCFNodeRegister) {
                            this.getRegisterDescriptors((TCFNodeRegister)TCFNodePropertySource.this.node);
                        } else if (TCFNodePropertySource.this.node instanceof TCFNodeModule) {
                            this.getModuleDescriptors((TCFNodeModule)TCFNodePropertySource.this.node);
                        } else {
                            this.done(list.toArray(new IPropertyDescriptor[list.size()]));
                        }
                    }

                    private void getModuleDescriptors(TCFNodeModule mod_node) {
                        TCFNodeExecContext.MemoryRegion ctx;
                        TCFDataCache<TCFNodeExecContext.MemoryRegion> mod_cache = mod_node.getRegion();
                        if (!mod_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        Throwable error = mod_cache.getError();
                        if (error != null) {
                            this.addDescriptor("Module Properties", "Error", TCFModel.getErrorMessage(error, false));
                        }
                        if ((ctx = (TCFNodeExecContext.MemoryRegion)mod_cache.getData()) != null && ctx.region != null) {
                            Map props = ctx.region.getProperties();
                            for (String key : props.keySet()) {
                                Object value = props.get(key);
                                if (value instanceof Number) {
                                    value = TCFNodePropertySource.toHexAddrString((Number)value);
                                }
                                this.addDescriptor("Module Properties", key, value);
                            }
                        }
                        this.done(list.toArray(new IPropertyDescriptor[list.size()]));
                    }

                    private void getRegisterDescriptors(TCFNodeRegister reg_node) {
                        IRegisters.RegistersContext ctx;
                        TCFDataCache<IRegisters.RegistersContext> ctx_cache = reg_node.getContext();
                        if (!ctx_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        Throwable error = ctx_cache.getError();
                        if (error != null) {
                            this.addDescriptor("Register Properties", "Error", TCFModel.getErrorMessage(error, false));
                        }
                        if ((ctx = (IRegisters.RegistersContext)ctx_cache.getData()) != null) {
                            Map props = ctx.getProperties();
                            for (String key : props.keySet()) {
                                Object value = props.get(key);
                                if (value instanceof Number) {
                                    value = TCFNodePropertySource.toHexAddrString((Number)value);
                                }
                                this.addDescriptor("Register Properties", key, value);
                            }
                        }
                        this.done(list.toArray(new IPropertyDescriptor[list.size()]));
                    }

                    private void getFrameDescriptors(TCFNodeStackFrame frameNode) {
                        TCFSourceRef ref;
                        TCFDataCache<IStackTrace.StackTraceContext> ctx_cache = frameNode.getStackTraceContext();
                        TCFDataCache<TCFSourceRef> line_info_cache = frameNode.getLineInfo();
                        if (!this.validateAll(ctx_cache, line_info_cache)) {
                            return;
                        }
                        IStackTrace.StackTraceContext ctx = (IStackTrace.StackTraceContext)ctx_cache.getData();
                        if (ctx != null) {
                            Map props = ctx.getProperties();
                            for (String key : props.keySet()) {
                                Object value = props.get(key);
                                if (value instanceof Number) {
                                    value = TCFNodePropertySource.toHexAddrString((Number)value);
                                }
                                this.addDescriptor("Stack Frame Properties", key, value);
                            }
                        }
                        if ((ref = (TCFSourceRef)line_info_cache.getData()) != null) {
                            if (ref.area != null) {
                                if (ref.area.directory != null) {
                                    this.addDescriptor("Source", "Directory", ref.area.directory);
                                }
                                if (ref.area.file != null) {
                                    this.addDescriptor("Source", "File", ref.area.file);
                                }
                                if (ref.area.start_line > 0) {
                                    this.addDescriptor("Source", "Line", ref.area.start_line);
                                }
                                if (ref.area.start_column > 0) {
                                    this.addDescriptor("Source", "Column", ref.area.start_column);
                                }
                            }
                            if (ref.error != null) {
                                this.addDescriptor("Source", "Error", TCFModel.getErrorMessage(ref.error, false));
                            }
                        }
                        this.done(list.toArray(new IPropertyDescriptor[list.size()]));
                    }

                    private void getExecContextDescriptors(TCFNodeExecContext exe_node) {
                        TCFContextState state;
                        Object value;
                        TCFDataCache<TCFNodeExecContext.MemoryRegion[]> mem_map_cache;
                        TCFDataCache<TCFContextState> state_cache;
                        TCFDataCache<IRunControl.RunControlContext> ctx_cache = exe_node.getRunContext();
                        if (!this.validateAll(ctx_cache, state_cache = exe_node.getState(), mem_map_cache = exe_node.getMemoryMap())) {
                            return;
                        }
                        IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)ctx_cache.getData();
                        if (ctx != null) {
                            Map props = ctx.getProperties();
                            for (String key : props.keySet()) {
                                value = props.get(key);
                                if (value instanceof Number) {
                                    value = TCFNodePropertySource.toHexAddrString((Number)value);
                                }
                                this.addDescriptor("Context", key, value);
                            }
                        }
                        if ((state = (TCFContextState)state_cache.getData()) != null) {
                            this.addDescriptor("State", "Suspended", state.is_suspended);
                            if (state.suspend_reason != null) {
                                this.addDescriptor("State", "Suspend reason", state.suspend_reason);
                            }
                            if (state.suspend_pc != null) {
                                this.addDescriptor("State", "PC", TCFNodePropertySource.toHexAddrString(new BigInteger(state.suspend_pc)));
                            }
                            this.addDescriptor("State", "Active", !exe_node.isNotActive());
                            if (state.suspend_params != null) {
                                for (String key : state.suspend_params.keySet()) {
                                    value = state.suspend_params.get(key);
                                    if (value instanceof Number) {
                                        value = TCFNodePropertySource.toHexAddrString((Number)value);
                                    }
                                    this.addDescriptor("State Properties", key, value);
                                }
                            }
                        }
                        this.done(list.toArray(new IPropertyDescriptor[list.size()]));
                    }

                    private void getLaunchDescriptors(TCFNodeLaunch launch_node) {
                        IChannel channel = launch_node.getChannel();
                        for (String s : channel.getRemoteServices()) {
                            this.addDescriptor("Target Services", s, "");
                        }
                        TCFLaunch launch = launch_node.getModel().getLaunch();
                        Set filter = launch.getContextFilter();
                        if (filter != null) {
                            this.addDescriptor("Context Filter", "Context IDs", filter.toString());
                        }
                        this.done(list.toArray(new IPropertyDescriptor[list.size()]));
                    }

                    private void addDescriptor(String category, String key, Object value) {
                        String id = String.valueOf(category) + '.' + key;
                        PropertyDescriptor desc = new PropertyDescriptor((Object)id, key);
                        desc.setCategory(category);
                        list.add(desc);
                        TCFNodePropertySource.this.properties.put(id, value);
                    }

                    private boolean validateAll(TCFDataCache<?> ... caches) {
                        TCFDataCache<?> pending = null;
                        TCFDataCache<?>[] tCFDataCacheArray = caches;
                        int n = caches.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TCFDataCache<?> cache = tCFDataCacheArray[n2];
                            if (!cache.validate()) {
                                pending = cache;
                            }
                            ++n2;
                        }
                        if (pending != null) {
                            pending.wait((Runnable)((Object)this));
                            return false;
                        }
                        return true;
                    }

                    public void done(IPropertyDescriptor[] r) {
                        need_refresh = true;
                        super.done((Object)r);
                    }
                }.get();
            }
            catch (Exception e) {
                if (this.node.getChannel().getState() != 2) {
                    Activator.log("Error retrieving property data", e);
                }
                this.descriptors = new IPropertyDescriptor[0];
            }
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        return this.properties.get(id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    private static String toHexAddrString(Number num) {
        BigInteger n = JSON.toBigInteger((Number)num);
        String s = n.toString(16);
        int sz = s.length() > 8 ? 16 : 8;
        int l = sz - s.length();
        if (l < 0) {
            l = 0;
        }
        if (l > 16) {
            l = 16;
        }
        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
    }

    public static void refresh(TCFNode node) {
        assert (Protocol.isDispatchThread());
        if (!need_refresh) {
            return;
        }
        refresh_time = System.currentTimeMillis();
        if (refresh_posted) {
            return;
        }
        refresh_posted = true;
        Protocol.invokeLater((long)250L, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                long time = System.currentTimeMillis();
                if (time - refresh_time < 187L) {
                    Protocol.invokeLater((long)(refresh_time + 250L - time), (Runnable)this);
                    return;
                }
                refresh_posted = false;
                need_refresh = false;
                Class<Device> clazz = Device.class;
                synchronized (Device.class) {
                    Display display = Display.getDefault();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            public void run() {
                                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                                int n = iWorkbenchWindowArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    PropertySheet props;
                                    PropertySheetPage page;
                                    IViewPart part;
                                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                                    IWorkbenchPart active_part = window.getActivePage().getActivePart();
                                    if (active_part instanceof IDebugView && (part = window.getActivePage().findView("org.eclipse.ui.views.PropertySheet")) instanceof PropertySheet && (page = (PropertySheetPage)(props = (PropertySheet)part).getCurrentPage()) != null) {
                                        page.refresh();
                                    }
                                    ++n2;
                                }
                            }
                        });
                    }
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

