/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFNumberFormat;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IWorkbenchPage;

public class ViewMemoryCommand
extends AbstractActionDelegate {
    protected void run() {
        try {
            IWorkbenchPage page = this.getWindow().getActivePage();
            page.showView("org.eclipse.debug.ui.MemoryView", null, 1);
            ArrayList<IMemoryBlock> list = new ArrayList<IMemoryBlock>();
            TCFNode[] tCFNodeArray = this.getSelectedNodes();
            int n = tCFNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Block b;
                final TCFNode node = tCFNodeArray[n2];
                IMemoryBlockRetrievalExtension mem_retrieval = (IMemoryBlockRetrievalExtension)node.getAdapter(IMemoryBlockRetrievalExtension.class);
                if (mem_retrieval != null && (b = (Block)new TCFTask<Block>(node.getChannel()){

                    public void run() {
                        try {
                            Number addr = null;
                            long size = -1L;
                            if (node instanceof TCFNodeExpression) {
                                TCFDataCache<IExpressions.Value> val_cache = ((TCFNodeExpression)node).getValue();
                                if (!val_cache.validate((Runnable)((Object)this))) {
                                    return;
                                }
                                IExpressions.Value val_data = (IExpressions.Value)val_cache.getData();
                                if (val_data != null) {
                                    byte[] bytes;
                                    addr = val_data.getAddress();
                                    if (addr != null) {
                                        byte[] bytes2 = val_data.getValue();
                                        if (bytes2 != null) {
                                            size = bytes2.length;
                                        }
                                    } else if (val_data.getRegisterID() != null && (bytes = val_data.getValue()) != null) {
                                        addr = TCFNumberFormat.toBigInteger(bytes, val_data.isBigEndian(), false);
                                    }
                                }
                            }
                            Block b = null;
                            if (addr != null) {
                                b = new Block();
                                b.addr = addr.longValue();
                                b.size = size;
                            }
                            this.done(b);
                        }
                        catch (Exception x) {
                            this.error(x);
                        }
                    }
                }.get()) != null) {
                    list.add(mem_retrieval.getMemoryBlock(b.addr, b.size));
                }
                ++n2;
            }
            DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(list.toArray(new IMemoryBlock[list.size()]));
        }
        catch (Exception x) {
            Activator.log("Cannot open memory view", x);
        }
    }

    protected void selectionChanged() {
        this.getAction().setEnabled(this.getSelectedNodes().length > 0);
    }

    private static class Block {
        long addr;
        long size;

        private Block() {
        }
    }
}

