/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.internal.debug.launch.TCFLaunchDelegate;
import org.eclipse.tcf.internal.debug.launch.TCFLocalAgent;
import org.eclipse.tcf.internal.debug.launch.TCFUserDefPeer;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.launch.PeerPropsDialog;
import org.eclipse.tcf.internal.debug.ui.launch.TCFPathMapTab;
import org.eclipse.tcf.internal.debug.ui.launch.TestErrorsDialog;
import org.eclipse.tcf.internal.debug.ui.launch.setup.SetupWizardDialog;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.util.TCFTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFTargetTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_ID = "org.eclipse.tcf.launch.targetTab";
    private Button run_local_agent_button;
    private Button use_local_agent_button;
    private Text peer_id_text;
    private Tree peer_tree;
    private Runnable update_peer_buttons;
    private final PeerInfo peer_info = new PeerInfo();
    private Display display;
    private Exception init_error;
    private String mem_map_cfg;

    public void createControl(Composite parent) {
        this.display = parent.getDisplay();
        assert (this.display != null);
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        this.createVerticalSpacer(comp, 1);
        this.createLocalAgentButtons(comp);
        this.createVerticalSpacer(comp, 1);
        this.createTargetGroup(comp);
    }

    private void createLocalAgentButtons(Composite parent) {
        Composite local_agent_comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local_agent_comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        local_agent_comp.setLayoutData((Object)gd);
        this.run_local_agent_button = this.createCheckButton(local_agent_comp, "Run instance of TCF agent on the local host");
        this.run_local_agent_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFTargetTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.run_local_agent_button.setEnabled(true);
        this.use_local_agent_button = this.createCheckButton(local_agent_comp, "Use local host as the target");
        this.use_local_agent_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFTargetTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.use_local_agent_button.setEnabled(true);
    }

    private void createTargetGroup(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        group.setFont(font);
        group.setText("Target");
        this.createVerticalSpacer((Composite)group, layout.numColumns);
        Label host_label = new Label((Composite)group, 0);
        host_label.setText("Target ID:");
        host_label.setLayoutData((Object)new GridData(32));
        host_label.setFont(font);
        this.peer_id_text = new Text((Composite)group, 2052);
        this.peer_id_text.setLayoutData((Object)new GridData(768));
        this.peer_id_text.setFont(font);
        this.peer_id_text.setEditable(false);
        this.createVerticalSpacer((Composite)group, layout.numColumns);
        Label peer_label = new Label((Composite)group, 0);
        peer_label.setText("&Available targets:");
        peer_label.setLayoutData((Object)new GridData(32));
        peer_label.setFont(font);
        this.loadChildren(this.peer_info);
        this.createPeerListArea((Composite)group);
    }

    private void createPeerListArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.peer_tree = new Tree(composite, 268437508);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 150;
        gd.minimumWidth = 470;
        this.peer_tree.setLayoutData((Object)gd);
        int i = 0;
        while (i < 6) {
            TreeColumn column = new TreeColumn(this.peer_tree, 16384, i);
            column.setMoveable(true);
            switch (i) {
                case 0: {
                    column.setText("Name");
                    column.setWidth(160);
                    break;
                }
                case 1: {
                    column.setText("OS");
                    column.setWidth(100);
                    break;
                }
                case 2: {
                    column.setText("User");
                    column.setWidth(100);
                    break;
                }
                case 3: {
                    column.setText("Transport");
                    column.setWidth(60);
                    break;
                }
                case 4: {
                    column.setText("Host");
                    column.setWidth(100);
                    break;
                }
                case 5: {
                    column.setText("Port");
                    column.setWidth(40);
                }
            }
            ++i;
        }
        this.peer_tree.setHeaderVisible(true);
        this.peer_tree.setFont(font);
        this.peer_tree.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                PeerInfo info = TCFTargetTab.this.findPeerInfo(item);
                if (info == null) {
                    TCFTargetTab.this.updateItems(item.getParentItem(), false);
                } else {
                    TCFTargetTab.this.fillItem(item, info);
                    TCFTargetTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.peer_tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                final PeerInfo info = TCFTargetTab.this.findPeerInfo(TCFTargetTab.this.peer_id_text.getText());
                if (info == null) {
                    return;
                }
                new PeerPropsDialog(TCFTargetTab.this.getShell(), TCFTargetTab.this.getImage(), info.attrs, info.peer instanceof TCFUserDefPeer).open();
                if (!(info.peer instanceof TCFUserDefPeer)) {
                    return;
                }
                Protocol.invokeLater((Runnable)new Runnable(){

                    public void run() {
                        ((TCFUserDefPeer)info.peer).updateAttributes(info.attrs);
                        TCFUserDefPeer.savePeers();
                    }
                });
            }

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] selections = TCFTargetTab.this.peer_tree.getSelection();
                if (selections.length > 0) {
                    if (!$assertionsDisabled && selections.length != 1) {
                        throw new AssertionError();
                    }
                    PeerInfo info = TCFTargetTab.this.findPeerInfo(selections[0]);
                    if (info != null) {
                        TCFTargetTab.this.peer_id_text.setText(TCFTargetTab.this.getPath(info));
                    }
                }
                TCFTargetTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.peer_tree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                TCFTargetTab.this.updateItems((TreeItem)e.item, false);
            }

            public void treeExpanded(TreeEvent e) {
                TCFTargetTab.this.updateItems((TreeItem)e.item, true);
            }
        });
        this.createPeerButtons(composite);
    }

    private void createPeerButtons(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Menu menu = new Menu((Control)this.peer_tree);
        SelectionAdapter sel_adapter = null;
        final Button button_new = new Button(composite, 8);
        button_new.setText("N&ew...");
        button_new.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final HashMap<String, String> attrs = new HashMap<String, String>();
                SetupWizardDialog wizard = new SetupWizardDialog(attrs);
                WizardDialog dialog = new WizardDialog(TCFTargetTab.this.getShell(), (IWizard)wizard);
                dialog.create();
                if (dialog.open() != 0) {
                    return;
                }
                if (attrs.isEmpty()) {
                    return;
                }
                Protocol.invokeLater((Runnable)new Runnable(){

                    public void run() {
                        new TCFUserDefPeer(attrs);
                        TCFUserDefPeer.savePeers();
                    }
                });
            }
        };
        button_new.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_new = new MenuItem(menu, 8);
        item_new.setText("N&ew...");
        item_new.addSelectionListener((SelectionListener)sel_adapter);
        final Button button_edit = new Button(composite, 8);
        button_edit.setText("E&dit...");
        button_edit.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final PeerInfo info = TCFTargetTab.this.findPeerInfo(TCFTargetTab.this.peer_id_text.getText());
                if (info == null) {
                    return;
                }
                if (new PeerPropsDialog(TCFTargetTab.this.getShell(), TCFTargetTab.this.getImage(), info.attrs, info.peer instanceof TCFUserDefPeer).open() != 0) {
                    return;
                }
                if (!(info.peer instanceof TCFUserDefPeer)) {
                    return;
                }
                Protocol.invokeLater((Runnable)new Runnable(){

                    public void run() {
                        ((TCFUserDefPeer)info.peer).updateAttributes(info.attrs);
                        TCFUserDefPeer.savePeers();
                    }
                });
            }
        };
        button_edit.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_edit = new MenuItem(menu, 8);
        item_edit.setText("E&dit...");
        item_edit.addSelectionListener((SelectionListener)sel_adapter);
        final Button button_remove = new Button(composite, 8);
        button_remove.setText("&Remove");
        button_remove.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final PeerInfo info = TCFTargetTab.this.findPeerInfo(TCFTargetTab.this.peer_id_text.getText());
                if (info == null) {
                    return;
                }
                if (!(info.peer instanceof TCFUserDefPeer)) {
                    return;
                }
                TCFTargetTab.this.peer_id_text.setText("");
                TCFTargetTab.this.updateLaunchConfigurationDialog();
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    public void run() {
                        ((TCFUserDefPeer)info.peer).dispose();
                        TCFUserDefPeer.savePeers();
                    }
                });
            }
        };
        button_remove.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_remove = new MenuItem(menu, 8);
        item_remove.setText("&Remove");
        item_remove.addSelectionListener((SelectionListener)sel_adapter);
        this.createVerticalSpacer(composite, 20);
        new MenuItem(menu, 2);
        final Button button_test = new Button(composite, 8);
        button_test.setText("Run &Tests");
        button_test.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFTargetTab.this.runDiagnostics(false);
            }
        };
        button_test.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_test = new MenuItem(menu, 8);
        item_test.setText("Run &Tests");
        item_test.addSelectionListener((SelectionListener)sel_adapter);
        final Button button_loop = new Button(composite, 8);
        button_loop.setText("Tests &Loop");
        button_loop.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFTargetTab.this.runDiagnostics(true);
            }
        };
        button_loop.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_loop = new MenuItem(menu, 8);
        item_loop.setText("Tests &Loop");
        item_loop.addSelectionListener((SelectionListener)sel_adapter);
        this.peer_tree.setMenu(menu);
        this.update_peer_buttons = new Runnable(){

            public void run() {
                boolean local = TCFTargetTab.this.use_local_agent_button.getSelection();
                PeerInfo info = TCFTargetTab.this.findPeerInfo(TCFTargetTab.this.peer_id_text.getText());
                button_new.setEnabled(!local);
                button_edit.setEnabled(info != null && !local);
                button_remove.setEnabled(info != null && info.peer instanceof TCFUserDefPeer && !local);
                button_test.setEnabled(local || info != null);
                button_loop.setEnabled(local || info != null);
                item_new.setEnabled(!local);
                item_edit.setEnabled(info != null && !local);
                item_remove.setEnabled(info != null && info.peer instanceof TCFUserDefPeer && !local);
                item_test.setEnabled(info != null);
                item_loop.setEnabled(info != null);
            }
        };
        this.update_peer_buttons.run();
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.use_local_agent_button.getSelection()) {
            this.peer_tree.setEnabled(false);
            this.peer_tree.deselectAll();
            String id = TCFLocalAgent.getLocalAgentID();
            if (id == null) {
                id = "";
            }
            this.peer_id_text.setText(id);
            this.peer_id_text.setEnabled(false);
        } else {
            this.peer_tree.setEnabled(true);
            this.peer_id_text.setEnabled(true);
            String id = this.peer_id_text.getText();
            TreeItem item = this.findItem(id);
            if (item != null) {
                this.peer_tree.setSelection(item);
            } else {
                this.peer_tree.deselectAll();
            }
        }
        this.update_peer_buttons.run();
        super.updateLaunchConfigurationDialog();
    }

    public void dispose() {
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                TCFTargetTab.this.disconnectPeer(TCFTargetTab.this.peer_info);
                TCFTargetTab.this.display = null;
            }
        });
        super.dispose();
    }

    public String getName() {
        return "Target";
    }

    public Image getImage() {
        return ImageCache.getImage("icons/target_tab.gif");
    }

    public String getId() {
        return TAB_ID;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        try {
            String id = configuration.getAttribute("org.eclipse.tcf.debug.PeerID", "");
            TreeItem item = this.findItem(id);
            if (item != null) {
                this.peer_tree.setSelection(item);
            }
            this.peer_id_text.setText(id);
            this.run_local_agent_button.setSelection(configuration.getAttribute("org.eclipse.tcf.debug.RunLocalAgent", false));
            this.use_local_agent_button.setSelection(configuration.getAttribute("org.eclipse.tcf.debug.UseLocalAgent", true));
            this.mem_map_cfg = configuration.getAttribute("org.eclipse.tcf.debug.MemoryMap", "null");
        }
        catch (CoreException e) {
            this.init_error = e;
            this.setErrorMessage("Cannot read launch configuration: " + (Object)((Object)e));
            Activator.log(e);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.use_local_agent_button.getSelection()) {
            configuration.removeAttribute("org.eclipse.tcf.debug.PeerID");
        } else {
            configuration.setAttribute("org.eclipse.tcf.debug.PeerID", this.peer_id_text.getText());
        }
        configuration.setAttribute("org.eclipse.tcf.debug.RunLocalAgent", this.run_local_agent_button.getSelection());
        configuration.setAttribute("org.eclipse.tcf.debug.UseLocalAgent", this.use_local_agent_button.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.tcf.debug.RunLocalAgent", false);
        configuration.setAttribute("org.eclipse.tcf.debug.UseLocalAgent", true);
        configuration.removeAttribute("org.eclipse.tcf.debug.PeerID");
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.init_error != null) {
            this.setErrorMessage("Cannot read launch configuration: " + this.init_error);
            return false;
        }
        return true;
    }

    private void disconnectPeer(PeerInfo info) {
        assert (Protocol.isDispatchThread());
        if (info.children != null) {
            PeerInfo[] peerInfoArray = info.children;
            int n = info.children.length;
            int n2 = 0;
            while (n2 < n) {
                PeerInfo p = peerInfoArray[n2];
                this.disconnectPeer(p);
                ++n2;
            }
        }
        if (info.listener != null) {
            info.locator.removeListener((ILocator.LocatorListener)info.listener);
            info.listener = null;
            info.locator = null;
        }
        if (info.channel != null) {
            info.channel.close();
        }
    }

    private boolean canHaveChildren(PeerInfo parent) {
        return parent == this.peer_info || parent.attrs.get("Proxy") != null;
    }

    private void loadChildren(final PeerInfo parent) {
        assert (Thread.currentThread() == this.display.getThread());
        if (parent.children_pending) {
            return;
        }
        assert (parent.children == null);
        parent.children_pending = true;
        parent.children_error = null;
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                if (!$assertionsDisabled && parent.listener != null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && parent.channel != null) {
                    throw new AssertionError();
                }
                if (!TCFTargetTab.this.canHaveChildren(parent)) {
                    TCFTargetTab.this.doneLoadChildren(parent, null, new PeerInfo[0]);
                } else if (parent == TCFTargetTab.this.peer_info) {
                    ((TCFTargetTab)TCFTargetTab.this).peer_info.locator = Protocol.getLocator();
                    TCFTargetTab.this.doneLoadChildren(parent, null, TCFTargetTab.this.createLocatorListener(TCFTargetTab.this.peer_info));
                } else {
                    IChannel channel;
                    parent.channel = channel = parent.peer.openChannel();
                    parent.channel.addChannelListener(new IChannel.IChannelListener(){
                        boolean opened = false;
                        boolean closed = false;

                        public void congestionLevel(int level) {
                        }

                        public void onChannelClosed(final Throwable error) {
                            if (!$assertionsDisabled && this.closed) {
                                throw new AssertionError();
                            }
                            if (parent.channel != channel) {
                                return;
                            }
                            if (!this.opened) {
                                TCFTargetTab.this.doneLoadChildren(parent, error, null);
                            } else if (TCFTargetTab.this.display != null) {
                                TCFTargetTab.this.display.asyncExec(new Runnable(){

                                    public void run() {
                                        if (parent.children_pending) {
                                            return;
                                        }
                                        parent.children = null;
                                        parent.children_error = error;
                                        TCFTargetTab.this.updateItems(parent);
                                    }
                                });
                            }
                            this.closed = true;
                            parent.channel = null;
                            parent.locator = null;
                            parent.listener = null;
                        }

                        public void onChannelOpened() {
                            if (!$assertionsDisabled && this.opened) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && this.closed) {
                                throw new AssertionError();
                            }
                            if (parent.channel != channel) {
                                return;
                            }
                            this.opened = true;
                            parent.locator = (ILocator)parent.channel.getRemoteService(ILocator.class);
                            if (parent.locator == null) {
                                parent.channel.terminate((Throwable)new Exception("Service not supported: Locator"));
                            } else {
                                TCFTargetTab.this.doneLoadChildren(parent, null, TCFTargetTab.this.createLocatorListener(parent));
                            }
                        }
                    });
                }
            }
        });
    }

    private PeerInfo[] createLocatorListener(PeerInfo peer) {
        assert (Protocol.isDispatchThread());
        Map map = peer.locator.getPeers();
        PeerInfo[] buf = new PeerInfo[map.size()];
        int n = 0;
        for (IPeer p : map.values()) {
            PeerInfo info = new PeerInfo();
            info.parent = peer;
            info.id = p.getID();
            info.attrs = new HashMap<String, String>(p.getAttributes());
            info.peer = p;
            buf[n++] = info;
        }
        peer.listener = new LocatorListener(peer);
        peer.locator.addListener((ILocator.LocatorListener)peer.listener);
        return buf;
    }

    private void doneLoadChildren(final PeerInfo parent, final Throwable error, final PeerInfo[] children) {
        assert (Protocol.isDispatchThread());
        assert (error == null || children == null);
        if (this.display == null) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (!$assertionsDisabled && !parent.children_pending) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && parent.children != null) {
                    throw new AssertionError();
                }
                parent.children_pending = false;
                parent.children = children;
                parent.children_error = error;
                TCFTargetTab.this.updateItems(parent);
            }
        });
    }

    private ArrayList<PeerInfo> filterPeerList(PeerInfo parent, boolean expanded) {
        PeerInfo p;
        ArrayList<PeerInfo> lst = new ArrayList<PeerInfo>();
        HashMap<String, PeerInfo> local_agents = new HashMap<String, PeerInfo>();
        HashSet<String> ids = new HashSet<String>();
        PeerInfo[] peerInfoArray = parent.children;
        int n = parent.children.length;
        int n2 = 0;
        while (n2 < n) {
            p = peerInfoArray[n2];
            String id = p.attrs.get("AgentID");
            if (id != null && "TCP".equals(p.attrs.get("TransportName")) && "127.0.0.1".equals(p.attrs.get("Host"))) {
                local_agents.put(id, p);
                ids.add(p.id);
            }
            ++n2;
        }
        peerInfoArray = parent.children;
        n = parent.children.length;
        n2 = 0;
        while (n2 < n) {
            p = peerInfoArray[n2];
            PeerInfo i = (PeerInfo)local_agents.get(p.attrs.get("AgentID"));
            if (i == null || i == p) {
                lst.add(p);
            }
            ++n2;
        }
        if (parent != this.peer_info && expanded) {
            peerInfoArray = this.peer_info.children;
            n = this.peer_info.children.length;
            n2 = 0;
            while (n2 < n) {
                p = peerInfoArray[n2];
                if (p.peer instanceof TCFUserDefPeer && !ids.contains(p.id)) {
                    PeerInfo x = new PeerInfo();
                    x.parent = parent;
                    x.id = p.id;
                    x.attrs = p.attrs;
                    x.peer = p.peer;
                    ids.add(x.id);
                    lst.add(x);
                }
                ++n2;
            }
        }
        return lst;
    }

    private void updateItems(TreeItem parent_item, boolean reload) {
        final PeerInfo parent_info = this.findPeerInfo(parent_item);
        if (parent_info == null) {
            parent_item.setText("Invalid");
        } else {
            if (reload && parent_info.children_error != null) {
                this.loadChildren(parent_info);
            }
            this.display.asyncExec(new Runnable(){

                public void run() {
                    TCFTargetTab.this.updateItems(parent_info);
                }
            });
        }
    }

    private void updateItems(final PeerInfo parent) {
        if (this.display == null) {
            return;
        }
        assert (Thread.currentThread() == this.display.getThread());
        parent.item_update = new Runnable(){

            public void run() {
                if (TCFTargetTab.this.display == null) {
                    return;
                }
                if (parent.item_update != this) {
                    return;
                }
                if (Thread.currentThread() != TCFTargetTab.this.display.getThread()) {
                    TCFTargetTab.this.display.asyncExec((Runnable)this);
                    return;
                }
                parent.item_update = null;
                TreeItem[] items = null;
                boolean expanded = true;
                if (parent.children == null || parent.children_error != null) {
                    if (parent == TCFTargetTab.this.peer_info) {
                        TCFTargetTab.this.peer_tree.setItemCount(1);
                        items = TCFTargetTab.this.peer_tree.getItems();
                    } else {
                        TreeItem item = TCFTargetTab.this.findItem(parent);
                        if (item == null) {
                            return;
                        }
                        expanded = item.getExpanded();
                        item.setItemCount(1);
                        items = item.getItems();
                    }
                    if (!$assertionsDisabled && items.length != 1) {
                        throw new AssertionError();
                    }
                    if (parent.children_pending) {
                        items[0].setForeground(TCFTargetTab.this.display.getSystemColor(24));
                        TCFTargetTab.this.fillItem(items[0], "Connecting...");
                    } else if (parent.children_error != null) {
                        String msg = parent.children_error.getMessage();
                        msg = msg == null ? parent.children_error.getClass().getName() : msg.replace('\n', ' ');
                        items[0].setForeground(TCFTargetTab.this.display.getSystemColor(3));
                        TCFTargetTab.this.fillItem(items[0], msg);
                    } else if (expanded) {
                        TCFTargetTab.this.loadChildren(parent);
                        items[0].setForeground(TCFTargetTab.this.display.getSystemColor(24));
                        TCFTargetTab.this.fillItem(items[0], "Connecting...");
                    } else {
                        Protocol.invokeAndWait((Runnable)new Runnable(){

                            public void run() {
                                TCFTargetTab.this.disconnectPeer(parent);
                            }
                        });
                        TCFTargetTab.this.fillItem(items[0], "");
                    }
                } else {
                    ArrayList lst = null;
                    if (parent == TCFTargetTab.this.peer_info) {
                        lst = TCFTargetTab.this.filterPeerList(parent, expanded);
                        TCFTargetTab.this.peer_tree.setItemCount(lst.size() > 0 ? lst.size() : 1);
                        items = TCFTargetTab.this.peer_tree.getItems();
                    } else {
                        TreeItem item = TCFTargetTab.this.findItem(parent);
                        if (item == null) {
                            return;
                        }
                        expanded = item.getExpanded();
                        lst = TCFTargetTab.this.filterPeerList(parent, expanded);
                        item.setItemCount(expanded && lst.size() > 0 ? lst.size() : 1);
                        items = item.getItems();
                    }
                    if (expanded && lst.size() > 0) {
                        if (!$assertionsDisabled && items.length != lst.size()) {
                            throw new AssertionError();
                        }
                        int i = 0;
                        while (i < items.length) {
                            TCFTargetTab.this.fillItem(items[i], (PeerInfo)lst.get(i));
                            ++i;
                        }
                    } else if (expanded) {
                        TCFTargetTab.this.fillItem(items[0], "No peers");
                    } else {
                        Protocol.invokeAndWait((Runnable)new Runnable(){

                            public void run() {
                                TCFTargetTab.this.disconnectPeer(parent);
                            }
                        });
                        TCFTargetTab.this.fillItem(items[0], "");
                    }
                }
                TCFTargetTab.this.updateLaunchConfigurationDialog();
            }
        };
        if (parent.children_pending) {
            parent.item_update.run();
        } else {
            Protocol.invokeLater((long)200L, (Runnable)parent.item_update);
        }
    }

    private TreeItem findItem(String path) {
        assert (Thread.currentThread() == this.display.getThread());
        if (path == null) {
            return null;
        }
        int z = path.lastIndexOf(47);
        if (z < 0) {
            int n = this.peer_tree.getItemCount();
            int i = 0;
            while (i < n) {
                TreeItem x = this.peer_tree.getItem(i);
                PeerInfo p = (PeerInfo)x.getData("TCFPeerInfo");
                if (p != null && p.id.equals(path)) {
                    return x;
                }
                ++i;
            }
        } else {
            TreeItem y = this.findItem(path.substring(0, z));
            if (y == null) {
                return null;
            }
            String id = path.substring(z + 1);
            int n = y.getItemCount();
            int i = 0;
            while (i < n) {
                TreeItem x = y.getItem(i);
                PeerInfo p = (PeerInfo)x.getData("TCFPeerInfo");
                if (p != null && p.id.equals(id)) {
                    return x;
                }
                ++i;
            }
        }
        return null;
    }

    private TreeItem findItem(PeerInfo info) {
        if (info == null) {
            return null;
        }
        assert (info.parent != null);
        if (info.parent == this.peer_info) {
            int n = this.peer_tree.getItemCount();
            int i = 0;
            while (i < n) {
                TreeItem x = this.peer_tree.getItem(i);
                if (x.getData("TCFPeerInfo") == info) {
                    return x;
                }
                ++i;
            }
        } else {
            TreeItem y = this.findItem(info.parent);
            if (y == null) {
                return null;
            }
            int n = y.getItemCount();
            int i = 0;
            while (i < n) {
                TreeItem x = y.getItem(i);
                if (x.getData("TCFPeerInfo") == info) {
                    return x;
                }
                ++i;
            }
        }
        return null;
    }

    private PeerInfo findPeerInfo(String path) {
        TreeItem i = this.findItem(path);
        if (i == null) {
            return null;
        }
        return (PeerInfo)i.getData("TCFPeerInfo");
    }

    private PeerInfo findPeerInfo(TreeItem item) {
        assert (Thread.currentThread() == this.display.getThread());
        if (item == null) {
            return this.peer_info;
        }
        return (PeerInfo)item.getData("TCFPeerInfo");
    }

    private void runDiagnostics(boolean loop) {
        IPeer peer = null;
        if (this.use_local_agent_button.getSelection()) {
            try {
                if (this.run_local_agent_button.getSelection()) {
                    TCFLocalAgent.runLocalAgent();
                }
                final String id = TCFLocalAgent.getLocalAgentID();
                peer = (IPeer)new TCFTask<IPeer>(){

                    public void run() {
                        this.done((IPeer)Protocol.getLocator().getPeers().get(id));
                    }
                }.get();
            }
            catch (Throwable err) {
                String msg = err.getLocalizedMessage();
                if (msg == null || msg.length() == 0) {
                    msg = err.getClass().getName();
                }
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setText("Error");
                mb.setMessage("Cannot start agent:\n" + msg);
                mb.open();
            }
        } else {
            PeerInfo info = this.findPeerInfo(this.peer_id_text.getText());
            if (info == null) {
                return;
            }
            peer = info.peer;
        }
        if (peer == null) {
            return;
        }
        Shell shell = new Shell(this.getShell(), 32800);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        shell.setLayout((Layout)layout);
        shell.setText("Running Diagnostics...");
        CLabel label = new CLabel((Composite)shell, 0);
        label.setLayoutData((Object)new GridData(4, 2, true, false));
        label.setText("Running Diagnostics...");
        final TCFTestSuite[] test = new TCFTestSuite[1];
        Button button_cancel = new Button((Composite)shell, 8);
        button_cancel.setText("&Cancel");
        button_cancel.setLayoutData((Object)new GridData(3, 2, false, false));
        button_cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    public void run() {
                        if (test[0] != null) {
                            test[0].cancel();
                        }
                    }
                });
            }
        });
        this.createVerticalSpacer((Composite)shell, 0);
        ProgressBar bar = new ProgressBar((Composite)shell, 256);
        bar.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        shell.setDefaultButton(button_cancel);
        shell.pack();
        shell.setSize(483, shell.getSize().y);
        Rectangle rc0 = this.getShell().getBounds();
        Rectangle rc1 = shell.getBounds();
        shell.setLocation(rc0.x + (rc0.width - rc1.width) / 2, rc0.y + (rc0.height - rc1.height) / 2);
        shell.setVisible(true);
        this.runDiagnostics(peer, loop, test, shell, label, bar);
    }

    private void runDiagnostics(final IPeer peer, final boolean loop, final TCFTestSuite[] test, final Shell shell, final CLabel label, final ProgressBar bar) {
        final TCFTestSuite.TestListener done = new TCFTestSuite.TestListener(){
            private String last_text = "";
            private int last_count = 0;
            private int last_total = 0;

            public void progress(String label_text, int count_done, int count_total) {
                if (!$assertionsDisabled && test[0] == null) {
                    throw new AssertionError();
                }
                if ((label_text == null || this.last_text.equals(label_text)) && this.last_total == count_total && (float)(count_done - this.last_count) / (float)count_total < 0.02f) {
                    return;
                }
                if (label_text != null) {
                    this.last_text = label_text;
                }
                this.last_total = count_total;
                this.last_count = count_done;
                TCFTargetTab.this.display.asyncExec(new Runnable(){

                    public void run() {
                        label.setText(last_text);
                        bar.setMinimum(0);
                        bar.setMaximum(last_total);
                        bar.setSelection(last_count);
                    }
                });
            }

            public void done(final Collection<Throwable> errors) {
                if (!$assertionsDisabled && test[0] == null) {
                    throw new AssertionError();
                }
                final boolean b = test[0].isCanceled();
                test[0] = null;
                TCFTargetTab.this.display.asyncExec(new Runnable(){

                    public void run() {
                        if (errors.size() > 0) {
                            shell.dispose();
                            new TestErrorsDialog(TCFTargetTab.this.getControl().getShell(), ImageCache.getImage("icons/tcf.gif"), errors).open();
                        } else if (loop && !b && TCFTargetTab.this.display != null) {
                            TCFTargetTab.this.runDiagnostics(peer, true, test, shell, label, bar);
                        } else {
                            shell.dispose();
                        }
                    }
                });
            }
        };
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                try {
                    boolean enable_tracing;
                    List<IPathMap.PathMapRule> path_map = null;
                    ILaunchConfigurationTab[] iLaunchConfigurationTabArray = TCFTargetTab.this.getLaunchConfigurationDialog().getTabs();
                    int n = iLaunchConfigurationTabArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfigurationTab t = iLaunchConfigurationTabArray[n2];
                        if (t instanceof TCFPathMapTab) {
                            path_map = ((TCFPathMapTab)t).getPathMap();
                        }
                        ++n2;
                    }
                    HashMap mem_map = null;
                    if (TCFTargetTab.this.mem_map_cfg != null) {
                        mem_map = new HashMap();
                        TCFLaunchDelegate.parseMemMapsAttribute(mem_map, (String)TCFTargetTab.this.mem_map_cfg);
                    }
                    boolean bl = enable_tracing = "true".equals(Platform.getDebugOption((String)"org.eclipse.tcf.debug/debug")) && "true".equals(Platform.getDebugOption((String)"org.eclipse.tcf.debug/debug/tests/runcontrol"));
                    if (enable_tracing) {
                        System.setProperty("org.eclipse.tcf.debug.tracing.tests.runcontrol", "true");
                    }
                    test[0] = new TCFTestSuite(peer, done, path_map, mem_map);
                }
                catch (Throwable x) {
                    ArrayList<Throwable> errors = new ArrayList<Throwable>();
                    errors.add(x);
                    done.done(errors);
                }
            }
        });
    }

    private void fillItem(TreeItem item, PeerInfo info) {
        assert (Thread.currentThread() == this.display.getThread());
        Object data = item.getData("TCFPeerInfo");
        if (data != null && data != info) {
            item.removeAll();
        }
        item.setData("TCFPeerInfo", (Object)info);
        String[] text = new String[]{info.attrs.get("Name"), info.attrs.get("OSName"), info.attrs.get("UserName"), info.attrs.get("TransportName"), info.attrs.get("Host"), info.attrs.get("Port")};
        int i = 0;
        while (i < text.length) {
            if (text[i] == null) {
                text[i] = "";
            }
            ++i;
        }
        item.setText(text);
        item.setForeground(this.display.getSystemColor(24));
        item.setImage(ImageCache.getImage(this.getImageName(info)));
        if (!this.canHaveChildren(info)) {
            item.setItemCount(0);
        } else if (info.children == null || info.children_error != null) {
            item.setItemCount(1);
        } else {
            item.setItemCount(info.children.length);
        }
    }

    private void fillItem(TreeItem item, String text) {
        item.setText(text);
        item.setData("TCFPeerInfo", null);
        int n = this.peer_tree.getColumnCount();
        int i = 1;
        while (i < n) {
            item.setText(i, "");
            ++i;
        }
        item.setImage(null);
        item.removeAll();
    }

    private String getPath(PeerInfo info) {
        if (info == this.peer_info) {
            return "";
        }
        if (info.parent == this.peer_info) {
            return info.id;
        }
        return String.valueOf(this.getPath(info.parent)) + "/" + info.id;
    }

    private String getImageName(PeerInfo info) {
        return "icons/target_tab.gif";
    }

    private class LocatorListener
    implements ILocator.LocatorListener {
        private final PeerInfo parent;

        LocatorListener(PeerInfo parent) {
            this.parent = parent;
        }

        public void peerAdded(final IPeer peer) {
            if (TCFTargetTab.this.display == null) {
                return;
            }
            final String id = peer.getID();
            final HashMap attrs = new HashMap(peer.getAttributes());
            TCFTargetTab.this.display.asyncExec(new Runnable(){

                public void run() {
                    PeerInfo[] arr;
                    if (((LocatorListener)LocatorListener.this).parent.children_error != null) {
                        return;
                    }
                    PeerInfo[] peerInfoArray = arr = ((LocatorListener)LocatorListener.this).parent.children;
                    int n = arr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PeerInfo p = peerInfoArray[n2];
                        if (!$assertionsDisabled && p.id.equals(id)) {
                            throw new AssertionError();
                        }
                        ++n2;
                    }
                    PeerInfo[] buf = new PeerInfo[arr.length + 1];
                    System.arraycopy(arr, 0, buf, 0, arr.length);
                    PeerInfo info = new PeerInfo();
                    info.parent = LocatorListener.this.parent;
                    info.id = id;
                    info.attrs = attrs;
                    info.peer = peer;
                    buf[arr.length] = info;
                    ((LocatorListener)LocatorListener.this).parent.children = buf;
                    TCFTargetTab.this.updateItems(LocatorListener.this.parent);
                }
            });
        }

        public void peerChanged(final IPeer peer) {
            if (TCFTargetTab.this.display == null) {
                return;
            }
            final String id = peer.getID();
            final HashMap attrs = new HashMap(peer.getAttributes());
            TCFTargetTab.this.display.asyncExec(new Runnable(){

                public void run() {
                    if (((LocatorListener)LocatorListener.this).parent.children_error != null) {
                        return;
                    }
                    PeerInfo[] arr = ((LocatorListener)LocatorListener.this).parent.children;
                    int i = 0;
                    while (i < arr.length) {
                        if (arr[i].id.equals(id)) {
                            arr[i].attrs = attrs;
                            arr[i].peer = peer;
                            TCFTargetTab.this.updateItems(LocatorListener.this.parent);
                        }
                        ++i;
                    }
                }
            });
        }

        public void peerRemoved(final String id) {
            if (TCFTargetTab.this.display == null) {
                return;
            }
            TCFTargetTab.this.display.asyncExec(new Runnable(){

                public void run() {
                    if (((LocatorListener)LocatorListener.this).parent.children_error != null) {
                        return;
                    }
                    PeerInfo[] arr = ((LocatorListener)LocatorListener.this).parent.children;
                    PeerInfo[] buf = new PeerInfo[arr.length - 1];
                    int j = 0;
                    int i = 0;
                    while (i < arr.length) {
                        if (arr[i].id.equals(id)) {
                            final PeerInfo info = arr[i];
                            Protocol.invokeLater((Runnable)new Runnable(){

                                public void run() {
                                    TCFTargetTab.this.disconnectPeer(info);
                                }
                            });
                        } else {
                            buf[j++] = arr[i];
                        }
                        ++i;
                    }
                    ((LocatorListener)LocatorListener.this).parent.children = buf;
                    TCFTargetTab.this.updateItems(LocatorListener.this.parent);
                }
            });
        }

        public void peerHeartBeat(final String id) {
            if (TCFTargetTab.this.display == null) {
                return;
            }
            TCFTargetTab.this.display.asyncExec(new Runnable(){

                public void run() {
                    if (((LocatorListener)LocatorListener.this).parent.children_error != null) {
                        return;
                    }
                    PeerInfo[] arr = ((LocatorListener)LocatorListener.this).parent.children;
                    int i = 0;
                    while (i < arr.length) {
                        if (arr[i].id.equals(id)) {
                            if (arr[i].children_error == null) break;
                            TreeItem item = TCFTargetTab.this.findItem(arr[i]);
                            boolean visible = item != null;
                            while (visible && item != null) {
                                if (!item.getExpanded()) {
                                    visible = false;
                                }
                                item = item.getParentItem();
                            }
                            if (!visible) break;
                            TCFTargetTab.this.loadChildren(arr[i]);
                            break;
                        }
                        ++i;
                    }
                }
            });
        }
    }

    private static class PeerInfo {
        PeerInfo parent;
        String id;
        Map<String, String> attrs;
        PeerInfo[] children;
        boolean children_pending;
        Throwable children_error;
        IPeer peer;
        IChannel channel;
        ILocator locator;
        LocatorListener listener;
        Runnable item_update;

        private PeerInfo() {
        }
    }
}

