/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.ICastToType;
import org.eclipse.tcf.internal.debug.ui.model.IDetailsProvider;
import org.eclipse.tcf.internal.debug.ui.model.IWatchInExpressions;
import org.eclipse.tcf.internal.debug.ui.model.StyledStringBuffer;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenSubExpressions;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelFonts;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelProxy;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeArrayPartition;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeRegister;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.internal.debug.ui.model.TCFNumberFormat;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IRegisters;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFNodeExpression
extends TCFNode
implements IElementEditor,
ICastToType,
IWatchInExpressions,
IDetailsProvider {
    private final String script;
    private final int index;
    private final boolean deref;
    private final String field_id;
    private final String reg_id;
    private final TCFNode.TCFData<IExpressions.Expression> var_expression;
    private final TCFNode.TCFData<String> base_text;
    private final TCFNode.TCFData<Expression> expression;
    private final TCFNode.TCFData<IExpressions.Value> value;
    private final TCFNode.TCFData<ISymbols.Symbol> type;
    private final TCFNode.TCFData<String> type_name;
    private final TCFNode.TCFData<String> string;
    private final TCFNode.TCFData<String> expression_text;
    private final TCFChildrenSubExpressions children;
    private final boolean is_empty;
    private int sort_pos;
    private boolean enabled = true;
    private IExpressions.Value prev_value;
    private IExpressions.Value next_value;
    private byte[] parent_value;
    private static final RGB rgb_error = new RGB(192, 0, 0);
    private static final RGB rgb_highlight = new RGB(255, 255, 128);
    private static final RGB rgb_disabled = new RGB(127, 127, 127);
    private static int expr_cnt;
    private static final ICellModifier cell_modifier;

    static {
        cell_modifier = new ICellModifier(){

            public boolean canModify(Object element, final String property) {
                final TCFNodeExpression node = (TCFNodeExpression)element;
                return (Boolean)new TCFTask<Boolean>(){

                    public void run() {
                        if ("Name".equals(property)) {
                            this.done(node.is_empty || node.script != null);
                            return;
                        }
                        if (!node.is_empty && node.enabled) {
                            if (!node.expression.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (node.expression.getData() != null && ((Expression)((TCFNodeExpression)node).expression.getData()).expression.canAssign()) {
                                if (!node.value.validate((Runnable)((Object)this))) {
                                    return;
                                }
                                if (!node.type.validate((Runnable)((Object)this))) {
                                    return;
                                }
                                if ("HexValue".equals(property)) {
                                    this.done(TCFNumberFormat.isValidHexNumber(node.toNumberString(16)) == null);
                                    return;
                                }
                                if ("DecValue".equals(property)) {
                                    this.done(TCFNumberFormat.isValidDecNumber(true, node.toNumberString(10)) == null);
                                    return;
                                }
                            }
                        }
                        this.done(Boolean.FALSE);
                    }
                }.getE();
            }

            public Object getValue(Object element, final String property) {
                final TCFNodeExpression node = (TCFNodeExpression)element;
                return new TCFTask<String>(){

                    public void run() {
                        if (node.is_empty) {
                            this.done("");
                            return;
                        }
                        if ("Name".equals(property)) {
                            this.done(node.script);
                            return;
                        }
                        if (!node.value.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (node.value.getData() != null) {
                            if ("HexValue".equals(property)) {
                                this.done(node.toNumberString(16));
                                return;
                            }
                            if ("DecValue".equals(property)) {
                                this.done(node.toNumberString(10));
                                return;
                            }
                        }
                        this.done(null);
                    }
                }.getE();
            }

            public void modify(Object element, final String property, final Object value) {
                if (value == null) {
                    return;
                }
                final TCFNodeExpression node = (TCFNodeExpression)element;
                new TCFTask<Boolean>(){

                    public void run() {
                        try {
                            IExpressions.Expression exp;
                            if ("Name".equals(property)) {
                                if (node.is_empty) {
                                    String s;
                                    if (value instanceof String && (s = ((String)value).trim()).length() > 0) {
                                        node.model.getDisplay().asyncExec(new Runnable(){

                                            public void run() {
                                                IWatchExpression expression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(s);
                                                DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)expression);
                                                IAdaptable object = DebugUITools.getDebugContext();
                                                IDebugElement context = null;
                                                if (object instanceof IDebugElement) {
                                                    context = (IDebugElement)object;
                                                } else if (object instanceof ILaunch) {
                                                    context = ((ILaunch)object).getDebugTarget();
                                                }
                                                expression.setExpressionContext(context);
                                            }
                                        });
                                    }
                                } else if (!node.script.equals(value)) {
                                    IExpression e;
                                    IExpressionManager m = DebugPlugin.getDefault().getExpressionManager();
                                    IExpression[] iExpressionArray = m.getExpressions();
                                    int n = iExpressionArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        e = iExpressionArray[n2];
                                        if (node.script.equals(e.getExpressionText())) {
                                            m.removeExpression(e);
                                        }
                                        ++n2;
                                    }
                                    e = m.newWatchExpression((String)value);
                                    m.addExpression(e);
                                }
                                this.done(Boolean.TRUE);
                                return;
                            }
                            if (!node.expression.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (node.expression.getData() != null && (exp = ((Expression)((TCFNodeExpression)node).expression.getData()).expression).canAssign()) {
                                byte[] bf = null;
                                int size = exp.getSize();
                                boolean is_float = false;
                                boolean big_endian = false;
                                boolean signed = false;
                                if (!node.value.validate((Runnable)((Object)this))) {
                                    return;
                                }
                                IExpressions.Value eval = (IExpressions.Value)node.value.getData();
                                if (eval != null) {
                                    switch (eval.getTypeClass()) {
                                        case real: {
                                            is_float = true;
                                            signed = true;
                                            break;
                                        }
                                        case integer: {
                                            signed = true;
                                        }
                                    }
                                    big_endian = eval.isBigEndian();
                                    size = eval.getValue().length;
                                }
                                String input = (String)value;
                                String error = null;
                                if ("HexValue".equals(property)) {
                                    error = TCFNumberFormat.isValidHexNumber(input);
                                    if (error == null) {
                                        bf = TCFNumberFormat.toByteArray(input, 16, false, size, signed, big_endian);
                                    }
                                } else if ("DecValue".equals(property) && (error = TCFNumberFormat.isValidDecNumber(is_float, input)) == null) {
                                    bf = TCFNumberFormat.toByteArray(input, 10, is_float, size, signed, big_endian);
                                }
                                if (error != null) {
                                    throw new Exception("Invalid value: " + value, new Exception(error));
                                }
                                if (bf != null) {
                                    IExpressions exps = (IExpressions)node.launch.getService(IExpressions.class);
                                    exps.assign(exp.getID(), bf, new IExpressions.DoneAssign(){

                                        public void doneAssign(IToken token, Exception error) {
                                            node.getRootExpression().onValueChanged();
                                            if (error != null) {
                                                node.model.showMessageBox("Cannot modify element value", error);
                                                this.done(Boolean.FALSE);
                                            } else {
                                                this.done(Boolean.TRUE);
                                            }
                                        }
                                    });
                                    return;
                                }
                            }
                            this.done(Boolean.FALSE);
                        }
                        catch (Throwable x) {
                            node.model.showMessageBox("Cannot modify element value", x);
                            this.done(Boolean.FALSE);
                        }
                    }
                }.getE();
            }
        };
    }

    TCFNodeExpression(final TCFNode parent, final String script, final String field_id, final String var_id, final String reg_id, final int index, final boolean deref) {
        super(parent, var_id != null ? var_id : "Expr" + expr_cnt++);
        this.script = script;
        this.field_id = field_id;
        this.reg_id = reg_id;
        this.index = index;
        this.deref = deref;
        this.is_empty = script == null && var_id == null && field_id == null && reg_id == null && index < 0;
        this.var_expression = new TCFNode.TCFData<IExpressions.Expression>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                IExpressions exps = (IExpressions)TCFNodeExpression.this.launch.getService(IExpressions.class);
                if (exps == null || var_id == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = exps.getContext(var_id, new IExpressions.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IExpressions.Expression context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.base_text = new TCFNode.TCFData<String>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                TCFNodeExpression.this.parent_value = null;
                if (TCFNodeExpression.this.is_empty) {
                    this.set(null, null, null);
                    return true;
                }
                if (script != null) {
                    this.set(null, null, script);
                    return true;
                }
                if (var_id != null) {
                    if (!TCFNodeExpression.this.var_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Throwable err = null;
                    String exp = null;
                    if (TCFNodeExpression.this.var_expression.getData() == null) {
                        err = TCFNodeExpression.this.var_expression.getError();
                    } else {
                        exp = ((IExpressions.Expression)TCFNodeExpression.this.var_expression.getData()).getExpression();
                        if (exp == null) {
                            err = new Exception("Missing 'Expression' property");
                        }
                    }
                    this.set(null, err, exp);
                    return true;
                }
                if (reg_id != null) {
                    this.set(null, null, "${" + reg_id + "}");
                    return true;
                }
                String e = null;
                TCFNode n = parent;
                while (n instanceof TCFNodeArrayPartition) {
                    n = n.parent;
                }
                String cast = TCFNodeExpression.this.model.getCastToType(n.id);
                if (cast == null && deref) {
                    TCFNodeExpression exp = (TCFNodeExpression)n;
                    if (!exp.value.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Value v = (IExpressions.Value)exp.value.getData();
                    if (v != null && v.getTypeID() != null) {
                        TCFNodeExpression.this.parent_value = v.getValue();
                        if (TCFNodeExpression.this.parent_value != null) {
                            e = "(${" + v.getTypeID() + "})0x" + TCFNumberFormat.toBigInteger(TCFNodeExpression.this.parent_value, v.isBigEndian(), false).toString(16);
                        }
                    }
                }
                if (e == null) {
                    TCFNode.TCFData t = ((TCFNodeExpression)n).base_text;
                    if (!t.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    e = (String)t.getData();
                    if (e == null) {
                        this.set(null, t.getError(), null);
                        return true;
                    }
                }
                if (cast != null) {
                    e = "(" + cast + ")(" + e + ")";
                }
                if (field_id != null) {
                    e = "(" + e + ")" + (deref ? "->" : ".") + "${" + field_id + "}";
                } else if (index == 0) {
                    e = "*(" + e + ")";
                } else if (index > 0) {
                    e = "(" + e + ")[" + index + "]";
                }
                this.set(null, null, e);
                return true;
            }
        };
        this.expression_text = new TCFNode.TCFData<String>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                String cast;
                String expr_text = null;
                if (script != null) {
                    expr_text = script;
                } else if (var_id != null) {
                    TCFDataCache<ISymbols.Symbol> var;
                    if (!TCFNodeExpression.this.var_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Expression e = (IExpressions.Expression)TCFNodeExpression.this.var_expression.getData();
                    if (e != null && (var = TCFNodeExpression.this.model.getSymbolInfoCache(e.getSymbolID())) != null) {
                        if (!var.validate((Runnable)((Object)this))) {
                            return false;
                        }
                        if (var.getData() != null) {
                            expr_text = ((ISymbols.Symbol)var.getData()).getName();
                        }
                    }
                } else if (reg_id != null) {
                    if (!TCFNodeExpression.this.model.createNode(reg_id, (Runnable)((Object)this))) {
                        return false;
                    }
                    if (this.isValid()) {
                        return true;
                    }
                    TCFNodeRegister reg_node = (TCFNodeRegister)TCFNodeExpression.this.model.getNode(reg_id);
                    while (true) {
                        TCFDataCache<IRegisters.RegistersContext> ctx_cache;
                        if (!(ctx_cache = reg_node.getContext()).validate((Runnable)((Object)this))) {
                            return false;
                        }
                        IRegisters.RegistersContext ctx_data = (IRegisters.RegistersContext)ctx_cache.getData();
                        if (ctx_data == null) {
                            this.set(null, ctx_cache.getError(), null);
                            return true;
                        }
                        String string = expr_text = expr_text == null ? ctx_data.getName() : String.valueOf(ctx_data.getName()) + "." + expr_text;
                        if (!(reg_node.parent instanceof TCFNodeRegister)) break;
                        reg_node = (TCFNodeRegister)reg_node.parent;
                    }
                    expr_text = "$" + expr_text;
                } else {
                    TCFNode.TCFData pending = null;
                    TCFNode.TCFData field = TCFNodeExpression.this.model.getSymbolInfoCache(field_id);
                    if (field != null && !field.validate()) {
                        pending = field;
                    }
                    if (!TCFNodeExpression.this.base_text.validate()) {
                        pending = TCFNodeExpression.this.base_text;
                    }
                    if (pending != null) {
                        pending.wait((Runnable)((Object)this));
                        return false;
                    }
                    String parent_text = "";
                    TCFNode n = parent;
                    while (n instanceof TCFNodeArrayPartition) {
                        n = n.parent;
                    }
                    TCFNode.TCFData parent_text_cache = ((TCFNodeExpression)n).expression_text;
                    if (!parent_text_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    if (parent_text_cache.getData() != null && !(parent_text = (String)parent_text_cache.getData()).matches("\\w*")) {
                        parent_text = String.valueOf('(') + parent_text + ')';
                    }
                    if (index >= 0) {
                        expr_text = index == 0 && deref ? "*" + parent_text : String.valueOf(parent_text) + "[" + index + "]";
                    }
                    if (expr_text == null && field != null && field.getData() != null) {
                        expr_text = String.valueOf(parent_text) + (deref ? "->" : ".") + ((ISymbols.Symbol)field.getData()).getName();
                    }
                    if (expr_text == null && TCFNodeExpression.this.base_text.getData() != null) {
                        expr_text = (String)TCFNodeExpression.this.base_text.getData();
                    }
                }
                if (expr_text != null && (cast = TCFNodeExpression.this.model.getCastToType(TCFNodeExpression.this.id)) != null) {
                    expr_text = "(" + cast + ")(" + expr_text + ")";
                }
                this.set(null, null, expr_text);
                return true;
            }
        };
        this.expression = new TCFNode.TCFData<Expression>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                TCFNode n;
                IExpressions exps = (IExpressions)TCFNodeExpression.this.launch.getService(IExpressions.class);
                if (exps == null) {
                    this.set(null, null, null);
                    return true;
                }
                String cast = TCFNodeExpression.this.model.getCastToType(TCFNodeExpression.this.id);
                if (var_id != null && cast == null) {
                    if (!TCFNodeExpression.this.var_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Expression exp = null;
                    if (TCFNodeExpression.this.var_expression.getData() != null) {
                        exp = new Expression((IExpressions.Expression)TCFNodeExpression.this.var_expression.getData());
                    }
                    this.set(null, TCFNodeExpression.this.var_expression.getError(), exp);
                    return true;
                }
                if (!TCFNodeExpression.this.base_text.validate((Runnable)((Object)this))) {
                    return false;
                }
                String e = (String)TCFNodeExpression.this.base_text.getData();
                if (e == null) {
                    this.set(null, TCFNodeExpression.this.base_text.getError(), null);
                    return true;
                }
                if (cast != null) {
                    e = "(" + cast + ")(" + e + ")";
                }
                if ((n = ((TCFNodeExpression)TCFNodeExpression.this).getRootExpression().parent) instanceof TCFNodeStackFrame && ((TCFNodeStackFrame)n).isEmulated()) {
                    n = n.parent;
                }
                this.command = exps.create(n.id, null, e, new IExpressions.DoneCreate(){

                    public void doneCreate(IToken token, Exception error, IExpressions.Expression context) {
                        Expression e = null;
                        if (context != null) {
                            e = new Expression(context);
                            e.must_be_disposed = true;
                        }
                        if (!this.isDisposed()) {
                            this.set(token, error, e);
                        } else if (e != null) {
                            e.dispose();
                        }
                    }
                });
                return false;
            }

            public void reset() {
                if (this.isValid() && this.getData() != null) {
                    ((Expression)this.getData()).dispose();
                }
                super.reset();
            }

            @Override
            public void dispose() {
                if (this.isValid() && this.getData() != null) {
                    ((Expression)this.getData()).dispose();
                }
                super.dispose();
            }
        };
        this.value = new TCFNode.TCFData<IExpressions.Value>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                Boolean b = TCFNodeExpression.this.usePrevValue((Runnable)((Object)this));
                if (b == null) {
                    return false;
                }
                if (b.booleanValue()) {
                    this.set(null, null, TCFNodeExpression.this.prev_value);
                    return true;
                }
                if (!TCFNodeExpression.this.expression.validate((Runnable)((Object)this))) {
                    return false;
                }
                Expression exp = (Expression)TCFNodeExpression.this.expression.getData();
                if (exp == null) {
                    this.set(null, TCFNodeExpression.this.expression.getError(), null);
                    return true;
                }
                final 6 cache = this;
                IExpressions exps = (IExpressions)TCFNodeExpression.this.launch.getService(IExpressions.class);
                this.command = exps.evaluate(exp.expression.getID(), new IExpressions.DoneEvaluate(){

                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                        if (command != token) {
                            return;
                        }
                        command = null;
                        if (error != null) {
                            Boolean b = TCFNodeExpression.this.usePrevValue((Runnable)cache);
                            if (b == null) {
                                return;
                            }
                            if (b.booleanValue()) {
                                this.set(null, null, TCFNodeExpression.this.prev_value);
                                return;
                            }
                        }
                        this.set(null, error, value);
                    }
                });
                return false;
            }
        };
        this.type = new TCFNode.TCFData<ISymbols.Symbol>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                TCFDataCache<ISymbols.Symbol> sym_cache;
                String type_id = null;
                if (TCFNodeExpression.this.model.getCastToType(TCFNodeExpression.this.id) == null && field_id != null && (sym_cache = TCFNodeExpression.this.model.getSymbolInfoCache(field_id)) != null) {
                    if (!sym_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    ISymbols.Symbol sym_data = (ISymbols.Symbol)sym_cache.getData();
                    if (sym_data != null) {
                        type_id = sym_data.getTypeID();
                    }
                }
                if (type_id == null) {
                    if (!TCFNodeExpression.this.value.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Value val = (IExpressions.Value)TCFNodeExpression.this.value.getData();
                    if (val != null) {
                        type_id = val.getTypeID();
                    }
                }
                if (type_id == null) {
                    if (!TCFNodeExpression.this.expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Expression exp = (Expression)TCFNodeExpression.this.expression.getData();
                    if (exp != null) {
                        type_id = exp.expression.getTypeID();
                    }
                }
                if (type_id == null) {
                    this.set(null, TCFNodeExpression.this.value.getError(), null);
                    return true;
                }
                TCFDataCache<ISymbols.Symbol> type_cache = TCFNodeExpression.this.model.getSymbolInfoCache(type_id);
                if (type_cache == null) {
                    this.set(null, null, null);
                    return true;
                }
                if (!type_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                this.set(null, type_cache.getError(), (ISymbols.Symbol)type_cache.getData());
                return true;
            }
        };
        this.string = new TCFNode.TCFData<String>((TCFNode)this, this.channel){
            IMemory.MemoryContext mem;
            ISymbols.Symbol base_type_data;
            BigInteger addr;
            byte[] buf;
            int size;
            int offs;

            protected boolean startDataRetrieval() {
                if (this.addr != null) {
                    if (this.mem == null) {
                        TCFDataCache<TCFNodeExecContext> mem_node_cache = TCFNodeExpression.this.model.searchMemoryContext(parent);
                        if (mem_node_cache == null) {
                            this.set(null, new Exception("Context does not provide memory access"), null);
                            return true;
                        }
                        if (!mem_node_cache.validate((Runnable)((Object)this))) {
                            return false;
                        }
                        if (mem_node_cache.getError() != null) {
                            this.set(null, mem_node_cache.getError(), null);
                            return true;
                        }
                        TCFNodeExecContext mem_node = (TCFNodeExecContext)mem_node_cache.getData();
                        if (mem_node == null) {
                            this.set(null, new Exception("Context does not provide memory access"), null);
                            return true;
                        }
                        TCFDataCache<IMemory.MemoryContext> mem_ctx_cache = mem_node.getMemoryContext();
                        if (!mem_ctx_cache.validate((Runnable)((Object)this))) {
                            return false;
                        }
                        if (mem_ctx_cache.getError() != null) {
                            this.set(null, mem_ctx_cache.getError(), null);
                            return true;
                        }
                        this.mem = (IMemory.MemoryContext)mem_ctx_cache.getData();
                        if (this.mem == null) {
                            this.set(null, new Exception("Context does not provide memory access"), null);
                            return true;
                        }
                    }
                    if (this.size == 0) {
                        if (this.buf == null) {
                            this.buf = new byte[256];
                        }
                        if (this.offs >= this.buf.length) {
                            byte[] tmp = new byte[this.buf.length * 2];
                            System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
                            this.buf = tmp;
                        }
                        this.command = this.mem.get((Number)this.addr.add(BigInteger.valueOf(this.offs)), 1, this.buf, this.offs, 1, 0, new IMemory.DoneMemory(){

                            public void doneMemory(IToken token, IMemory.MemoryError error) {
                                if (error != null) {
                                    this.set(command, (Throwable)error, null);
                                } else if (buf[offs] == 0 || offs >= 2048) {
                                    this.set(command, null, TCFNodeExpression.this.toASCIIString(buf, 0, offs, '\"'));
                                } else if (command == token) {
                                    command = null;
                                    ++offs;
                                    this.run();
                                }
                            }
                        });
                        return false;
                    }
                    if (this.offs != this.size) {
                        if (this.buf == null || this.buf.length < this.size) {
                            this.buf = new byte[this.size];
                        }
                        this.command = this.mem.get((Number)this.addr, 1, this.buf, 0, this.size, 0, new IMemory.DoneMemory(){

                            public void doneMemory(IToken token, IMemory.MemoryError error) {
                                if (error != null) {
                                    this.set(command, (Throwable)error, null);
                                } else if (command == token) {
                                    command = null;
                                    offs = size;
                                    this.run();
                                }
                            }
                        });
                        return false;
                    }
                    StyledStringBuffer bf = new StyledStringBuffer();
                    bf.append('{');
                    if (!TCFNodeExpression.this.appendCompositeValueText(bf, 1, this.base_type_data, this.buf, 0, this.size, this.mem.isBigEndian(), (Runnable)((Object)this))) {
                        return false;
                    }
                    bf.append('}');
                    this.set(null, null, bf.toString());
                    return true;
                }
                if (!TCFNodeExpression.this.type.validate((Runnable)((Object)this))) {
                    return false;
                }
                ISymbols.Symbol type_data = (ISymbols.Symbol)TCFNodeExpression.this.type.getData();
                if (type_data != null) {
                    switch (type_data.getTypeClass()) {
                        case pointer: 
                        case array: {
                            TCFDataCache<ISymbols.Symbol> base_type_cahce = TCFNodeExpression.this.model.getSymbolInfoCache(type_data.getBaseTypeID());
                            if (base_type_cahce == null) break;
                            if (!base_type_cahce.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            this.base_type_data = (ISymbols.Symbol)base_type_cahce.getData();
                            if (this.base_type_data == null) break;
                            this.offs = 0;
                            this.size = this.base_type_data.getSize();
                            switch (this.base_type_data.getTypeClass()) {
                                case cardinal: 
                                case integer: {
                                    if (this.base_type_data.getSize() != 1) break;
                                    this.size = 0;
                                }
                                case composite: {
                                    if (this.base_type_data.getSize() == 0 || type_data.getTypeClass() == ISymbols.TypeClass.array && this.base_type_data.getTypeClass() == ISymbols.TypeClass.composite) break;
                                    if (!TCFNodeExpression.this.value.validate((Runnable)((Object)this))) {
                                        return false;
                                    }
                                    IExpressions.Value v = (IExpressions.Value)TCFNodeExpression.this.value.getData();
                                    if (v == null) break;
                                    byte[] data = v.getValue();
                                    if (type_data.getTypeClass() == ISymbols.TypeClass.array) {
                                        this.set(null, null, TCFNodeExpression.this.toASCIIString(data, 0, data.length, '\"'));
                                        return true;
                                    }
                                    BigInteger a = TCFNumberFormat.toBigInteger(data, v.isBigEndian(), false);
                                    if (a.equals(BigInteger.valueOf(0L))) break;
                                    this.addr = a;
                                    Protocol.invokeLater((Runnable)((Object)this));
                                    return false;
                                }
                            }
                            break;
                        }
                        case cardinal: 
                        case integer: {
                            if (type_data.getSize() != 1) break;
                            if (!TCFNodeExpression.this.value.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            IExpressions.Value v = (IExpressions.Value)TCFNodeExpression.this.value.getData();
                            if (v == null) break;
                            byte[] data = v.getValue();
                            this.set(null, null, TCFNodeExpression.this.toASCIIString(data, 0, data.length, '\''));
                            return true;
                        }
                    }
                }
                this.set(null, null, null);
                return true;
            }

            public void reset() {
                super.reset();
                this.mem = null;
                this.addr = null;
            }
        };
        this.type_name = new TCFNode.TCFData<String>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                StringBuffer bf;
                if (!TCFNodeExpression.this.type.validate((Runnable)((Object)this))) {
                    return false;
                }
                if (TCFNodeExpression.this.type.getData() == null) {
                    String s;
                    if (!TCFNodeExpression.this.value.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Value val = (IExpressions.Value)TCFNodeExpression.this.value.getData();
                    if (val != null && val.getValue() != null && (s = TCFNodeExpression.this.getTypeName(val.getTypeClass(), val.getValue().length)) != null) {
                        this.set(null, null, s);
                        return true;
                    }
                }
                if (!TCFNodeExpression.this.getTypeName(bf = new StringBuffer(), (TCFDataCache<ISymbols.Symbol>)TCFNodeExpression.this.type, (Runnable)((Object)this))) {
                    return false;
                }
                this.set(null, null, bf.toString());
                return true;
            }
        };
        this.children = new TCFChildrenSubExpressions(this, 0, 0, 0);
    }

    private TCFNodeExpression getRootExpression() {
        TCFNode n = this;
        while (n.parent instanceof TCFNodeExpression || n.parent instanceof TCFNodeArrayPartition) {
            n = n.parent;
        }
        return n;
    }

    private void postAllChangedDelta() {
        TCFNodeExpression n = this.getRootExpression();
        for (TCFModelProxy p : this.model.getModelProxies()) {
            String id = p.getPresentationContext().getId();
            if (!("org.eclipse.debug.ui.ExpressionView".equals(id) && n.script != null || "org.eclipse.tcf.debug.ui.expression_hover".equals(id) && n.script != null) && (!"org.eclipse.debug.ui.VariableView".equals(id) || n.script != null)) continue;
            p.addDelta(this, 3072);
        }
    }

    private void resetBaseText() {
        if (this.parent_value != null && this.base_text.isValid()) {
            this.base_text.reset();
            this.expression.cancel();
            this.string.cancel();
            this.value.cancel();
        }
    }

    void onSuspended(boolean func_call) {
        if (!func_call) {
            this.prev_value = this.next_value;
            this.type.reset();
            this.type_name.reset();
        }
        if (this.expression.isValid() && this.expression.getError() != null) {
            this.expression.reset();
        }
        if (!func_call || this.value.isValid() && this.value.getError() != null) {
            this.value.reset();
        }
        if (!func_call || this.string.isValid() && this.string.getError() != null) {
            this.string.reset();
        }
        this.children.onSuspended(func_call);
        if (!func_call) {
            this.resetBaseText();
        }
    }

    void onRegisterValueChanged() {
        this.value.reset();
        this.type.reset();
        this.type_name.reset();
        this.string.reset();
        this.children.onRegisterValueChanged();
        this.resetBaseText();
        this.postAllChangedDelta();
    }

    void onMemoryChanged() {
        this.value.reset();
        this.type.reset();
        this.type_name.reset();
        this.string.reset();
        this.children.onMemoryChanged();
        this.resetBaseText();
        if (this.parent instanceof TCFNodeExpression) {
            return;
        }
        if (this.parent instanceof TCFNodeArrayPartition) {
            return;
        }
        this.postAllChangedDelta();
    }

    void onMemoryMapChanged() {
        this.value.reset();
        this.type.reset();
        this.type_name.reset();
        this.string.reset();
        this.children.onMemoryMapChanged();
        this.resetBaseText();
        if (this.parent instanceof TCFNodeExpression) {
            return;
        }
        if (this.parent instanceof TCFNodeArrayPartition) {
            return;
        }
        this.postAllChangedDelta();
    }

    void onValueChanged() {
        this.value.reset();
        this.type.reset();
        this.type_name.reset();
        this.string.reset();
        this.children.onValueChanged();
        this.resetBaseText();
        this.postAllChangedDelta();
    }

    @Override
    public void onCastToTypeChanged() {
        this.expression.cancel();
        this.value.cancel();
        this.type.cancel();
        this.type_name.cancel();
        this.string.cancel();
        this.expression_text.cancel();
        this.children.onCastToTypeChanged();
        this.resetBaseText();
        this.postAllChangedDelta();
    }

    public boolean isEmpty() {
        return this.is_empty;
    }

    public String getScript() {
        return this.script;
    }

    String getFieldID() {
        return this.field_id;
    }

    String getRegisterID() {
        return this.reg_id;
    }

    int getIndex() {
        return this.index;
    }

    boolean isDeref() {
        return this.deref;
    }

    void setSortPosition(int sort_pos) {
        this.sort_pos = sort_pos;
    }

    void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.postAllChangedDelta();
    }

    public TCFDataCache<IExpressions.Expression> getVariable() {
        return this.var_expression;
    }

    public TCFDataCache<IExpressions.Value> getValue() {
        return this.value;
    }

    @Override
    public TCFDataCache<ISymbols.Symbol> getType() {
        return this.type;
    }

    @Override
    public TCFDataCache<String> getExpressionText() {
        return this.expression_text;
    }

    private Boolean usePrevValue(Runnable done) {
        if (this.prev_value == null) {
            return false;
        }
        if (this.parent instanceof TCFNodeStackFrame) {
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent.parent;
            TCFDataCache<TCFContextState> state_cache = exe.getState();
            if (!state_cache.validate(done)) {
                return null;
            }
            TCFContextState state = (TCFContextState)state_cache.getData();
            if (state == null || !state.is_suspended) {
                return true;
            }
            TCFChildrenStackTrace stack_trace_cache = exe.getStackTrace();
            if (!stack_trace_cache.validate(done)) {
                return null;
            }
            if (((Map)stack_trace_cache.getData()).get(this.parent.id) == null) {
                return true;
            }
        } else if (this.parent instanceof TCFNodeExecContext) {
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent;
            TCFDataCache<TCFContextState> state_cache = exe.getState();
            if (!state_cache.validate(done)) {
                return null;
            }
            TCFContextState state = (TCFContextState)state_cache.getData();
            if (state == null || !state.is_suspended) {
                return true;
            }
        }
        return false;
    }

    private String getTypeName(ISymbols.TypeClass type_class, int size) {
        String s = null;
        switch (type_class) {
            case integer: {
                if (size == 0) {
                    s = "<Void>";
                    break;
                }
                s = "<Integer-" + size * 8 + ">";
                break;
            }
            case cardinal: {
                if (size == 0) {
                    s = "<Void>";
                    break;
                }
                s = "<Unsigned-" + size * 8 + ">";
                break;
            }
            case real: {
                s = size == 0 ? "<Void>" : "<Float-" + size * 8 + ">";
            }
        }
        return s;
    }

    private boolean getTypeName(StringBuffer bf, TCFDataCache<ISymbols.Symbol> type_cache, Runnable done) {
        String name;
        block40: {
            ISymbols.Symbol type_symbol;
            name = null;
            do {
                String s = null;
                boolean get_base_type = false;
                if (!type_cache.validate(done)) {
                    return false;
                }
                type_symbol = (ISymbols.Symbol)type_cache.getData();
                if (type_symbol != null) {
                    TCFDataCache<ISymbols.Symbol> base_type_cache;
                    int flags = type_symbol.getFlags();
                    s = type_symbol.getName();
                    if (s != null) {
                        if ((flags & 0x80) != 0) {
                            s = "union " + s;
                        } else if ((flags & 0x100) != 0) {
                            s = "class " + s;
                        } else if ((flags & 0x200) != 0) {
                            s = "interface " + s;
                        } else if ((flags & 0x800000) != 0) {
                            s = "struct " + s;
                        } else if ((flags & 0x400000) != 0) {
                            s = "enum " + s;
                        }
                    } else if (!type_symbol.getID().equals(type_symbol.getTypeID()) && (base_type_cache = this.model.getSymbolInfoCache(type_symbol.getTypeID())) != null) {
                        StringBuffer sb = new StringBuffer();
                        if (!this.getTypeName(sb, base_type_cache, done)) {
                            return false;
                        }
                        s = sb.toString();
                    }
                    if (s == null) {
                        s = this.getTypeName(type_symbol.getTypeClass(), type_symbol.getSize());
                    }
                    if (s == null) {
                        switch (type_symbol.getTypeClass()) {
                            case pointer: {
                                s = "*";
                                if ((flags & 0x800) != 0) {
                                    s = "&";
                                }
                                get_base_type = true;
                                break;
                            }
                            case member_pointer: {
                                String id = type_symbol.getContainerID();
                                if (id != null) {
                                    String cls_name;
                                    TCFDataCache<ISymbols.Symbol> cls_cache = this.model.getSymbolInfoCache(id);
                                    if (!cls_cache.validate(done)) {
                                        return false;
                                    }
                                    ISymbols.Symbol cls_data = (ISymbols.Symbol)cls_cache.getData();
                                    if (cls_data != null && (cls_name = cls_data.getName()) != null) {
                                        s = String.valueOf(cls_name) + "::*";
                                    }
                                }
                                if (s == null) {
                                    s = "::*";
                                }
                                get_base_type = true;
                                break;
                            }
                            case array: {
                                s = "[" + type_symbol.getLength() + "]";
                                get_base_type = true;
                                break;
                            }
                            case composite: {
                                s = "<Structure>";
                                break;
                            }
                            case function: {
                                String[] children;
                                TCFDataCache<String[]> children_cache = this.model.getSymbolChildrenCache(type_symbol.getID());
                                if (!children_cache.validate(done)) {
                                    return false;
                                }
                                if (children_cache.getError() == null && (children = (String[])children_cache.getData()) != null) {
                                    StringBuffer args = new StringBuffer();
                                    if (name != null) {
                                        args.append('(');
                                        args.append(name);
                                        args.append(')');
                                        name = null;
                                    }
                                    args.append('(');
                                    String[] stringArray = children;
                                    int n = children.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String id = stringArray[n2];
                                        if (id != children[0]) {
                                            args.append(',');
                                        }
                                        if (!this.getTypeName(args, this.model.getSymbolInfoCache(id), done)) {
                                            return false;
                                        }
                                        ++n2;
                                    }
                                    args.append(')');
                                    s = args.toString();
                                    get_base_type = true;
                                    break;
                                }
                                s = "<Function>";
                            }
                        }
                    }
                    if (s != null) {
                        if ((flags & 0x20) != 0) {
                            s = "volatile " + s;
                        }
                        if ((flags & 4) != 0) {
                            s = "const " + s;
                        }
                    }
                }
                if (s == null) {
                    name = "N/A";
                    break block40;
                }
                name = name == null ? s : (!get_base_type ? String.valueOf(s) + " " + name : String.valueOf(s) + name);
                if (!get_base_type) break block40;
            } while ((type_cache = this.model.getSymbolInfoCache(type_symbol.getBaseTypeID())) != null);
            name = "N/A";
        }
        bf.append(name);
        return true;
    }

    private String toASCIIString(byte[] data, int offs, int size, char quote_char) {
        StringBuffer bf = new StringBuffer();
        bf.append(quote_char);
        int i = 0;
        while (i < size) {
            int ch = data[offs + i] & 0xFF;
            if (ch >= 32 && ch < 127) {
                bf.append((char)ch);
            } else {
                switch (ch) {
                    case 13: {
                        bf.append("\\r");
                        break;
                    }
                    case 10: {
                        bf.append("\\n");
                        break;
                    }
                    case 8: {
                        bf.append("\\b");
                        break;
                    }
                    case 9: {
                        bf.append("\\t");
                        break;
                    }
                    case 12: {
                        bf.append("\\f");
                        break;
                    }
                    default: {
                        bf.append('\\');
                        bf.append((char)(48 + ch / 64));
                        bf.append((char)(48 + ch / 8 % 8));
                        bf.append((char)(48 + ch % 8));
                    }
                }
            }
            ++i;
        }
        if (data.length <= offs + size || data[offs + size] == 0) {
            bf.append(quote_char);
        } else {
            bf.append("...");
        }
        return bf.toString();
    }

    private String toNumberString(int radix, ISymbols.TypeClass t, byte[] data, int offs, int size, boolean big_endian) {
        if (size <= 0 || size > 16) {
            return "";
        }
        if (radix != 16) {
            switch (t) {
                case array: 
                case composite: {
                    return "";
                }
            }
        }
        String s = null;
        if (data == null) {
            s = "N/A";
        }
        if (s == null && radix == 10 && t != null) {
            switch (t) {
                case integer: {
                    s = TCFNumberFormat.toBigInteger(data, offs, size, big_endian, true).toString();
                    break;
                }
                case real: {
                    s = TCFNumberFormat.toFPString(data, offs, size, big_endian);
                }
            }
        }
        if (s == null) {
            s = TCFNumberFormat.toBigInteger(data, offs, size, big_endian, false).toString(radix);
            switch (radix) {
                case 8: {
                    if (s.startsWith("0")) break;
                    s = "0" + s;
                    break;
                }
                case 16: {
                    if (s.length() >= size * 2) break;
                    StringBuffer bf = new StringBuffer();
                    while (bf.length() + s.length() < size * 2) {
                        bf.append('0');
                    }
                    bf.append(s);
                    s = bf.toString();
                }
            }
        }
        assert (s != null);
        return s;
    }

    private String toNumberString(int radix) {
        byte[] data;
        String s = null;
        IExpressions.Value val = (IExpressions.Value)this.value.getData();
        if (val != null && (data = val.getValue()) != null) {
            ISymbols.TypeClass t = val.getTypeClass();
            if (t == ISymbols.TypeClass.unknown && this.type.getData() != null) {
                t = ((ISymbols.Symbol)this.type.getData()).getTypeClass();
            }
            s = this.toNumberString(radix, t, data, 0, data.length, val.isBigEndian());
        }
        if (s == null) {
            s = "N/A";
        }
        return s;
    }

    private void setLabel(ILabelUpdate result, String name, int col, int radix) {
        String s = this.toNumberString(radix);
        if (name == null) {
            result.setLabel(s, col);
        } else {
            result.setLabel(String.valueOf(name) + " = " + s, col);
        }
    }

    private boolean isValueChanged(IExpressions.Value x, IExpressions.Value y) {
        if (x == null || y == null) {
            return false;
        }
        byte[] xb = x.getValue();
        byte[] yb = y.getValue();
        if (xb == null || yb == null) {
            return false;
        }
        if (xb.length != yb.length) {
            return true;
        }
        int i = 0;
        while (i < xb.length) {
            if (xb[i] != yb[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected boolean getData(ILabelUpdate result, Runnable done) {
        if (this.is_empty) {
            result.setLabel("Add new expression", 0);
            result.setImageDescriptor(ImageCache.getImageDescriptor("icons/full/elcl16/monitorexpression_tsk.gif"), 0);
        } else if (this.enabled || this.script == null) {
            String c;
            int i;
            Throwable error;
            String cast;
            TCFDataCache<ISymbols.Symbol> var;
            TCFDataCache<ISymbols.Symbol> field = this.model.getSymbolInfoCache(this.field_id);
            TCFDataCache<ISymbols.Symbol> pending = null;
            if (field != null && !field.validate()) {
                pending = field;
            }
            if (this.reg_id != null && !this.expression_text.validate(done)) {
                pending = this.expression_text;
            }
            if (!this.var_expression.validate()) {
                pending = this.var_expression;
            }
            if (!this.base_text.validate()) {
                pending = this.base_text;
            }
            if (!this.value.validate()) {
                pending = this.value;
            }
            if (!this.type.validate()) {
                pending = this.type;
            }
            if (pending != null) {
                pending.wait(done);
                return false;
            }
            String name = null;
            if (this.index >= 0) {
                name = this.index == 0 && this.deref ? "*" : "[" + this.index + "]";
            }
            if (name == null && field != null && field.getData() != null) {
                name = ((ISymbols.Symbol)field.getData()).getName();
            }
            if (name == null && this.reg_id != null && this.expression_text.getData() != null) {
                name = (String)this.expression_text.getData();
            }
            if (name == null && this.var_expression.getData() != null && (var = this.model.getSymbolInfoCache(((IExpressions.Expression)this.var_expression.getData()).getSymbolID())) != null) {
                if (!var.validate(done)) {
                    return false;
                }
                ISymbols.Symbol var_data = (ISymbols.Symbol)var.getData();
                if (var_data != null) {
                    name = var_data.getName();
                    if (name == null && var_data.getFlag(65536)) {
                        name = "<VarArg>";
                    }
                    if (name == null) {
                        name = "<" + var_data.getID() + ">";
                    }
                }
            }
            if (name == null && this.base_text.getData() != null) {
                name = (String)this.base_text.getData();
            }
            if (name != null && (cast = this.model.getCastToType(this.id)) != null) {
                name = "(" + cast + ")(" + name + ")";
            }
            if ((error = this.base_text.getError()) == null) {
                error = this.value.getError();
            }
            String[] cols = result.getColumnIds();
            if (error != null) {
                if (cols == null || cols.length <= 1) {
                    result.setForeground(rgb_error, 0);
                    result.setLabel(String.valueOf(name) + ": N/A", 0);
                } else {
                    i = 0;
                    while (i < cols.length) {
                        c = cols[i];
                        if (c.equals("Name")) {
                            result.setLabel(name, i);
                        } else if (c.equals("Type")) {
                            if (!this.type_name.validate(done)) {
                                return false;
                            }
                            result.setLabel((String)this.type_name.getData(), i);
                        } else {
                            result.setForeground(rgb_error, i);
                            result.setLabel("N/A", i);
                        }
                        ++i;
                    }
                }
            } else if (cols == null) {
                this.setLabel(result, name, 0, 16);
            } else {
                i = 0;
                while (i < cols.length) {
                    c = cols[i];
                    if (c.equals("Name")) {
                        result.setLabel(name, i);
                    } else if (c.equals("Type")) {
                        if (!this.type_name.validate(done)) {
                            return false;
                        }
                        result.setLabel((String)this.type_name.getData(), i);
                    } else if (c.equals("HexValue")) {
                        this.setLabel(result, null, i, 16);
                    } else if (c.equals("DecValue")) {
                        this.setLabel(result, null, i, 10);
                    }
                    ++i;
                }
            }
            this.next_value = (IExpressions.Value)this.value.getData();
            if (this.isValueChanged(this.prev_value, this.next_value)) {
                result.setBackground(rgb_highlight, 0);
                if (cols != null) {
                    i = 1;
                    while (i < cols.length) {
                        result.setBackground(rgb_highlight, i);
                        ++i;
                    }
                }
            }
            ISymbols.TypeClass type_class = ISymbols.TypeClass.unknown;
            ISymbols.Symbol type_symbol = (ISymbols.Symbol)this.type.getData();
            if (type_symbol != null) {
                type_class = type_symbol.getTypeClass();
            }
            switch (type_class) {
                case pointer: {
                    result.setImageDescriptor(ImageCache.getImageDescriptor("icons/var_pointer.gif"), 0);
                    break;
                }
                case array: 
                case composite: {
                    result.setImageDescriptor(ImageCache.getImageDescriptor("icons/var_aggr.gif"), 0);
                    break;
                }
                default: {
                    result.setImageDescriptor(ImageCache.getImageDescriptor("icons/var_simple.gif"), 0);
                    break;
                }
            }
        } else {
            String[] cols = result.getColumnIds();
            if (cols == null || cols.length <= 1) {
                result.setForeground(rgb_disabled, 0);
                result.setLabel(this.script, 0);
            } else {
                int i = 0;
                while (i < cols.length) {
                    String c = cols[i];
                    if (c.equals("Name")) {
                        result.setForeground(rgb_disabled, i);
                        result.setLabel(this.script, i);
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    @Override
    protected void getFontData(ILabelUpdate update, String view_id) {
        if (this.is_empty) {
            update.setFontData(TCFModelFonts.getItalicFontData(view_id), 0);
        } else {
            FontData fn = TCFModelFonts.getNormalFontData(view_id);
            String[] cols = update.getColumnIds();
            if (cols == null || cols.length == 0) {
                update.setFontData(fn, 0);
            } else {
                String[] ids = update.getColumnIds();
                int i = 0;
                while (i < cols.length) {
                    if ("HexValue".equals(ids[i]) || "DecValue".equals(ids[i])) {
                        update.setFontData(TCFModelFonts.getMonospacedFontData(view_id), i);
                    } else {
                        update.setFontData(fn, i);
                    }
                    ++i;
                }
            }
        }
    }

    private boolean appendArrayValueText(StyledStringBuffer bf, int level, ISymbols.Symbol type, byte[] data, int offs, int size, boolean big_endian, Runnable done) {
        assert (offs + size <= data.length);
        int length = type.getLength();
        bf.append('[');
        if (length > 0) {
            int elem_size = size / length;
            int n = 0;
            while (n < length) {
                if (n >= 100) {
                    bf.append("...");
                    break;
                }
                if (n > 0) {
                    bf.append(", ");
                }
                if (!this.appendValueText(bf, level + 1, type.getBaseTypeID(), data, offs + n * elem_size, elem_size, big_endian, done)) {
                    return false;
                }
                ++n;
            }
        }
        bf.append(']');
        return true;
    }

    private boolean appendCompositeValueText(StyledStringBuffer bf, int level, ISymbols.Symbol type, byte[] data, int offs, int size, boolean big_endian, Runnable done) {
        TCFDataCache<String[]> children_cache = this.model.getSymbolChildrenCache(type.getID());
        if (children_cache == null) {
            bf.append("...");
            return true;
        }
        if (!children_cache.validate(done)) {
            return false;
        }
        String[] children_data = (String[])children_cache.getData();
        if (children_data == null) {
            bf.append("...");
            return true;
        }
        int cnt = 0;
        TCFDataCache<ISymbols.Symbol> pending = null;
        String[] stringArray = children_data;
        int n = children_data.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TCFDataCache<ISymbols.Symbol> field_cache = this.model.getSymbolInfoCache(id);
            if (!field_cache.validate()) {
                pending = field_cache;
            } else {
                ISymbols.Symbol field_data = (ISymbols.Symbol)field_cache.getData();
                if (field_data != null && field_data.getSymbolClass() == ISymbols.SymbolClass.reference) {
                    String name = field_data.getName();
                    int f_offs = field_data.getOffset();
                    int f_size = field_data.getSize();
                    if (name == null) {
                        if (offs + f_offs + f_size <= data.length) {
                            StyledStringBuffer bf1 = new StyledStringBuffer();
                            if (!this.appendCompositeValueText(bf1, level, field_data, data, offs + f_offs, f_size, big_endian, done)) {
                                return false;
                            }
                            if (bf1.length() > 0) {
                                if (cnt > 0) {
                                    bf.append(", ");
                                }
                                bf.append(bf1);
                                ++cnt;
                            }
                        }
                    } else {
                        if (cnt > 0) {
                            bf.append(", ");
                        }
                        bf.append(name);
                        bf.append('=');
                        if (offs + f_offs + f_size > data.length) {
                            bf.append('?');
                        } else if (!this.appendValueText(bf, level + 1, field_data.getTypeID(), data, offs + f_offs, f_size, big_endian, done)) {
                            return false;
                        }
                        ++cnt;
                    }
                }
            }
            ++n2;
        }
        if (pending == null) {
            return true;
        }
        pending.wait(done);
        return false;
    }

    private void appendNumericValueText(StyledStringBuffer bf, ISymbols.TypeClass type_class, byte[] data, int offs, int size, boolean big_endian) {
        bf.append("Hex: ", 1);
        bf.append(this.toNumberString(16, type_class, data, offs, size, big_endian), 4);
        bf.append(", ");
        bf.append("Dec: ", 1);
        bf.append(this.toNumberString(10, type_class, data, offs, size, big_endian), 4);
        bf.append(", ");
        bf.append("Oct: ", 1);
        bf.append(this.toNumberString(8, type_class, data, offs, size, big_endian), 4);
        bf.append('\n');
    }

    private boolean appendValueText(StyledStringBuffer bf, int level, String type_id, byte[] data, int offs, int size, boolean big_endian, Runnable done) {
        ISymbols.TypeClass type_class;
        if (data == null) {
            return true;
        }
        ISymbols.Symbol type_data = null;
        if (type_id != null) {
            TCFDataCache<ISymbols.Symbol> type_cache = this.model.getSymbolInfoCache(type_id);
            if (!type_cache.validate(done)) {
                return false;
            }
            type_data = (ISymbols.Symbol)type_cache.getData();
        }
        if (type_data == null) {
            type_class = ISymbols.TypeClass.unknown;
            if (!this.value.validate(done)) {
                return false;
            }
            if (this.value.getData() != null) {
                type_class = ((IExpressions.Value)this.value.getData()).getTypeClass();
            }
            if (level == 0) {
                String s;
                assert (offs == 0);
                assert (size == data.length);
                if (size > 0) {
                    this.appendNumericValueText(bf, type_class, data, offs, size, big_endian);
                }
                if ((s = this.getTypeName(type_class, size)) == null) {
                    s = "not available";
                }
                bf.append("Size: ", 1);
                bf.append(size);
                bf.append(size == 1 ? " byte" : " bytes");
                bf.append(", ");
                bf.append("Type: ", 1);
                bf.append(s);
                bf.append('\n');
            } else if (type_class == ISymbols.TypeClass.integer || type_class == ISymbols.TypeClass.real) {
                bf.append(this.toNumberString(10, type_class, data, offs, size, big_endian), 4);
            } else {
                bf.append(this.toNumberString(16, type_class, data, offs, size, big_endian), 4);
            }
            return true;
        }
        if (level == 0) {
            if (!this.string.validate(done)) {
                return false;
            }
            Throwable e = this.string.getError();
            String s = (String)this.string.getData();
            if (s != null) {
                bf.append(s);
                bf.append('\n');
            } else if (e != null) {
                bf.append("Cannot read pointed value: ", 1, null, rgb_error);
                bf.append(TCFModel.getErrorMessage(e, false), 2, null, rgb_error);
                bf.append('\n');
            }
        }
        if (type_data.getSize() > 0) {
            type_class = type_data.getTypeClass();
            switch (type_class) {
                case cardinal: 
                case integer: 
                case real: 
                case enumeration: {
                    if (level == 0) {
                        this.appendNumericValueText(bf, type_class, data, offs, size, big_endian);
                        break;
                    }
                    if (type_data.getTypeClass() == ISymbols.TypeClass.cardinal) {
                        bf.append("0x");
                        bf.append(this.toNumberString(16, type_class, data, offs, size, big_endian), 4);
                        break;
                    }
                    bf.append(this.toNumberString(10, type_class, data, offs, size, big_endian), 4);
                    break;
                }
                case pointer: 
                case function: 
                case member_pointer: {
                    if (level == 0) {
                        this.appendNumericValueText(bf, type_class, data, offs, size, big_endian);
                        break;
                    }
                    bf.append("0x");
                    bf.append(this.toNumberString(16, type_class, data, offs, size, big_endian), 4);
                    break;
                }
                case array: {
                    if (!this.appendArrayValueText(bf, level, type_data, data, offs, size, big_endian, done)) {
                        return false;
                    }
                    if (level != 0) break;
                    bf.append('\n');
                    break;
                }
                case composite: {
                    bf.append('{');
                    if (!this.appendCompositeValueText(bf, level, type_data, data, offs, size, big_endian, done)) {
                        return false;
                    }
                    bf.append('}');
                    if (level != 0) break;
                    bf.append('\n');
                }
            }
        }
        if (level == 0) {
            if (!this.type_name.validate(done)) {
                return false;
            }
            bf.append("Size: ", 1);
            bf.append(type_data.getSize());
            bf.append(type_data.getSize() == 1 ? " byte" : " bytes");
            String nm = (String)this.type_name.getData();
            if (nm != null) {
                bf.append(", ");
                bf.append("Type: ", 1);
                bf.append(nm);
            }
            bf.append('\n');
        }
        return true;
    }

    private String getRegisterName(String reg_id, Runnable done) {
        String name = reg_id;
        TCFChildren pending = null;
        TCFNodeRegister reg_node = null;
        LinkedList<TCFChildren> queue = new LinkedList<TCFChildren>();
        TCFNode n = this.parent;
        while (n != null) {
            if (n instanceof TCFNodeStackFrame) {
                queue.add(((TCFNodeStackFrame)n).getRegisters());
            }
            if (n instanceof TCFNodeExecContext) {
                queue.add(((TCFNodeExecContext)n).getRegisters());
                break;
            }
            n = n.parent;
        }
        while (!queue.isEmpty()) {
            TCFChildren reg_list = (TCFChildren)((Object)queue.removeFirst());
            if (!reg_list.validate()) {
                pending = reg_list;
                continue;
            }
            Map reg_map = (Map)reg_list.getData();
            if (reg_map == null) continue;
            reg_node = (TCFNodeRegister)reg_map.get(reg_id);
            if (reg_node != null) break;
            for (TCFNode node : reg_map.values()) {
                queue.add(((TCFNodeRegister)node).getChildren());
            }
        }
        if (pending != null) {
            pending.wait(done);
            return null;
        }
        if (reg_node != null) {
            TCFDataCache<IRegisters.RegistersContext> reg_ctx_cache = reg_node.getContext();
            if (!reg_ctx_cache.validate(done)) {
                return null;
            }
            IRegisters.RegistersContext reg_ctx_data = (IRegisters.RegistersContext)reg_ctx_cache.getData();
            if (reg_ctx_data != null && reg_ctx_data.getName() != null) {
                name = reg_ctx_data.getName();
            }
        }
        return name;
    }

    @Override
    public boolean getDetailText(StyledStringBuffer bf, Runnable done) {
        IExpressions.Value v;
        if (this.is_empty) {
            return true;
        }
        if (!this.enabled) {
            bf.append("Disabled");
            return true;
        }
        if (!this.expression.validate(done)) {
            return false;
        }
        if (!this.value.validate(done)) {
            return false;
        }
        int pos = bf.length();
        bf.append(this.expression.getError(), rgb_error);
        if (bf.length() == pos) {
            bf.append(this.value.getError(), rgb_error);
        }
        if (bf.length() == pos && (v = (IExpressions.Value)this.value.getData()) != null) {
            Number addr;
            String reg_id;
            byte[] data = v.getValue();
            if (data != null) {
                boolean big_endian = v.isBigEndian();
                if (!this.appendValueText(bf, 0, v.getTypeID(), data, 0, data.length, big_endian, done)) {
                    return false;
                }
            }
            if ((reg_id = v.getRegisterID()) != null) {
                String nm = this.getRegisterName(reg_id, done);
                if (nm == null) {
                    return false;
                }
                bf.append("Register: ", 1);
                bf.append(nm);
                bf.append('\n');
            }
            if ((addr = v.getAddress()) != null) {
                BigInteger i = JSON.toBigInteger((Number)addr);
                bf.append("Address: ", 1);
                bf.append("0x", 4);
                bf.append(i.toString(16), 4);
                bf.append('\n');
            }
        }
        return true;
    }

    public String getValueText(boolean add_error_text, Runnable done) {
        byte[] data;
        if (!this.expression.validate(done)) {
            return null;
        }
        if (!this.value.validate(done)) {
            return null;
        }
        StyledStringBuffer bf = new StyledStringBuffer();
        IExpressions.Value v = (IExpressions.Value)this.value.getData();
        if (v != null && (data = v.getValue()) != null) {
            boolean big_endian = v.isBigEndian();
            if (!this.appendValueText(bf, 1, v.getTypeID(), data, 0, data.length, big_endian, done)) {
                return null;
            }
        }
        if (add_error_text) {
            if (bf.length() == 0 && this.expression.getError() != null) {
                bf.append(TCFModel.getErrorMessage(this.expression.getError(), false));
            }
            if (bf.length() == 0 && this.value.getError() != null) {
                bf.append(TCFModel.getErrorMessage(this.value.getError(), false));
            }
        }
        return bf.toString();
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        if (!this.is_empty && this.enabled) {
            if (!this.children.validate(done)) {
                return false;
            }
            result.setChildCount(this.children.size());
        } else {
            result.setChildCount(0);
        }
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        if (this.is_empty || !this.enabled) {
            return true;
        }
        return this.children.getData(result, done);
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        if (!this.is_empty && this.enabled) {
            if (!this.children.validate(done)) {
                return false;
            }
            result.setHasChilren(this.children.size() > 0);
        } else {
            result.setHasChilren(false);
        }
        return true;
    }

    @Override
    public int compareTo(TCFNode n) {
        TCFNodeExpression e = (TCFNodeExpression)n;
        if (this.sort_pos < e.sort_pos) {
            return -1;
        }
        if (this.sort_pos > e.sort_pos) {
            return 1;
        }
        return 0;
    }

    public CellEditor getCellEditor(IPresentationContext context, String column_id, Object element, Composite parent) {
        assert (element == this);
        if ("Name".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        if ("HexValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        if ("DecValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        assert (element == this);
        return cell_modifier;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (this.script != null) {
            IExpression e;
            int n;
            int n2;
            IExpression[] iExpressionArray;
            IExpressionManager m;
            if (adapter == IExpression.class) {
                m = DebugPlugin.getDefault().getExpressionManager();
                iExpressionArray = m.getExpressions();
                n2 = iExpressionArray.length;
                n = 0;
                while (n < n2) {
                    e = iExpressionArray[n];
                    if (this.script.equals(e.getExpressionText())) {
                        return e;
                    }
                    ++n;
                }
            }
            if (adapter == IWatchExpression.class) {
                m = DebugPlugin.getDefault().getExpressionManager();
                iExpressionArray = m.getExpressions();
                n2 = iExpressionArray.length;
                n = 0;
                while (n < n2) {
                    e = iExpressionArray[n];
                    if (e instanceof IWatchExpression && this.script.equals(e.getExpressionText())) {
                        return e;
                    }
                    ++n;
                }
            }
        }
        return super.getAdapter(adapter);
    }

    private class Expression {
        final IExpressions.Expression expression;
        boolean must_be_disposed;

        Expression(IExpressions.Expression expression) {
            assert (expression != null);
            this.expression = expression;
        }

        void dispose() {
            if (!this.must_be_disposed) {
                return;
            }
            if (TCFNodeExpression.this.channel.getState() == 1) {
                IExpressions exps = (IExpressions)TCFNodeExpression.this.channel.getRemoteService(IExpressions.class);
                exps.dispose(this.expression.getID(), new IExpressions.DoneDispose(){

                    public void doneDispose(IToken token, Exception error) {
                        if (error == null) {
                            return;
                        }
                        if (((Expression)Expression.this).TCFNodeExpression.this.channel.getState() != 1) {
                            return;
                        }
                        Activator.log("Error disposing remote expression evaluator", error);
                    }
                });
            }
            this.must_be_disposed = false;
        }
    }
}

