/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import java.util.UUID;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.util.TCFFileInputStream;
import org.eclipse.tcf.util.TCFFileOutputStream;

class TestFileSystem
implements ITCFTest,
IFileSystem.DoneStat,
IFileSystem.DoneOpen,
IFileSystem.DoneClose,
IFileSystem.DoneWrite,
IFileSystem.DoneRead,
IFileSystem.DoneRename,
IFileSystem.DoneRealPath,
IFileSystem.DoneRemove,
IFileSystem.DoneRoots,
IFileSystem.DoneReadDir {
    private final TCFTestSuite test_suite;
    private final int channel_id;
    private static final String client_id = UUID.randomUUID().toString();
    private static final int STATE_PRE = 0;
    private static final int STATE_RD_DIR = 1;
    private static final int STATE_WRITE = 2;
    private static final int STATE_READ = 3;
    private static final int STATE_OUT = 4;
    private static final int STATE_INP = 5;
    private static final int STATE_EXIT = 6;
    private final IFileSystem files;
    private final Random rnd = new Random();
    private final LinkedList<String> tmp_files = new LinkedList();
    private final HashMap<IToken, Object> cmds = new HashMap();
    private byte[] data;
    private String root;
    private String tmp_path;
    private String file_name;
    private IFileSystem.IFileHandle handle;
    private int state = 0;
    private boolean async_close;

    TestFileSystem(TCFTestSuite test_suite, IChannel channel, int channel_id) {
        this.test_suite = test_suite;
        this.channel_id = channel_id;
        this.files = (IFileSystem)channel.getRemoteService(IFileSystem.class);
    }

    public void start() {
        if (this.files == null) {
            this.test_suite.done(this, null);
        } else {
            this.files.roots((IFileSystem.DoneRoots)this);
        }
    }

    public void doneRoots(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries) {
        assert (this.state == 0);
        if (error != null) {
            this.exit((Throwable)error);
        } else if (entries == null || entries.length == 0) {
            this.exit(new Exception("Invalid FileSysrem.roots responce: empty roots array"));
        } else {
            IFileSystem.DirEntry[] dirEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IFileSystem.DirEntry d = dirEntryArray[n2];
                if (!d.filename.startsWith("A:") && !d.filename.startsWith("B:")) {
                    this.root = d.filename;
                    break;
                }
                ++n2;
            }
            if (this.root == null) {
                this.exit(new Exception("Invalid FileSystem.roots responce: no suitable root"));
            } else {
                this.files.opendir(this.root, (IFileSystem.DoneOpen)this);
            }
        }
    }

    public void doneReadDir(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries, boolean eof) {
        if (error != null) {
            this.exit((Throwable)error);
        } else if (this.state == 0) {
            if (entries != null && this.tmp_path == null) {
                IFileSystem.DirEntry[] dirEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileSystem.DirEntry e = dirEntryArray[n2];
                    if (e.filename.equals("tmp") || e.filename.equalsIgnoreCase("temp")) {
                        this.tmp_path = this.root;
                        if (!this.tmp_path.endsWith("/")) {
                            this.tmp_path = String.valueOf(this.tmp_path) + "/";
                        }
                        this.tmp_path = String.valueOf(this.tmp_path) + e.filename;
                        break;
                    }
                    ++n2;
                }
            }
            if (eof) {
                if (this.tmp_path == null) {
                    this.exit(new Exception("File system test filed: cannot find temporary directory"));
                    return;
                }
                this.files.close(this.handle, (IFileSystem.DoneClose)this);
            } else {
                this.files.readdir(this.handle, (IFileSystem.DoneReadDir)this);
            }
        } else if (this.state == 1) {
            if (entries != null) {
                IFileSystem.DirEntry[] dirEntryArray = entries;
                int n = entries.length;
                int n3 = 0;
                while (n3 < n) {
                    IFileSystem.DirEntry e = dirEntryArray[n3];
                    if (e.filename.startsWith("tcf-test-" + client_id + "-" + this.channel_id + "-")) {
                        this.tmp_files.add(e.filename);
                    }
                    ++n3;
                }
            }
            if (eof) {
                this.files.close(this.handle, (IFileSystem.DoneClose)this);
            } else {
                this.files.readdir(this.handle, (IFileSystem.DoneReadDir)this);
            }
        } else assert (false);
    }

    public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
        if (error != null) {
            this.exit((Throwable)error);
        } else if (this.state == 3) {
            if (attrs.size != (long)this.data.length) {
                this.exit(new Exception("Invalid FileSysrem.fstat responce: wrong file size"));
            } else {
                this.files.close(this.handle, (IFileSystem.DoneClose)this);
            }
        } else if (this.state == 2) {
            char[] bf = new char[64];
            int i = 0;
            while (i < bf.length) {
                int ch = this.rnd.nextInt(16384) + 32;
                switch (ch) {
                    case 34: 
                    case 42: 
                    case 47: 
                    case 58: 
                    case 60: 
                    case 62: 
                    case 63: 
                    case 92: 
                    case 124: 
                    case 126: {
                        ch = 45;
                    }
                }
                bf[i] = ch;
                ++i;
            }
            this.file_name = String.valueOf(this.tmp_path) + "/tcf-test-" + client_id + "-" + this.channel_id + "-" + new String(bf) + ".tmp";
            this.files.open(this.file_name, 26, null, (IFileSystem.DoneOpen)this);
        } else assert (false);
    }

    public void doneOpen(IToken token, IFileSystem.FileSystemException error, final IFileSystem.IFileHandle handle) {
        if (error != null) {
            this.exit((Throwable)error);
        } else {
            this.handle = handle;
            if (this.state == 3) {
                int i = 0;
                while (i < this.rnd.nextInt(8)) {
                    ReadCmd cmd = new ReadCmd();
                    cmd.offs = this.rnd.nextInt(this.data.length);
                    cmd.size = this.rnd.nextInt(this.data.length - cmd.offs) + 2;
                    this.cmds.put(this.files.read(handle, (long)cmd.offs, cmd.size, (IFileSystem.DoneRead)this), cmd);
                    ++i;
                }
                if (this.rnd.nextBoolean()) {
                    ReadCmd cmd = new ReadCmd();
                    cmd.offs = 0;
                    cmd.size = this.data.length + 1;
                    this.cmds.put(this.files.read(handle, (long)cmd.offs, cmd.size, (IFileSystem.DoneRead)this), cmd);
                } else {
                    int pos = 0;
                    while (pos < this.data.length) {
                        int size = this.rnd.nextInt(this.data.length - pos) + 1;
                        ReadCmd cmd = new ReadCmd();
                        cmd.offs = pos;
                        cmd.size = size + 1;
                        this.cmds.put(this.files.read(handle, (long)cmd.offs, cmd.size, (IFileSystem.DoneRead)this), cmd);
                        pos += size;
                    }
                }
                this.async_close = this.rnd.nextBoolean();
                if (this.async_close) {
                    this.files.close(handle, (IFileSystem.DoneClose)this);
                }
            } else if (this.state == 2) {
                this.data = new byte[this.rnd.nextInt(4096) + 1];
                this.rnd.nextBytes(this.data);
                if (this.rnd.nextBoolean()) {
                    this.cmds.put(this.files.write(handle, 0L, this.data, 0, this.data.length, (IFileSystem.DoneWrite)this), null);
                } else {
                    int pos = 0;
                    while (pos < this.data.length) {
                        int size = this.rnd.nextInt(this.data.length - pos) + 1;
                        this.cmds.put(this.files.write(handle, (long)pos, this.data, pos, size, (IFileSystem.DoneWrite)this), null);
                        pos += size;
                    }
                }
                this.async_close = this.rnd.nextBoolean();
                if (this.async_close) {
                    this.files.close(handle, (IFileSystem.DoneClose)this);
                }
            } else if (this.state == 5) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            int pos = 0;
                            int len = TestFileSystem.this.data.length * 16;
                            byte[] buf = new byte[333];
                            int buf_pos = 0;
                            int buf_len = 0;
                            boolean mark = true;
                            boolean reset = true;
                            int mark_pos = TestFileSystem.this.rnd.nextInt(len - 1);
                            int reset_pos = mark_pos + TestFileSystem.this.rnd.nextInt(len - mark_pos);
                            if (!$assertionsDisabled && reset_pos < mark_pos) {
                                throw new AssertionError();
                            }
                            TCFFileInputStream inp = new TCFFileInputStream(handle, 133);
                            while (true) {
                                if (mark && pos == mark_pos) {
                                    inp.mark(len);
                                    mark = false;
                                }
                                if (reset && pos == reset_pos) {
                                    inp.reset();
                                    reset = false;
                                    pos = mark_pos;
                                    buf_len = 0;
                                    buf_pos = 0;
                                }
                                int ch = 0;
                                if (buf_pos >= buf_len && (pos >= mark_pos || pos + buf.length <= mark_pos)) {
                                    buf_pos = 0;
                                    buf_len = inp.read(buf, 0, buf.length);
                                    if (buf_len < 0) break;
                                }
                                if (buf_pos < buf_len) {
                                    ch = buf[buf_pos++] & 0xFF;
                                } else {
                                    ch = inp.read();
                                    if (ch < 0) break;
                                }
                                int dt = TestFileSystem.this.data[pos % TestFileSystem.this.data.length] & 0xFF;
                                if (ch != dt) {
                                    this.error(new Exception("Invalid TCFFileInputStream.read responce: wrong data at offset " + pos + ", expected " + dt + ", actual " + ch));
                                }
                                ++pos;
                            }
                            if (pos != TestFileSystem.this.data.length * 16) {
                                this.error(new Exception("Invalid TCFFileInputStream.read responce: wrong file length: expected " + TestFileSystem.this.data.length + ", actual " + pos));
                            }
                            inp.close();
                            Protocol.invokeLater((Runnable)new Runnable(){

                                public void run() {
                                    TestFileSystem.this.state = 6;
                                    TestFileSystem.this.files.rename(TestFileSystem.this.file_name, String.valueOf(TestFileSystem.this.file_name) + ".rnm", (IFileSystem.DoneRename)TestFileSystem.this);
                                }
                            });
                        }
                        catch (Throwable x) {
                            this.error(x);
                        }
                    }

                    private void error(final Throwable x) {
                        Protocol.invokeLater((Runnable)new Runnable(){

                            public void run() {
                                TestFileSystem.this.exit(x);
                            }
                        });
                    }
                };
                thread.setName("TCF FileSystem Test");
                thread.start();
            } else if (this.state == 4) {
                this.rnd.nextBytes(this.data);
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            int pos = 0;
                            int len = TestFileSystem.this.data.length * 16;
                            TCFFileOutputStream out = new TCFFileOutputStream(handle, 121);
                            while (pos < len) {
                                int m = pos % TestFileSystem.this.data.length;
                                int n = TestFileSystem.this.rnd.nextInt(1021);
                                if (n > TestFileSystem.this.data.length - m) {
                                    n = TestFileSystem.this.data.length - m;
                                }
                                out.write(TestFileSystem.this.data, m, n);
                                if ((pos += n) == len) break;
                                out.write(TestFileSystem.this.data[pos % TestFileSystem.this.data.length] & 0xFF);
                                ++pos;
                            }
                            out.close();
                            Protocol.invokeLater((Runnable)new Runnable(){

                                public void run() {
                                    TestFileSystem.this.state = 5;
                                    TestFileSystem.this.files.open(TestFileSystem.this.file_name, 1, null, (IFileSystem.DoneOpen)TestFileSystem.this);
                                }
                            });
                        }
                        catch (Throwable x) {
                            this.error(x);
                        }
                    }

                    private void error(final Throwable x) {
                        Protocol.invokeLater((Runnable)new Runnable(){

                            public void run() {
                                TestFileSystem.this.exit(x);
                            }
                        });
                    }
                };
                thread.setName("TCF FileSystem Test");
                thread.start();
            } else {
                assert (this.state == 0 || this.state == 1);
                this.files.readdir(handle, (IFileSystem.DoneReadDir)this);
            }
        }
    }

    public void doneWrite(IToken token, IFileSystem.FileSystemException error) {
        assert (this.cmds.containsKey(token));
        this.cmds.remove(token);
        if (error != null) {
            this.exit((Throwable)error);
        } else if (this.cmds.size() == 0 && !this.async_close) {
            this.files.close(this.handle, (IFileSystem.DoneClose)this);
        }
    }

    public void doneRead(IToken token, IFileSystem.FileSystemException error, byte[] data, boolean eof) {
        assert (this.cmds.containsKey(token));
        ReadCmd cmd = (ReadCmd)this.cmds.remove(token);
        if (error != null) {
            this.exit((Throwable)error);
        } else if (cmd.offs + cmd.size > this.data.length && !eof) {
            this.exit(new Exception("Invalid FileSysrem.read responce: EOF expected"));
        } else if (data.length != (eof ? cmd.size - 1 : cmd.size)) {
            this.exit(new Exception("Invalid FileSysrem.read responce: wrong data array size"));
        } else {
            int i = 0;
            while (i < data.length) {
                if (data[i] != this.data[i + cmd.offs]) {
                    this.exit(new Exception("Invalid FileSysrem.read responce: wrong data at offset " + i + ", expected " + this.data[i + cmd.offs] + ", actual " + data[i]));
                    return;
                }
                ++i;
            }
            if (this.cmds.size() == 0 && !this.async_close) {
                this.files.fstat(this.handle, (IFileSystem.DoneStat)this);
            }
        }
    }

    public void doneClose(IToken token, IFileSystem.FileSystemException error) {
        if (error != null) {
            this.exit((Throwable)error);
        } else {
            this.handle = null;
            if (this.state == 0) {
                this.state = 1;
                this.files.opendir(this.tmp_path, (IFileSystem.DoneOpen)this);
            } else if (this.state == 1) {
                this.state = 2;
                this.files.realpath(this.tmp_path, (IFileSystem.DoneRealPath)this);
            } else if (this.state == 2) {
                this.state = 3;
                this.files.open(this.file_name, 1, null, (IFileSystem.DoneOpen)this);
            } else if (this.state == 3) {
                this.state = 4;
                this.files.open(this.file_name, 2, null, (IFileSystem.DoneOpen)this);
            } else assert (false);
        }
    }

    public void doneRename(IToken token, IFileSystem.FileSystemException error) {
        assert (this.state == 6);
        if (error != null) {
            this.exit((Throwable)error);
        } else {
            this.files.realpath(String.valueOf(this.file_name) + ".rnm", (IFileSystem.DoneRealPath)this);
        }
    }

    public void doneRealPath(IToken token, IFileSystem.FileSystemException error, String path) {
        if (error != null) {
            this.exit((Throwable)error);
        } else if (this.state == 2) {
            this.tmp_path = path;
            if (this.tmp_files.size() > 0) {
                this.files.remove(String.valueOf(this.tmp_path) + "/" + this.tmp_files.removeFirst(), (IFileSystem.DoneRemove)this);
            } else {
                this.files.stat(this.tmp_path, (IFileSystem.DoneStat)this);
            }
        } else if (!path.equals(String.valueOf(this.file_name) + ".rnm")) {
            this.exit(new Exception("Invalid FileSysrem.realpath responce: " + path));
        } else {
            this.files.remove(String.valueOf(this.file_name) + ".rnm", (IFileSystem.DoneRemove)this);
        }
    }

    public void doneRemove(IToken token, IFileSystem.FileSystemException error) {
        if (error != null) {
            this.exit((Throwable)error);
        } else if (this.state == 2) {
            if (this.tmp_files.size() > 0) {
                this.files.remove(String.valueOf(this.tmp_path) + "/" + this.tmp_files.removeFirst(), (IFileSystem.DoneRemove)this);
            } else {
                this.files.stat(this.tmp_path, (IFileSystem.DoneStat)this);
            }
        } else if (this.state == 6) {
            this.exit(null);
        } else assert (false);
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        this.test_suite.done(this, x);
    }

    public boolean canResume(String id) {
        return true;
    }

    private static class ReadCmd {
        int offs;
        int size;

        private ReadCmd() {
        }
    }
}

