/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.model;

import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNodeProvider;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;

public class ModelNode
extends PropertiesContainer
implements IModelNode,
IModelNodeProvider {
    private IContainerModelNode parent = null;
    private boolean dirty;
    private boolean pending;
    protected boolean suppressEventsOnNullParent = true;
    protected boolean allowSetParentOnNonNullParent = false;

    @Override
    public final IContainerModelNode getParent() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.parent;
    }

    @Override
    public final <V extends IContainerModelNode> V getParent(Class<V> nodeType) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        if (this.parent != null) {
            if (nodeType.isInstance(this.parent)) {
                return (V)this.parent;
            }
            return this.parent.getParent(nodeType);
        }
        return null;
    }

    @Override
    public final void setParent(IContainerModelNode parent) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        if (this.parent != null && !this.allowSetParentOnNonNullParent) {
            throw new IllegalStateException("Model node already associated with a parent container model node!");
        }
        this.parent = parent;
    }

    @Override
    public final void move(IContainerModelNode newParent) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)newParent);
        if (this.parent != null && (!this.parent.contains(this) || this.parent.remove(this, false))) {
            this.parent = null;
        }
        newParent.add(this);
    }

    @Override
    public boolean isVisible() {
        return this.getBooleanProperty("isVisible");
    }

    @Override
    public String getError() {
        return this.getStringProperty("error");
    }

    @Override
    public String getName() {
        String name = (String)super.getProperty("name");
        return name != null ? name : "";
    }

    @Override
    public String[] getDescription() {
        return new String[0];
    }

    @Override
    public String getImageId() {
        return null;
    }

    public String toString() {
        StringBuilder toString = new StringBuilder(this.getClass().getName());
        toString.append("{");
        toString.append(super.toString());
        toString.append("}");
        return toString.toString();
    }

    protected boolean dropEvent(Object source, String key, Object oldValue, Object newValue) {
        boolean drop = super.dropEvent(source, key, oldValue, newValue);
        if (drop || "isghost".equals(key)) {
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/events")) {
                CoreBundleActivator.getTraceHandler().trace("Drop change event (hidden property)\n\t\tfor eventId = " + key, 0, "trace/events", 2, (Object)this);
            }
            return true;
        }
        if (this.parent == null && this.suppressEventsOnNullParent) {
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/events")) {
                CoreBundleActivator.getTraceHandler().trace("Drop change event (null parent)\n\t\tfor eventId = " + key, 0, "trace/events", 2, (Object)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public final IModelNode getModelNode() {
        return this;
    }

    public boolean contains(ISchedulingRule rule) {
        if (rule instanceof IModelNode) {
            return rule == this;
        }
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (rule instanceof IModelNode) {
            return rule == this;
        }
        return false;
    }

    @Override
    public final void setDirty(boolean dirty) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        this.dirty = dirty;
    }

    @Override
    public final boolean isDirty() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.dirty;
    }

    @Override
    public final void setPending(boolean pending) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        this.pending = pending;
    }

    @Override
    public final boolean isPending() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.pending;
    }

    @Override
    public IModelNode find(UUID uuid) {
        if (this.getUUID().equals(uuid)) {
            return this;
        }
        return null;
    }
}

