/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.utils;

import java.beans.PropertyChangeEvent;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.JobExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCacheFileDigest;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.CacheState;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;

public class FileState {
    private byte[] base_digest = null;
    private byte[] target_digest = null;
    private byte[] cache_digest = null;
    private long cache_mtime;
    transient boolean cache_digest_running = false;
    transient boolean target_digest_running = false;
    private transient FSTreeNode node;

    public FileState(FSTreeNode node) {
        this.node = node;
    }

    public FileState(long mtime, byte[] cache_digest, byte[] target_digest, byte[] base_digest) {
        this.cache_mtime = mtime;
        this.cache_digest = cache_digest;
        this.target_digest = target_digest;
        this.base_digest = base_digest;
    }

    void setNode(FSTreeNode node) {
        this.node = node;
    }

    public byte[] getTargetDigest() {
        return this.target_digest;
    }

    public byte[] getBaseDigest() {
        return this.base_digest;
    }

    public long getCacheMTime() {
        return this.cache_mtime;
    }

    public byte[] getCacheDigest() {
        return this.cache_digest;
    }

    public synchronized void updateState(final ICallback callback) {
        File file = CacheManager.getCacheFile(this.node);
        if (file.exists()) {
            long cache_mtime = file.lastModified();
            if (!(this.cache_digest_running || this.cache_digest != null && this.cache_mtime == cache_mtime)) {
                this.cache_digest_running = true;
                this.cache_mtime = cache_mtime;
                final OpCacheFileDigest op = new OpCacheFileDigest(this.node);
                new JobExecutor((ICallback)new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        if (status.isOK()) {
                            FileState.this.updateCacheDigest(op.getDigest());
                        }
                        FileState.this.cache_digest_running = false;
                        if (status.isOK()) {
                            FileState.this.updateState(callback);
                        } else if (callback != null) {
                            callback.done((Object)this, status);
                        }
                    }
                }).execute(op);
            } else if (!this.target_digest_running && this.target_digest == null) {
                this.target_digest_running = true;
                this.node.refresh((ICallback)new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        FileState.this.target_digest_running = false;
                        if (status.isOK()) {
                            FileState.this.updateState(callback);
                        } else if (callback != null) {
                            callback.done((Object)this, status);
                        }
                    }
                });
            } else if (callback != null) {
                callback.done((Object)this, Status.OK_STATUS);
            }
        } else if (callback != null) {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    public synchronized CacheState getCacheState() {
        File file = CacheManager.getCacheFile(this.node);
        if (!file.exists()) {
            return CacheState.consistent;
        }
        this.updateState(null);
        if (this.cache_digest == null || this.target_digest == null) {
            return CacheState.consistent;
        }
        if (this.isUnchanged(this.target_digest, this.cache_digest)) {
            this.base_digest = this.target_digest;
            return CacheState.consistent;
        }
        if (this.isUnchanged(this.base_digest, this.cache_digest)) {
            return CacheState.outdated;
        }
        if (this.isUnchanged(this.target_digest, this.base_digest)) {
            return CacheState.modified;
        }
        return CacheState.conflict;
    }

    public void updateTargetDigest(byte[] target_digest) {
        this.target_digest = target_digest;
        PropertyChangeEvent event = new PropertyChangeEvent(this, "target_digest", null, target_digest);
        this.node.firePropertyChange(event);
    }

    private boolean isUnchanged(byte[] digest1, byte[] digest2) {
        if (digest1 != null && digest2 != null && digest1.length == digest2.length) {
            int i = 0;
            while (i < digest1.length) {
                if (digest1[i] != digest2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void updateCacheDigest(byte[] cache_digest) {
        byte[] old_digest = cache_digest;
        this.cache_digest = cache_digest;
        PropertyChangeEvent event = new PropertyChangeEvent(this.node, "cache_digest", old_digest, cache_digest);
        this.node.firePropertyChange(event);
    }

    public void reset(byte[] digest) {
        this.cache_digest = digest;
        this.target_digest = digest;
        this.base_digest = digest;
        PropertyChangeEvent event = new PropertyChangeEvent(this.node, "reset_digest", null, digest);
        this.node.firePropertyChange(event);
    }
}

