/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.panels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IPropertiesAccessService;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.panels.AbstractWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.nls.Messages;
import org.eclipse.ui.ISharedImages;

public abstract class AbstractConfigurationPanel
extends AbstractWizardConfigurationPanel
implements IConfigurationPanel {
    private static final String LAST_HOST_TAG = "lastHost";
    private static final String HOSTS_TAG = "hosts";
    private ISelection selection;
    protected Map<String, Map<String, String>> hostSettingsMap = new HashMap<String, Map<String, String>>();
    protected Combo hostCombo;
    private Button deleteHostButton;

    public AbstractConfigurationPanel(BaseDialogPageControl parentControl) {
        super(parentControl);
    }

    @Override
    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    @Override
    public ISelection getSelection() {
        return this.selection;
    }

    public String getSelectionHost() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Map props;
            Object element = ((IStructuredSelection)selection).getFirstElement();
            IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService(element, IPropertiesAccessService.class);
            if (service != null && (props = service.getTargetAddress(element)) != null && props.containsKey("address")) {
                return (String)props.get("address");
            }
        }
        return null;
    }

    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        String[] hosts = settings.getArray(HOSTS_TAG);
        if (hosts != null) {
            int i = 0;
            while (i < hosts.length) {
                String hostEntry = hosts[i];
                String[] hostString = hostEntry.split("\\|");
                String hostName = hostString[0];
                if (hostString.length == 2) {
                    HashMap<String, String> attr = this.deSerialize(hostString[1]);
                    this.hostSettingsMap.put(hostName, attr);
                } else {
                    this.hostSettingsMap.put(hostName, new HashMap());
                }
                ++i;
            }
        }
        if (!this.isWithoutSelection()) {
            String host = this.getSelectionHost();
            if (host != null) {
                this.fillSettingsForHost(host);
            }
        } else if (this.hostCombo != null) {
            this.fillCombo();
            String lastHost = settings.get(LAST_HOST_TAG);
            if (lastHost != null) {
                int index = this.hostCombo.indexOf(lastHost);
                if (index != -1) {
                    this.hostCombo.select(index);
                } else {
                    this.hostCombo.select(0);
                }
            } else {
                this.hostCombo.select(0);
            }
            this.fillSettingsForHost(this.hostCombo.getText());
        }
    }

    protected HashMap<String, String> deSerialize(String hostString) {
        HashMap<String, String> attr = new HashMap<String, String>();
        if (hostString.length() != 0) {
            String[] hostAttrs = hostString.split("\\:");
            int j = 0;
            while (j < hostAttrs.length) {
                String key = hostAttrs[j];
                String value = hostAttrs[j + 1];
                attr.put(key, value);
                j += 2;
            }
        }
        return attr;
    }

    protected void serialize(Map<String, String> hostEntry, StringBuffer hostString) {
        if (hostEntry.keySet().size() != 0) {
            for (Map.Entry<String, String> entry : hostEntry.entrySet()) {
                String attrKey = entry.getKey();
                String attrValue = entry.getValue();
                hostString.append(String.valueOf(attrKey) + ":" + attrValue + ":");
            }
            hostString.deleteCharAt(hostString.length() - 1);
        }
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        String host;
        Iterator<String> nextHost = this.hostSettingsMap.keySet().iterator();
        String[] hosts = new String[this.hostSettingsMap.keySet().size()];
        int i = 0;
        while (nextHost.hasNext()) {
            StringBuffer hostString = new StringBuffer();
            String host2 = nextHost.next();
            hostString.append(String.valueOf(host2) + "|");
            Map<String, String> hostEntry = this.hostSettingsMap.get(host2);
            this.serialize(hostEntry, hostString);
            hosts[i] = hostString.toString();
            ++i;
        }
        settings.put(HOSTS_TAG, hosts);
        if (this.isWithoutSelection() && this.hostCombo != null && (host = this.getHostFromSettings()) != null) {
            settings.put(LAST_HOST_TAG, host);
        }
    }

    protected abstract void saveSettingsForHost(boolean var1);

    protected abstract void fillSettingsForHost(String var1);

    protected abstract String getHostFromSettings();

    protected void removeSecurePassword(String host) {
    }

    protected String getHostFromCombo() {
        if (this.hostCombo != null) {
            return this.hostCombo.getText();
        }
        return null;
    }

    protected void removeSettingsForHost(String host) {
        if (this.hostSettingsMap.containsKey(host)) {
            this.hostSettingsMap.remove(host);
        }
    }

    private List<String> getHostList() {
        ArrayList<String> hostList = new ArrayList<String>();
        hostList.addAll(this.hostSettingsMap.keySet());
        return hostList;
    }

    public void fillCombo() {
        if (this.hostCombo != null) {
            this.hostCombo.removeAll();
            List<String> hostList = this.getHostList();
            Collections.sort(hostList);
            for (String host : hostList) {
                this.hostCombo.add(host);
            }
            if (hostList.size() <= 1) {
                this.hostCombo.setEnabled(false);
            } else {
                this.hostCombo.setEnabled(true);
            }
            if (hostList.size() == 0) {
                this.deleteHostButton.setEnabled(false);
            } else {
                this.deleteHostButton.setEnabled(true);
            }
        }
    }

    public boolean isWithoutSelection() {
        ISelection selection = this.getSelection();
        if (selection == null) {
            return true;
        }
        return selection instanceof IStructuredSelection && selection.isEmpty();
    }

    public boolean isWithHostList() {
        return true;
    }

    protected void createHostsUI(Composite parent) {
        if (this.isWithoutSelection() && this.isWithHostList()) {
            Composite comboComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            comboComposite.setLayout((Layout)layout);
            comboComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label label = new Label(comboComposite, 256);
            label.setText(Messages.AbstractConfigurationPanel_hosts);
            this.hostCombo = new Combo(comboComposite, 8);
            this.hostCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.hostCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String host = AbstractConfigurationPanel.this.hostCombo.getText();
                    AbstractConfigurationPanel.this.fillSettingsForHost(host);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.deleteHostButton = new Button(comboComposite, 0);
            ISharedImages workbenchImages = UIPlugin.getDefault().getWorkbench().getSharedImages();
            this.deleteHostButton.setImage(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE").createImage());
            this.deleteHostButton.setToolTipText(Messages.AbstractConfigurationPanel_deleteButtonTooltip);
            this.deleteHostButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String host = AbstractConfigurationPanel.this.getHostFromCombo();
                    if (host != null && host.length() != 0) {
                        AbstractConfigurationPanel.this.removeSettingsForHost(host);
                        AbstractConfigurationPanel.this.removeSecurePassword(host);
                        AbstractConfigurationPanel.this.fillCombo();
                        AbstractConfigurationPanel.this.hostCombo.select(0);
                        host = AbstractConfigurationPanel.this.getHostFromCombo();
                        if (host != null && host.length() != 0) {
                            AbstractConfigurationPanel.this.fillSettingsForHost(host);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            Label separator = new Label(parent, 258);
            separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
    }
}

