/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.wire.network;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.nls.Messages;
import org.eclipse.tcf.te.ui.controls.panels.AbstractWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.controls.wire.network.NetworkAddressControl;
import org.eclipse.tcf.te.ui.controls.wire.network.NetworkPortControl;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode3;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NetworkCablePanel
extends AbstractWizardConfigurationPanel
implements IDataExchangeNode3 {
    private NetworkAddressControl addressControl = null;
    private NetworkPortControl portControl = null;

    public NetworkCablePanel(BaseDialogPageControl parentPageControl) {
        super(parentPageControl);
    }

    @Override
    public void dispose() {
        if (this.addressControl != null) {
            this.addressControl.dispose();
            this.addressControl = null;
        }
        if (this.portControl != null) {
            this.portControl.dispose();
            this.portControl = null;
        }
        super.dispose();
    }

    @Override
    public void setupPanel(Composite parent, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        boolean adjustBackgroundColor = this.getParentControl().getParentPage() != null;
        Composite panel = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (adjustBackgroundColor) {
            panel.setBackground(parent.getBackground());
        }
        this.setControl(panel);
        Section section = toolkit.createSection(panel, 256);
        Assert.isNotNull((Object)section);
        section.setText(Messages.NetworkCablePanel_section);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(4, 1, true, false));
        if (adjustBackgroundColor) {
            section.setBackground(panel.getBackground());
        }
        Composite client = toolkit.createComposite((Composite)section);
        Assert.isNotNull((Object)client);
        client.setLayout((Layout)new GridLayout());
        client.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (adjustBackgroundColor) {
            client.setBackground(section.getBackground());
        }
        section.setClient((Control)client);
        this.addressControl = this.doCreateAddressControl(this);
        this.addressControl.setupPanel(client);
        this.portControl = this.doCreatePortControl(this);
        this.portControl.setParentControlIsInnerPanel(true);
        this.portControl.setupPanel(this.addressControl.getInnerPanelComposite());
        this.portControl.setEditFieldControlText(this.getDefaultPort());
    }

    protected NetworkAddressControl doCreateAddressControl(NetworkCablePanel parentPanel) {
        Assert.isNotNull((Object)parentPanel);
        return new NetworkAddressControl(parentPanel);
    }

    protected final NetworkAddressControl getAddressControl() {
        return this.addressControl;
    }

    protected NetworkPortControl doCreatePortControl(NetworkCablePanel parentPanel) {
        Assert.isNotNull((Object)parentPanel);
        return new NetworkPortControl(parentPanel);
    }

    protected final NetworkPortControl getPortControl() {
        return this.portControl;
    }

    protected String getDefaultPort() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.addressControl != null) {
            if (this.keepLabelsAlwaysEnabled()) {
                SWTControlUtil.setEnabled((Control)this.addressControl.getEditFieldControl(), (boolean)enabled);
                SWTControlUtil.setEnabled((Control)this.addressControl.getButtonControl(), (boolean)enabled);
            } else {
                this.addressControl.setEnabled(enabled);
            }
        }
        if (this.portControl != null) {
            if (this.keepLabelsAlwaysEnabled()) {
                SWTControlUtil.setEnabled((Control)this.portControl.getEditFieldControl(), (boolean)enabled);
                SWTControlUtil.setEnabled((Control)this.portControl.getButtonControl(), (boolean)enabled);
            } else {
                this.portControl.setEnabled(enabled);
            }
        }
    }

    protected boolean keepLabelsAlwaysEnabled() {
        return false;
    }

    @Override
    public boolean isValid() {
        boolean valid = super.isValid();
        if (!valid) {
            return false;
        }
        valid = this.addressControl.isValid();
        this.setMessage(this.addressControl.getMessage(), this.addressControl.getMessageType());
        valid &= this.portControl.isValid();
        if (this.portControl.getMessageType() > this.getMessageType()) {
            this.setMessage(this.portControl.getMessage(), this.portControl.getMessageType());
        }
        return valid;
    }

    @Override
    public boolean dataChanged(IPropertiesContainer data, TypedEvent e) {
        String port;
        String address;
        Assert.isNotNull((Object)data);
        boolean isDirty = false;
        HashMap container = (HashMap)data.getProperty("network");
        if (container == null) {
            container = new HashMap();
        }
        if (this.addressControl != null && (address = this.addressControl.getEditFieldControlText()) != null) {
            isDirty |= !address.equals(container.get("address") != null ? container.get("address") : "");
        }
        if (this.portControl != null && (port = this.portControl.getEditFieldControlText()) != null) {
            isDirty |= !port.equals(container.get("port") != null ? container.get("port") : (this.getDefaultPort() != null ? this.getDefaultPort() : ""));
        }
        return isDirty;
    }

    public void setupData(IPropertiesContainer data) {
        if (data == null) {
            return;
        }
        HashMap container = (HashMap)data.getProperty("network");
        if (container == null) {
            container = new HashMap();
        }
        if (this.addressControl != null) {
            this.addressControl.setEditFieldControlText((String)container.get("address"));
        }
        if (this.portControl != null) {
            String port = (String)container.get("port");
            this.portControl.setEditFieldControlText(port != null && !"".equals(port) ? port : this.getDefaultPort());
        }
    }

    public void extractData(IPropertiesContainer data) {
        if (data == null) {
            return;
        }
        HashMap<String, String> container = (HashMap<String, String>)data.getProperty("network");
        if (container == null) {
            container = new HashMap<String, String>();
        }
        if (this.addressControl != null) {
            container.put("address", this.addressControl.getEditFieldControlText());
        }
        if (this.portControl != null) {
            container.put("port", this.portControl.getEditFieldControlText());
        }
        data.setProperty("network", !container.isEmpty() ? container : null);
    }

    public void initializeData(IPropertiesContainer data) {
    }

    public void removeData(IPropertiesContainer data) {
        if (data == null) {
            return;
        }
        data.setProperty("network", null);
    }

    public void copyData(IPropertiesContainer src, IPropertiesContainer dst) {
        Assert.isNotNull((Object)src);
        Assert.isNotNull((Object)dst);
        Map srcContainer = (Map)src.getProperty("network");
        HashMap dstContainer = null;
        if (srcContainer != null) {
            dstContainer = new HashMap(srcContainer);
        }
        dst.setProperty("network", dstContainer);
    }

    @Override
    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        super.doSaveWidgetValues(settings, idPrefix);
        if (this.addressControl != null) {
            this.addressControl.doSaveWidgetValues(settings, idPrefix);
        }
        if (this.portControl != null) {
            this.portControl.doSaveWidgetValues(settings, idPrefix);
        }
    }

    @Override
    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        super.doRestoreWidgetValues(settings, idPrefix);
        if (this.addressControl != null) {
            this.addressControl.doRestoreWidgetValues(settings, idPrefix);
        }
        if (this.portControl != null) {
            this.portControl.doRestoreWidgetValues(settings, idPrefix);
        }
    }
}

