/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFChannelException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;

public class OpRefreshRoots
extends Operation {
    FSTreeNode root;

    public OpRefreshRoots(FSTreeNode root) {
        this.root = root;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        super.run(monitor);
        IChannel channel = null;
        try {
            try {
                channel = OpRefreshRoots.openChannel(this.root.peerNode.getPeer());
                IFileSystem service = OpRefreshRoots.getBlockingFileSystem(channel);
                if (service != null) {
                    this.root.queryStarted();
                    service.roots(new IFileSystem.DoneRoots(){

                        public void doneRoots(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries) {
                            if (error == null) {
                                IFileSystem.DirEntry[] dirEntryArray = entries;
                                int n = entries.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IFileSystem.DirEntry entry = dirEntryArray[n2];
                                    FSTreeNode node = new FSTreeNode(OpRefreshRoots.this.root, entry, true);
                                    OpRefreshRoots.this.root.addChild(node);
                                    ++n2;
                                }
                            }
                        }
                    });
                    this.root.queryDone();
                }
            }
            catch (TCFChannelException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (channel != null) {
                Tcf.getChannelManager().closeChannel(channel);
            }
        }
    }
}

