/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.adapters;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.interfaces.IViewerInput;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.adapters.PeerModelViewerInput;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;

public class ViewerInputAdapterFactory
implements IAdapterFactory {
    private static final String VIEWER_INPUT_KEY = String.valueOf(UIPlugin.getUniqueIdentifier()) + ".peer.viewerInput";

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IPeerModel) {
            IPeerModel peerModel = (IPeerModel)adaptableObject;
            return this.getViewerInput(peerModel);
        }
        return null;
    }

    PeerModelViewerInput getViewerInput(final IPeerModel peerModel) {
        if (peerModel != null) {
            if (Protocol.isDispatchThread()) {
                PeerModelViewerInput model = (PeerModelViewerInput)((Object)peerModel.getProperty(VIEWER_INPUT_KEY));
                if (model == null) {
                    model = new PeerModelViewerInput(peerModel);
                    peerModel.setProperty(VIEWER_INPUT_KEY, (Object)model);
                }
                return model;
            }
            final AtomicReference reference = new AtomicReference();
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    reference.set(ViewerInputAdapterFactory.this.getViewerInput(peerModel));
                }
            });
            return (PeerModelViewerInput)((Object)reference.get());
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IViewerInput.class};
    }
}

