/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.util.ArrayList;
import org.eclipse.debug.core.Launch;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelManager;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractActionDelegate
implements IViewActionDelegate,
IActionDelegate2,
IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    private IAction action;
    private IViewPart view;
    private IWorkbenchWindow window;
    private ISelection selection;

    public void init(IAction action) {
        this.action = action;
    }

    public void init(IViewPart view) {
        this.view = view;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void dispose() {
        this.action = null;
        this.view = null;
        this.window = null;
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.action = action;
        this.view = null;
        if (part instanceof IViewPart) {
            this.view = (IViewPart)part;
        }
        this.window = part.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        IAction action0 = this.action;
        try {
            this.action = action;
            this.run();
        }
        finally {
            this.action = action0;
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        IAction action0 = this.action;
        try {
            this.action = action;
            this.selectionChanged();
        }
        finally {
            this.action = action0;
        }
    }

    public IAction getAction() {
        return this.action;
    }

    public IViewPart getView() {
        return this.view;
    }

    public IWorkbenchWindow getWindow() {
        if (this.view != null) {
            return this.view.getSite().getWorkbenchWindow();
        }
        if (this.window != null) {
            return this.window;
        }
        return null;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public TCFNode getSelectedNode() {
        if (this.selection instanceof IStructuredSelection) {
            Object o = ((IStructuredSelection)this.selection).getFirstElement();
            if (o instanceof TCFNode) {
                return (TCFNode)o;
            }
            if (o instanceof TCFLaunch) {
                return TCFModelManager.getRootNodeSync((Launch)((TCFLaunch)o));
            }
        }
        return null;
    }

    public TCFNode[] getSelectedNodes() {
        IStructuredSelection s;
        ArrayList<TCFNode> list = new ArrayList<TCFNode>();
        if (this.selection instanceof IStructuredSelection && (s = (IStructuredSelection)this.selection).size() > 0) {
            Object[] objectArray = s.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                TCFNodeLaunch n3;
                Object o = objectArray[n2];
                if (o instanceof TCFNode) {
                    list.add((TCFNode)o);
                } else if (o instanceof TCFLaunch && (n3 = TCFModelManager.getRootNodeSync((Launch)((TCFLaunch)o))) != null) {
                    list.add(n3);
                }
                ++n2;
            }
        }
        return list.toArray(new TCFNode[list.size()]);
    }

    protected abstract void selectionChanged();

    protected abstract void run();
}

