/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tcf.internal.debug.ui.model.IWatchInExpressions;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IWorkbenchPage;

public class WatchInExpressionsCommand
extends AbstractActionDelegate {
    protected void selectionChanged() {
        this.getAction().setEnabled(this.getNodes().length > 0);
    }

    protected void run() {
        try {
            IWorkbenchPage page = this.getWindow().getActivePage();
            page.showView("org.eclipse.debug.ui.ExpressionView", null, 1);
            TCFNode[] tCFNodeArray = this.getNodes();
            int n = tCFNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                final TCFNode node = tCFNodeArray[n2];
                final IExpressionManager manager = node.getModel().getExpressionManager();
                IExpression e = (IExpression)new TCFTask<IExpression>(node.getChannel()){

                    public void run() {
                        try {
                            IWatchExpression e = null;
                            if (node instanceof IWatchInExpressions) {
                                TCFDataCache<String> text_cache = ((IWatchInExpressions)((Object)node)).getExpressionText();
                                if (!text_cache.validate((Runnable)((Object)this))) {
                                    return;
                                }
                                String text_data = (String)text_cache.getData();
                                if (text_data != null) {
                                    IExpression[] iExpressionArray = manager.getExpressions();
                                    int n = iExpressionArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IExpression x = iExpressionArray[n2];
                                        if (text_data.equals(x.getExpressionText())) {
                                            this.done(null);
                                            return;
                                        }
                                        ++n2;
                                    }
                                    e = manager.newWatchExpression(text_data);
                                }
                            }
                            this.done(e);
                        }
                        catch (Exception x) {
                            this.error(x);
                        }
                    }
                }.get();
                if (e != null) {
                    manager.addExpression(e);
                }
                ++n2;
            }
        }
        catch (Exception x) {
            Activator.log("Cannot open expressions view", x);
        }
    }

    private TCFNode[] getNodes() {
        TCFNode[] arr;
        TCFNode[] tCFNodeArray = arr = this.getSelectedNodes();
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode n3 = tCFNodeArray[n2];
            if (n3 instanceof TCFNodeExpression) {
                if (((TCFNodeExpression)n3).isEmpty()) {
                    return new TCFNode[0];
                }
                if ("org.eclipse.debug.ui.ExpressionView".equals(this.getView().getViewSite().getId()) && (n3.getParent() instanceof TCFNodeExecContext || n3.getParent() instanceof TCFNodeStackFrame)) {
                    return new TCFNode[0];
                }
            }
            if (!(n3 instanceof IWatchInExpressions)) {
                return new TCFNode[0];
            }
            ++n2;
        }
        return arr;
    }
}

