/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.model.TCFDebugTask;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNumberFormat;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;

class TCFMemoryBlockRetrieval
implements IMemoryBlockRetrievalExtension {
    private final TCFNodeExecContext exec_ctx;
    private final HashSet<MemoryBlock> mem_blocks = new HashSet();

    TCFMemoryBlockRetrieval(TCFNodeExecContext exec_ctx) {
        this.exec_ctx = exec_ctx;
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(final String expression, Object context) throws DebugException {
        return (IMemoryBlockExtension)new TCFDebugTask<IMemoryBlockExtension>(){

            public void run() {
                this.done((Object)new MemoryBlock(expression, -1L));
            }
        }.getD();
    }

    public IMemoryBlock getMemoryBlock(final long address, final long length) throws DebugException {
        return (IMemoryBlock)new TCFDebugTask<IMemoryBlockExtension>(){

            public void run() {
                this.done((Object)new MemoryBlock("0x" + Long.toHexString(address), length));
            }
        }.getD();
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    public String getMemoryID() {
        return this.exec_ctx.id;
    }

    void onMemoryChanged(boolean suspended) {
        assert (Protocol.isDispatchThread());
        if (this.mem_blocks.size() == 0) {
            return;
        }
        ArrayList<DebugEvent> list = new ArrayList<DebugEvent>();
        for (MemoryBlock b : this.mem_blocks) {
            if (suspended) {
                b.mem_prev = b.mem_last;
            }
            b.mem_data = null;
            list.add(new DebugEvent((Object)b, 16, 512));
        }
        DebugPlugin.getDefault().fireDebugEventSet(list.toArray(new DebugEvent[list.size()]));
    }

    private static class MemData {
        final BigInteger addr;
        final MemoryByte[] data;
        final byte[] bytes;

        MemData(BigInteger addr, MemoryByte[] data) {
            int i = 0;
            this.addr = addr;
            this.data = data;
            this.bytes = new byte[data.length];
            MemoryByte[] memoryByteArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryByte b = memoryByteArray[n2];
                this.bytes[i++] = b.getValue();
                ++n2;
            }
        }
    }

    private class MemoryBlock
    extends PlatformObject
    implements IMemoryBlockExtension {
        private final String expression;
        private final long length;
        private final Set<Object> connections = new HashSet<Object>();
        private final TCFDataCache<IExpressions.Expression> remote_expression;
        private final TCFDataCache<IExpressions.Value> expression_value;
        private final TCFDataCache<ISymbols.Symbol> expression_type;
        private boolean disposed;
        private MemData mem_data;
        private MemData mem_prev;
        private MemData mem_last;

        MemoryBlock(final String expression, long length) {
            this.expression = expression;
            this.length = length;
            TCFMemoryBlockRetrieval.this.mem_blocks.add(this);
            final TCFLaunch launch = ((TCFMemoryBlockRetrieval)TCFMemoryBlockRetrieval.this).exec_ctx.model.getLaunch();
            IChannel channel = launch.getChannel();
            this.remote_expression = new TCFDataCache<IExpressions.Expression>(channel){

                protected boolean startDataRetrieval() {
                    IExpressions exps = (IExpressions)launch.getService(IExpressions.class);
                    if (exps == null) {
                        this.set(null, new Exception("Expressions service not available"), null);
                        return true;
                    }
                    this.command = exps.create(((TCFMemoryBlockRetrieval)((MemoryBlock)MemoryBlock.this).TCFMemoryBlockRetrieval.this).exec_ctx.id, null, expression, new IExpressions.DoneCreate(){

                        public void doneCreate(IToken token, Exception error, IExpressions.Expression context) {
                            if (MemoryBlock.this.disposed) {
                                IExpressions exps = (IExpressions)channel.getRemoteService(IExpressions.class);
                                exps.dispose(context.getID(), new IExpressions.DoneDispose(){

                                    public void doneDispose(IToken token, Exception error) {
                                        if (error == null) {
                                            return;
                                        }
                                        if (channel.getState() != 1) {
                                            return;
                                        }
                                        Activator.log("Error disposing remote expression evaluator", error);
                                    }
                                });
                                return;
                            }
                            this.set(token, error, context);
                        }
                    });
                    return false;
                }
            };
            this.expression_value = new TCFDataCache<IExpressions.Value>(channel){

                protected boolean startDataRetrieval() {
                    if (!MemoryBlock.this.remote_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Expression ctx = (IExpressions.Expression)MemoryBlock.this.remote_expression.getData();
                    if (ctx == null) {
                        this.set(null, null, null);
                        return true;
                    }
                    IExpressions exps = (IExpressions)launch.getService(IExpressions.class);
                    this.command = exps.evaluate(ctx.getID(), new IExpressions.DoneEvaluate(){

                        public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                            this.set(token, error, value);
                        }
                    });
                    return false;
                }
            };
            this.expression_type = new TCFDataCache<ISymbols.Symbol>(channel){

                protected boolean startDataRetrieval() {
                    if (!MemoryBlock.this.expression_value.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Value val = (IExpressions.Value)MemoryBlock.this.expression_value.getData();
                    if (val == null) {
                        this.set(null, MemoryBlock.this.expression_value.getError(), null);
                        return true;
                    }
                    TCFDataCache<ISymbols.Symbol> type_cache = ((TCFMemoryBlockRetrieval)((MemoryBlock)MemoryBlock.this).TCFMemoryBlockRetrieval.this).exec_ctx.model.getSymbolInfoCache(val.getTypeID());
                    if (type_cache == null) {
                        this.set(null, null, null);
                        return true;
                    }
                    if (!type_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    this.set(null, type_cache.getError(), (ISymbols.Symbol)type_cache.getData());
                    return true;
                }
            };
        }

        public synchronized void connect(Object client) {
            this.connections.add(client);
        }

        public synchronized void disconnect(Object client) {
            this.connections.remove(client);
        }

        public synchronized Object[] getConnections() {
            return this.connections.toArray(new Object[this.connections.size()]);
        }

        public void dispose() throws DebugException {
            new TCFDebugTask<Boolean>(TCFMemoryBlockRetrieval.this.exec_ctx.getChannel()){

                public void run() {
                    IChannel channel;
                    MemoryBlock.this.disposed = true;
                    MemoryBlock.this.expression_value.dispose();
                    MemoryBlock.this.expression_type.dispose();
                    if (MemoryBlock.this.remote_expression.isValid() && MemoryBlock.this.remote_expression.getData() != null && (channel = ((TCFMemoryBlockRetrieval)((MemoryBlock)MemoryBlock.this).TCFMemoryBlockRetrieval.this).exec_ctx.channel).getState() == 1) {
                        IExpressions exps = (IExpressions)channel.getRemoteService(IExpressions.class);
                        exps.dispose(((IExpressions.Expression)MemoryBlock.this.remote_expression.getData()).getID(), new IExpressions.DoneDispose(){

                            public void doneDispose(IToken token, Exception error) {
                                if (error == null) {
                                    return;
                                }
                                if (channel.getState() != 1) {
                                    return;
                                }
                                Activator.log("Error disposing remote expression evaluator", error);
                            }
                        });
                    }
                    MemoryBlock.this.remote_expression.dispose();
                    TCFMemoryBlockRetrieval.this.mem_blocks.remove((Object)MemoryBlock.this);
                    this.done(Boolean.TRUE);
                }
            }.getD();
        }

        public int getAddressSize() throws DebugException {
            return (Integer)new TCFDebugTask<Integer>(TCFMemoryBlockRetrieval.this.exec_ctx.getChannel()){

                public void run() {
                    if (TCFMemoryBlockRetrieval.this.exec_ctx.isDisposed()) {
                        this.error("Context is disposed");
                    } else {
                        TCFDataCache<IMemory.MemoryContext> cache = TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext();
                        if (!cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (cache.getError() != null) {
                            this.error(cache.getError());
                        } else {
                            IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                            if (mem == null) {
                                this.error("Context does not provide memory access");
                            } else {
                                this.done(mem.getAddressSize());
                            }
                        }
                    }
                }
            }.getD();
        }

        public int getAddressableSize() throws DebugException {
            return 1;
        }

        public BigInteger getBigBaseAddress() throws DebugException {
            return (BigInteger)new TCFDebugTask<BigInteger>(TCFMemoryBlockRetrieval.this.exec_ctx.getChannel()){

                public void run() {
                    if (!MemoryBlock.this.expression_value.validate()) {
                        MemoryBlock.this.expression_value.wait((Runnable)((Object)this));
                    } else if (MemoryBlock.this.expression_value.getError() != null) {
                        this.error(MemoryBlock.this.expression_value.getError());
                    } else if (MemoryBlock.this.expression_value.getData() == null) {
                        this.error("Address expression evaluation failed");
                    } else if (!MemoryBlock.this.expression_type.validate()) {
                        MemoryBlock.this.expression_type.wait((Runnable)((Object)this));
                    } else if (MemoryBlock.this.expression_type.getError() != null) {
                        this.error(MemoryBlock.this.expression_type.getError());
                    } else {
                        IExpressions.Value value = (IExpressions.Value)MemoryBlock.this.expression_value.getData();
                        byte[] data = value.getValue();
                        if (data == null || data.length == 0) {
                            this.error("Address expression value is empty (void)");
                        } else {
                            ISymbols.Symbol type = (ISymbols.Symbol)MemoryBlock.this.expression_type.getData();
                            boolean signed = type != null && type.getTypeClass() == ISymbols.TypeClass.integer;
                            this.done(TCFNumberFormat.toBigInteger(data, value.isBigEndian(), signed));
                        }
                    }
                }
            }.getD();
        }

        public MemoryByte[] getBytesFromAddress(final BigInteger address, final long units) throws DebugException {
            return (MemoryByte[])new TCFDebugTask<MemoryByte[]>(TCFMemoryBlockRetrieval.this.exec_ctx.getChannel()){
                int offs;
                {
                    super($anonymous0);
                    this.offs = 0;
                }

                public void run() {
                    if (MemoryBlock.this.mem_data != null && address.compareTo(((MemoryBlock)MemoryBlock.this).mem_data.addr) >= 0 && address.add(BigInteger.valueOf(units)).compareTo(((MemoryBlock)MemoryBlock.this).mem_data.addr.add(BigInteger.valueOf(((MemoryBlock)MemoryBlock.this).mem_data.data.length))) <= 0) {
                        this.offs = address.subtract(((MemoryBlock)MemoryBlock.this).mem_data.addr).intValue();
                        MemoryByte[] res = ((MemoryBlock)MemoryBlock.this).mem_data.data;
                        if (units < (long)((MemoryBlock)MemoryBlock.this).mem_data.data.length) {
                            res = new MemoryByte[(int)units];
                            System.arraycopy(MemoryBlock.this.mem_data, this.offs, res, 0, res.length);
                        }
                        MemoryBlock.this.setHistoryFlags();
                        this.done(res);
                        return;
                    }
                    if (TCFMemoryBlockRetrieval.this.exec_ctx.isDisposed()) {
                        this.error("Context is disposed");
                        return;
                    }
                    TCFDataCache<IMemory.MemoryContext> cache = TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext();
                    if (!cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (cache.getError() != null) {
                        this.error(cache.getError());
                        return;
                    }
                    final IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                    if (mem == null) {
                        this.error("Context does not provide memory access");
                        return;
                    }
                    final int size = (int)units;
                    final byte[] buf = new byte[size];
                    final MemoryByte[] res = new MemoryByte[size];
                    mem.get((Number)address, 1, buf, 0, size, 3, new IMemory.DoneMemory(){

                        public void doneMemory(IToken token, IMemory.MemoryError error) {
                            int big_endian = 0;
                            if (mem.getProperties().get("BigEndian") != null) {
                                big_endian |= 0x20;
                                if (mem.isBigEndian()) {
                                    big_endian |= 0x10;
                                }
                            }
                            int cnt = 0;
                            while (offs < size) {
                                int flags = big_endian;
                                if (error instanceof IMemory.ErrorOffset) {
                                    IMemory.ErrorOffset ofs = (IMemory.ErrorOffset)error;
                                    int status = ofs.getStatus(cnt);
                                    if (status == 0) {
                                        flags |= 3;
                                    } else if ((status & 1) != 0 && cnt > 0) {
                                        break;
                                    }
                                } else if (error == null) {
                                    flags |= 3;
                                }
                                res[offs] = new MemoryByte(buf[offs], (byte)flags);
                                ++offs;
                                ++cnt;
                            }
                            if (offs < size) {
                                mem.get((Number)address.add(BigInteger.valueOf(offs)), 1, buf, offs, size - offs, 3, (IMemory.DoneMemory)this);
                            } else {
                                MemoryBlock memoryBlock = MemoryBlock.this;
                                MemData memData = new MemData(address, res);
                                MemoryBlock.this.mem_data = memData;
                                memoryBlock.mem_last = memData;
                                MemoryBlock.this.setHistoryFlags();
                                this.done(res);
                            }
                        }
                    });
                }
            }.getD();
        }

        private void setHistoryFlags() {
            if (this.mem_data == null) {
                return;
            }
            BigInteger addr = this.mem_data.addr;
            BigInteger his_start = null;
            BigInteger his_end = null;
            if (this.mem_prev != null) {
                his_start = this.mem_prev.addr;
                his_end = this.mem_prev.addr.add(BigInteger.valueOf(this.mem_prev.data.length));
            }
            MemoryByte[] memoryByteArray = this.mem_data.data;
            int n = this.mem_data.data.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryByte b = memoryByteArray[n2];
                int flags = b.getFlags();
                if (this.mem_prev != null && addr.compareTo(his_start) >= 0 && addr.compareTo(his_end) < 0) {
                    flags |= 8;
                    int offs = addr.subtract(his_start).intValue();
                    if (b.getValue() != this.mem_prev.data[offs].getValue()) {
                        flags |= 4;
                    }
                } else {
                    flags &= 0xFFFFFFF3;
                }
                b.setFlags((byte)flags);
                addr = addr.add(BigInteger.valueOf(1L));
                ++n2;
            }
        }

        public MemoryByte[] getBytesFromOffset(BigInteger offset, long units) throws DebugException {
            return this.getBytesFromAddress(this.getBigBaseAddress().add(offset), units);
        }

        public String getExpression() {
            return this.expression;
        }

        public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
            return TCFMemoryBlockRetrieval.this;
        }

        public long getStartAddress() {
            return 0L;
        }

        public long getLength() {
            return this.length;
        }

        public BigInteger getMemoryBlockStartAddress() throws DebugException {
            return null;
        }

        public BigInteger getMemoryBlockEndAddress() throws DebugException {
            return null;
        }

        public BigInteger getBigLength() throws DebugException {
            return BigInteger.valueOf(this.length);
        }

        public void setBaseAddress(BigInteger address) throws DebugException {
        }

        public void setValue(BigInteger offset, final byte[] bytes) throws DebugException {
            final BigInteger address = this.getBigBaseAddress().add(offset);
            new TCFDebugTask<Object>(TCFMemoryBlockRetrieval.this.exec_ctx.getChannel()){

                public void run() {
                    if (TCFMemoryBlockRetrieval.this.exec_ctx.isDisposed()) {
                        this.error("Context is disposed");
                        return;
                    }
                    TCFDataCache<IMemory.MemoryContext> cache = TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext();
                    if (!cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (cache.getError() != null) {
                        this.error(cache.getError());
                        return;
                    }
                    IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                    if (mem == null) {
                        this.error("Context does not provide memory access");
                        return;
                    }
                    mem.set((Number)address, 1, bytes, 0, bytes.length, 3, new IMemory.DoneMemory(){

                        public void doneMemory(IToken token, IMemory.MemoryError error) {
                            if (error != null) {
                                this.error((Throwable)error);
                            } else {
                                this.done(null);
                            }
                        }
                    });
                }
            }.getD();
        }

        public boolean supportBaseAddressModification() throws DebugException {
            return false;
        }

        public boolean supportsChangeManagement() {
            return true;
        }

        public byte[] getBytes() throws DebugException {
            if (this.mem_data == null) {
                return null;
            }
            return this.mem_data.bytes;
        }

        public void setValue(long offset, byte[] bytes) throws DebugException {
            this.setValue(BigInteger.valueOf(offset), bytes);
        }

        public boolean supportsValueModification() {
            return true;
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public ILaunch getLaunch() {
            return ((TCFMemoryBlockRetrieval)TCFMemoryBlockRetrieval.this).exec_ctx.model.getLaunch();
        }

        public String getModelIdentifier() {
            return "org.eclipse.tcf.debug";
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IMemoryBlockRetrieval.class) {
                return TCFMemoryBlockRetrieval.this;
            }
            if (adapter == IMemoryBlockRetrievalExtension.class) {
                return TCFMemoryBlockRetrieval.this;
            }
            return super.getAdapter(adapter);
        }
    }
}

