/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class ViewsUtil {
    public static IWorkbenchPart getPart(String id) {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            IViewReference reference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(id);
            return reference != null ? reference.getPart(false) : null;
        }
        return null;
    }

    public static void refresh(final String id) {
        Assert.isNotNull((Object)id);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                    CommonViewer viewer;
                    IViewReference reference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(id);
                    IWorkbenchPart part = reference != null ? reference.getPart(false) : null;
                    CommonViewer commonViewer = viewer = part instanceof CommonNavigator ? ((CommonNavigator)part).getCommonViewer() : null;
                    if (viewer == null) {
                        Viewer viewer2 = viewer = part != null ? (Viewer)part.getAdapter(Viewer.class) : null;
                    }
                    if (viewer != null) {
                        viewer.refresh();
                    }
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    public static void setSelection(final String id, final ISelection selection) {
        Assert.isNotNull((Object)id);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                    ISelectionProvider selectionProvider;
                    IViewReference reference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(id);
                    IWorkbenchPart part = reference != null ? reference.getPart(false) : null;
                    ISelectionProvider iSelectionProvider = selectionProvider = part != null && part.getSite() != null ? part.getSite().getSelectionProvider() : null;
                    if (selectionProvider != null) {
                        selectionProvider.setSelection(selection);
                    }
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    public static void openProperties(final ISelection selection) {
        Assert.isNotNull((Object)selection);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Command command;
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
                if (service != null && (command = service.getCommand("org.eclipse.ui.file.properties")) != null && command.isDefined()) {
                    EvaluationContext context = new EvaluationContext(null, (Object)selection);
                    context.addVariable("selection", (Object)selection);
                    context.addVariable("activeMenuSelection", (Object)selection);
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    context.addVariable("activeWorkbenchWindow", (Object)window);
                    context.addVariable("activeShell", (Object)window.getShell());
                    IWorkbenchPart part = window.getActivePage().getActivePart();
                    IWorkbenchPartSite site = part.getSite();
                    context.addVariable("activePartId", (Object)site.getId());
                    context.addVariable("activePart", (Object)part);
                    context.addVariable("activeSite", (Object)site);
                    context.setAllowPluginActivation(true);
                    try {
                        ParameterizedCommand pCmd = ParameterizedCommand.generateCommand((Command)command, null);
                        Assert.isNotNull((Object)pCmd);
                        IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                        Assert.isNotNull((Object)handlerSvc);
                        handlerSvc.executeCommandInContext(pCmd, null, (IEvaluationContext)context);
                    }
                    catch (Exception exception) {}
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }
}

