/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.locator.interfaces.IScanner;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerModel;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;

public class ScannerRunnable
implements Runnable,
IChannel.IChannelListener {
    private final IScanner parentScanner;
    final IPeerModel peerNode;
    IChannel channel = null;
    boolean sharedChannel = false;
    private int oldState = -1;

    public ScannerRunnable(IScanner scanner, IPeerModel peerNode) {
        this.parentScanner = scanner;
        Assert.isNotNull((Object)peerNode);
        this.peerNode = peerNode;
    }

    protected final IScanner getParentScanner() {
        return this.parentScanner;
    }

    @Override
    public void run() {
        this.oldState = this.peerNode.getIntProperty("state");
        if (this.peerNode.isComplete() && this.peerNode.getPeer() != null) {
            this.channel = Tcf.getChannelManager().getChannel(this.peerNode.getPeer());
            if (this.channel == null || this.channel.getState() != 1) {
                this.sharedChannel = false;
                this.channel = this.peerNode.getPeer().openChannel();
                this.channel.addChannelListener((IChannel.IChannelListener)this);
            } else {
                this.sharedChannel = true;
                this.onChannelOpened();
            }
        }
    }

    public void onChannelOpened() {
        if (this.channel != null && !this.sharedChannel) {
            this.channel.removeChannelListener((IChannel.IChannelListener)this);
        }
        boolean changed = this.peerNode.setChangeEventsEnabled(false);
        boolean refreshEditorTabs = false;
        int counter = this.peerNode.getIntProperty("channelRefCounter.silent");
        this.peerNode.setProperty("state", counter > 0 ? 1 : 0);
        this.peerNode.setProperty("lastScannerError", null);
        boolean bl = refreshEditorTabs = this.oldState != 1 && this.oldState != 0;
        if (this.channel != null && this.channel.getState() == 1) {
            boolean keepOpen = false;
            final ILocatorModel model = (ILocatorModel)this.peerNode.getAdapter(ILocatorModel.class);
            if (model != null) {
                String ip;
                ILocator locator = (ILocator)this.channel.getRemoteService(ILocator.class);
                if (locator != null) {
                    keepOpen = true;
                    new Command(this.channel, (IService)locator, "getPeers", null){

                        public void done(Exception error, Object[] args) {
                            if (error == null) {
                                Assert.isTrue((args.length == 2 ? 1 : 0) != 0);
                                error = this.toError(args[0]);
                            }
                            if (error == null && args[1] != null) {
                                IPeer parentPeer = ScannerRunnable.this.channel.getRemotePeer();
                                ArrayList<IPeerModel> oldChildren = new ArrayList<IPeerModel>(model.getChildren(parentPeer.getID()));
                                Collection peerAttributesList = (Collection)args[1];
                                for (Map attributes : peerAttributesList) {
                                    String peerId = (String)attributes.get("ID");
                                    PeerRedirector peer = new PeerRedirector(parentPeer, attributes);
                                    IPeerModel peerNode = model.getService(ILocatorModelLookupService.class).lkupPeerModelById(parentPeer.getID(), peerId);
                                    if (peerNode == null) {
                                        peerNode = new PeerModel(model, peer);
                                        peerNode.setParent(ScannerRunnable.this.peerNode);
                                        peerNode = model.validateChildPeerNodeForAdd(peerNode);
                                        if (peerNode == null) continue;
                                        model.getService(ILocatorModelUpdateService.class).addChild(peerNode);
                                        ScannerRunnable runnable = new ScannerRunnable(ScannerRunnable.this.getParentScanner(), peerNode);
                                        Protocol.invokeLater((Runnable)runnable);
                                        continue;
                                    }
                                    Assert.isTrue((peerNode.getParent(IPeerModel.class) != null && ((IPeerModel)peerNode.getParent(IPeerModel.class)).equals(ScannerRunnable.this.peerNode) ? 1 : 0) != 0);
                                    peerNode.setProperty("instance", peer);
                                    oldChildren.remove(peerNode);
                                }
                                for (IPeerModel child : oldChildren) {
                                    String value = (String)child.getPeer().getAttributes().get("static.transient");
                                    if (value != null && Boolean.parseBoolean(value.trim())) continue;
                                    model.getService(ILocatorModelUpdateService.class).removeChild(child);
                                }
                            }
                            if (!ScannerRunnable.this.sharedChannel) {
                                ScannerRunnable.this.channel.close();
                            }
                        }
                    };
                }
                if (!((ip = (String)this.channel.getRemotePeer().getAttributes().get("Host")) == null || "".equals(ip) || this.peerNode.getStringProperty("dns.name.transient") != null && ip.equals(this.peerNode.getStringProperty("dns.lastIP.transient")))) {
                    if (!ip.equals(this.peerNode.getStringProperty("dns.lastIP.transient"))) {
                        this.peerNode.setProperty("dns.lastIP.transient", ip);
                        this.peerNode.setProperty("dns.skip.transient", false);
                    }
                    if (!this.peerNode.getBooleanProperty("dns.skip.transient")) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    InetAddress address = InetAddress.getByName(ip);
                                    final AtomicReference<String> nameRef = new AtomicReference<String>();
                                    nameRef.set(address.getCanonicalHostName());
                                    if (ip.equals(nameRef.get()) && IPAddressUtil.getInstance().isLocalHost(ip)) {
                                        String[] candidates;
                                        String[] stringArray = candidates = IPAddressUtil.getInstance().getCanonicalHostNames();
                                        int n = candidates.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String candidate = stringArray[n2];
                                            if (!ip.equals(candidate)) {
                                                nameRef.set(candidate);
                                                break;
                                            }
                                            ++n2;
                                        }
                                    }
                                    Protocol.invokeLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            String name = (String)nameRef.get();
                                            if (name != null && !"".equals(name) && !ip.equals(name)) {
                                                String dnsName;
                                                String string = dnsName = name.indexOf(46) != -1 ? name.substring(0, name.indexOf(46)) : name;
                                                if (!ip.equalsIgnoreCase(dnsName)) {
                                                    (this).ScannerRunnable.this.peerNode.setProperty("dns.name.transient", dnsName.toLowerCase());
                                                }
                                            }
                                        }
                                    });
                                }
                                catch (UnknownHostException unknownHostException) {
                                    Protocol.invokeLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            (this).ScannerRunnable.this.peerNode.setProperty("dns.skip.transient", true);
                                        }
                                    });
                                }
                            }
                        };
                        Thread thread = new Thread(runnable, "DNS Query Thread for " + ip);
                        thread.start();
                    }
                }
            }
            if (!this.sharedChannel && !keepOpen) {
                this.channel.close();
            }
        }
        if (changed) {
            this.peerNode.setChangeEventsEnabled(true);
            this.peerNode.fireChangeEvent("properties", null, this.peerNode.getProperties());
        }
        if (refreshEditorTabs) {
            this.peerNode.fireChangeEvent("editor.refreshTab", Boolean.FALSE, Boolean.TRUE);
        }
    }

    public void onChannelClosed(Throwable error) {
        if (this.channel != null) {
            this.channel.removeChannelListener((IChannel.IChannelListener)this);
        }
        if (this.parentScanner == null || !this.parentScanner.isTerminated()) {
            boolean changed = this.peerNode.setChangeEventsEnabled(false);
            this.peerNode.setProperty("channelRefCounter.silent", null);
            boolean timeout = error instanceof SocketTimeoutException || error instanceof ConnectException && error.getMessage() != null && error.getMessage().startsWith("Connection timed out:");
            this.peerNode.setProperty("state", timeout ? 2 : 3);
            this.peerNode.setProperty("lastScannerError", error instanceof SocketTimeoutException ? null : error);
            ILocatorModel model = (ILocatorModel)this.peerNode.getAdapter(ILocatorModel.class);
            if (model != null) {
                ILocatorModelUpdateService updateService = model.getService(ILocatorModelUpdateService.class);
                updateService.updatePeerServices(this.peerNode, null, null);
            }
            this.peerNode.setProperty("dns.name.transient", null);
            this.peerNode.setProperty("dns.lastIP.transient", null);
            this.peerNode.setProperty("dns.skip.transient", null);
            if (changed) {
                this.peerNode.setChangeEventsEnabled(true);
                this.peerNode.fireChangeEvent("properties", null, this.peerNode.getProperties());
            }
            if (this.oldState != 2 && this.oldState != 3) {
                this.peerNode.fireChangeEvent("editor.refreshTab", Boolean.FALSE, Boolean.TRUE);
            }
        }
    }

    public void congestionLevel(int level) {
    }
}

