/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.callbacks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.CallbackMonitor;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.RefreshDoneGetContext;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.RefreshDoneMonitorCallback;
import org.eclipse.tcf.te.tcf.processes.core.model.ProcessTreeNode;

public class RefreshDoneGetChildren
implements ISysMonitor.DoneGetChildren {
    IChannel channel;
    ISysMonitor service;
    ProcessTreeNode parentNode;
    Queue<ProcessTreeNode> queue;
    ICallback callback;

    public RefreshDoneGetChildren(ICallback callback, Queue<ProcessTreeNode> queue, IChannel channel, ISysMonitor service, ProcessTreeNode parentNode) {
        this.callback = callback;
        this.queue = queue;
        this.channel = channel;
        this.service = service;
        this.parentNode = parentNode;
    }

    public void doneGetChildren(IToken token, Exception error, String[] contextIds) {
        if (error == null) {
            if (contextIds != null && contextIds.length > 0) {
                IProcesses pService = (IProcesses)this.channel.getRemoteService(IProcesses.class);
                if (pService != null) {
                    List<ProcessTreeNode> newNodes = Collections.synchronizedList(new ArrayList());
                    RefreshDoneMonitorCallback monitorCallback = new RefreshDoneMonitorCallback(newNodes, this.parentNode, this.queue, this.callback, this.service, this.channel);
                    CallbackMonitor monitor = new CallbackMonitor((ICallback)monitorCallback, contextIds);
                    String[] stringArray = contextIds;
                    int n = contextIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String contextId = stringArray[n2];
                        RefreshDoneGetContext done = new RefreshDoneGetContext(this.channel, newNodes, contextId, monitor, this.parentNode);
                        this.service.getContext(contextId, (ISysMonitor.DoneGetContext)done);
                        pService.getContext(contextId, (IProcesses.DoneGetContext)done);
                        ++n2;
                    }
                }
            } else {
                this.parentNode.queryDone();
                this.parentNode.clearChildren();
                if (this.queue.isEmpty()) {
                    if (this.callback != null) {
                        this.callback.done((Object)this, Status.OK_STATUS);
                    }
                } else {
                    ProcessTreeNode node = this.queue.poll();
                    this.service.getChildren(node.id, (ISysMonitor.DoneGetChildren)new RefreshDoneGetChildren(this.callback, this.queue, this.channel, this.service, node));
                }
            }
        } else {
            this.parentNode.queryDone();
            if (this.callback != null) {
                Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), error.getMessage(), (Throwable)error);
                this.callback.done((Object)this, (IStatus)status);
            }
        }
    }
}

