/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.launch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.internal.debug.Activator;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.util.TCFTask;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFLocalAgent {
    private static final String AGENT_HOST = "127.0.0.1";
    private static final String AGENT_PORT = "1534";
    private static Process agent;
    private static boolean destroed;

    private static String getAgentFileName() {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String fnm = "agent";
        if (arch.equals("x86")) {
            arch = "i386";
        }
        if (arch.equals("i686")) {
            arch = "i386";
        }
        if (os.startsWith("Windows")) {
            os = "Windows";
            fnm = "agent.exe";
        }
        if (os.equals("Linux")) {
            os = "GNU/Linux";
        }
        return "agent/" + os + "/" + arch + "/" + fnm;
    }

    public static synchronized String runLocalAgent() throws CoreException {
        if (destroed) {
            return null;
        }
        String id = TCFLocalAgent.getLocalAgentID();
        if (id != null) {
            return id;
        }
        if (agent != null) {
            agent.destroy();
            agent = null;
        }
        Path fnm = new Path(TCFLocalAgent.getAgentFileName());
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.tcf.debug");
            URL url = FileLocator.find((Bundle)bundle, (IPath)fnm, null);
            if (url != null) {
                URLConnection ucn = url.openConnection();
                ucn.setRequestProperty("Method", "HEAD");
                ucn.connect();
                long mtime = ucn.getLastModified();
                File f = Activator.getDefault().getStateLocation().append((IPath)fnm).toFile();
                if (!f.exists() || mtime != f.lastModified()) {
                    int len;
                    f.getParentFile().mkdirs();
                    InputStream inp = url.openStream();
                    FileOutputStream out = new FileOutputStream(f);
                    byte[] buf = new byte[4096];
                    while ((len = inp.read(buf)) >= 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((OutputStream)out).close();
                    inp.close();
                    if (!"exe".equals(fnm.getFileExtension())) {
                        String[] cmd = new String[]{"chmod", "a+x", f.getAbsolutePath()};
                        Runtime.getRuntime().exec(cmd).waitFor();
                    }
                    f.setLastModified(mtime);
                }
                String[] cmd = new String[]{f.getAbsolutePath(), "-s", "TCP:127.0.0.1:1534"};
                final Process prs = agent = Runtime.getRuntime().exec(cmd);
                final TCFTask<String> waiting = TCFLocalAgent.waitAgentReady();
                Thread t = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            final int n = prs.waitFor();
                            if (n != 0) {
                                Protocol.invokeLater((Runnable)new Runnable(){

                                    public void run() {
                                        if (waiting.isDone()) {
                                            return;
                                        }
                                        waiting.error((Throwable)new IOException("TCF Agent exited with code " + n));
                                    }
                                });
                            }
                            Class<TCFLocalAgent> clazz = TCFLocalAgent.class;
                            synchronized (TCFLocalAgent.class) {
                                if (agent == prs) {
                                    if (n != 0 && !destroed) {
                                        Activator.log("TCF Agent exited with code " + n, null);
                                    }
                                    agent = null;
                                }
                                // ** MonitorExit[var2_3] (shouldn't be in output)
                            }
                        }
                        catch (InterruptedException x) {
                            Activator.log("TCF Agent Monitor interrupted", x);
                        }
                        {
                            return;
                        }
                    }
                };
                t.setDaemon(true);
                t.setName("TCF Agent Monitor");
                t.start();
                return (String)waiting.getIO();
            }
        }
        catch (Throwable x) {
            agent = null;
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tcf.debug", 0, "Cannot start local TCF agent.", x));
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.tcf.debug", 0, "Cannot start local TCF agent: file not available:\n" + fnm, null));
    }

    private static boolean isLocalAgent(IPeer p) {
        String prot = p.getTransportName();
        if (prot.equals("PIPE")) {
            return true;
        }
        if (prot.equals("UNIX")) {
            String port = (String)p.getAttributes().get("Port");
            return AGENT_PORT.equals(port);
        }
        String host = (String)p.getAttributes().get("Host");
        String port = (String)p.getAttributes().get("Port");
        return AGENT_HOST.equals(host) && AGENT_PORT.equals(port);
    }

    public static synchronized String getLocalAgentID() {
        return (String)new TCFTask<String>(){

            public void run() {
                ILocator locator = Protocol.getLocator();
                for (IPeer p : locator.getPeers().values()) {
                    if (!TCFLocalAgent.isLocalAgent(p)) continue;
                    this.done(p.getID());
                    return;
                }
                this.done(null);
            }
        }.getE();
    }

    private static TCFTask<String> waitAgentReady() {
        return new TCFTask<String>(){

            public void run() {
                final ILocator locator = Protocol.getLocator();
                for (IPeer p : locator.getPeers().values()) {
                    if (!TCFLocalAgent.isLocalAgent(p)) continue;
                    this.done(p.getID());
                    return;
                }
                final ILocator.LocatorListener listener = new ILocator.LocatorListener(){

                    public void peerAdded(IPeer p) {
                        if (!this.isDone() && TCFLocalAgent.isLocalAgent(p)) {
                            this.done(p.getID());
                            locator.removeListener((ILocator.LocatorListener)this);
                        }
                    }

                    public void peerChanged(IPeer peer) {
                    }

                    public void peerHeartBeat(String id) {
                    }

                    public void peerRemoved(String id) {
                    }
                };
                locator.addListener(listener);
                Protocol.invokeLater((long)30000L, (Runnable)new Runnable(){

                    public void run() {
                        if (!this.isDone()) {
                            this.error(new Exception("Timeout waiting for TCF Agent to start"));
                            locator.removeListener(listener);
                        }
                    }
                });
            }
        };
    }

    public static synchronized void destroy() {
        if (agent != null) {
            destroed = true;
            agent.destroy();
        }
    }
}

