/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.util.HashSet;
import java.util.Random;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IDiagnostics;
import org.eclipse.tcf.services.IStreams;

class TestStreams
implements ITCFTest,
IStreams.StreamsListener {
    private final TCFTestSuite test_suite;
    private final IDiagnostics diag;
    private final IStreams streams;
    private final Random rnd = new Random();
    private final HashSet<String> stream_ids = new HashSet();
    private String inp_id;
    private String out_id;
    private int test_count;
    private long start_time;

    TestStreams(TCFTestSuite test_suite, IChannel channel) {
        this.test_suite = test_suite;
        this.diag = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
        this.streams = (IStreams)channel.getRemoteService(IStreams.class);
    }

    public void start() {
        if (this.diag == null || this.streams == null) {
            this.test_suite.done(this, null);
        } else {
            this.start_time = System.currentTimeMillis();
            this.connect();
        }
    }

    private void connect() {
        this.diag.createTestStreams(1001, 771, new IDiagnostics.DoneCreateTestStreams(){

            public void doneCreateTestStreams(IToken token, Throwable error, final String inp_id, final String out_id) {
                if (error != null) {
                    TestStreams.this.exit(error);
                } else {
                    TestStreams.this.inp_id = inp_id;
                    TestStreams.this.out_id = out_id;
                    if (TestStreams.this.stream_ids.size() != 0) {
                        TestStreams.this.exit(new Exception("Stream events without subscription"));
                        return;
                    }
                    TestStreams.this.streams.connect(inp_id, new IStreams.DoneConnect(){

                        public void doneConnect(IToken token, Exception error) {
                            if (error != null) {
                                TestStreams.this.exit(error);
                            } else {
                                byte[] data_out = new byte[TestStreams.this.rnd.nextInt(10000) + 1000];
                                IStreams.DoneWrite done_write = new IStreams.DoneWrite(){

                                    public void doneWrite(IToken token, Exception error) {
                                        if (error != null) {
                                            TestStreams.this.exit(error);
                                        }
                                    }
                                };
                                int offs = 0;
                                while (offs < data_out.length) {
                                    int size = TestStreams.this.rnd.nextInt(400);
                                    if (size > data_out.length - offs) {
                                        size = data_out.length - offs;
                                    }
                                    TestStreams.this.streams.write(inp_id, data_out, offs, size, done_write);
                                    offs += size;
                                }
                                TestStreams.this.streams.connect(out_id, new IStreams.DoneConnect(){

                                    public void doneConnect(IToken token, Exception error) {
                                        if (error != null) {
                                            TestStreams.this.exit(error);
                                        } else {
                                            TestStreams.this.testReadWrite(true, new Runnable(){

                                                public void run() {
                                                    TestStreams.this.inp_id = null;
                                                    TestStreams.this.out_id = null;
                                                    TestStreams.this.subscribe();
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    }

    private void subscribe() {
        this.streams.subscribe("Diagnostics", (IStreams.StreamsListener)this, new IStreams.DoneSubscribe(){

            public void doneSubscribe(IToken token, Exception error) {
                if (error != null) {
                    TestStreams.this.exit(error);
                } else {
                    TestStreams.this.createStreams();
                }
            }
        });
    }

    private void createStreams() {
        this.diag.createTestStreams(1153, 947, new IDiagnostics.DoneCreateTestStreams(){

            public void doneCreateTestStreams(IToken token, Throwable error, String inp_id, String out_id) {
                if (error != null) {
                    TestStreams.this.exit(error);
                } else {
                    TestStreams.this.inp_id = inp_id;
                    TestStreams.this.out_id = out_id;
                    for (String id : TestStreams.this.stream_ids) {
                        if (id.equals(inp_id) || id.equals(out_id)) continue;
                        TestStreams.this.streams.disconnect(id, new IStreams.DoneDisconnect(){

                            public void doneDisconnect(IToken token, Exception error) {
                                if (error != null) {
                                    TestStreams.this.exit(error);
                                }
                            }
                        });
                    }
                    TestStreams.this.testReadWrite(false, new Runnable(){

                        public void run() {
                            TestStreams.this.unsubscribe();
                        }
                    });
                }
            }
        });
    }

    private void testReadWrite(final boolean skip_zeros, final Runnable done) {
        final byte[] data_out = new byte[this.rnd.nextInt(10000) + 1000];
        new Random().nextBytes(data_out);
        if (skip_zeros) {
            data_out[0] = 1;
        }
        final HashSet<IToken> cmds = new HashSet<IToken>();
        IStreams.DoneRead done_read = new IStreams.DoneRead(){
            private int offs = 0;
            private boolean eos;

            public void doneRead(IToken token, Exception error, int lost_size, byte[] data, boolean eos) {
                cmds.remove(token);
                if (error != null) {
                    if (!this.eos) {
                        TestStreams.this.exit(error);
                    }
                } else if (lost_size != 0) {
                    TestStreams.this.exit(new Exception("Streams service: unexpected data loss"));
                } else if (this.eos) {
                    if (!eos || data != null && data.length > 0) {
                        TestStreams.this.exit(new Exception("Streams service: unexpected successful read after EOS"));
                    }
                } else {
                    if (data != null) {
                        if (this.offs + data.length > data_out.length) {
                            TestStreams.this.exit(new Exception("Streams service: read returns more data then expected"));
                            return;
                        }
                        int n = 0;
                        while (n < data.length) {
                            if (!skip_zeros || this.offs > 0 || data[n] != 0) {
                                if (data[n] != data_out[this.offs]) {
                                    TestStreams.this.exit(new Exception("Streams service: data error: " + data[n] + " != " + data_out[this.offs]));
                                    return;
                                }
                                ++this.offs;
                            }
                            ++n;
                        }
                    }
                    if (eos) {
                        if (this.offs != data_out.length) {
                            TestStreams.this.exit(new Exception("Streams service: unexpected EOS"));
                        }
                        this.eos = true;
                    } else if (cmds.size() < 8) {
                        cmds.add(TestStreams.this.streams.read(TestStreams.this.out_id, 241, (IStreams.DoneRead)this));
                    }
                }
                if (cmds.isEmpty()) {
                    TestStreams.this.disposeStreams(done);
                }
            }
        };
        cmds.add(this.streams.read(this.out_id, 223, done_read));
        cmds.add(this.streams.read(this.out_id, 227, done_read));
        cmds.add(this.streams.read(this.out_id, 229, done_read));
        cmds.add(this.streams.read(this.out_id, 233, done_read));
        IStreams.DoneWrite done_write = new IStreams.DoneWrite(){

            public void doneWrite(IToken token, Exception error) {
                if (error != null) {
                    TestStreams.this.exit(error);
                }
            }
        };
        int offs = 0;
        while (offs < data_out.length) {
            int size = this.rnd.nextInt(400);
            if (size > data_out.length - offs) {
                size = data_out.length - offs;
            }
            this.streams.write(this.inp_id, data_out, offs, size, done_write);
            offs += size;
        }
        this.streams.eos(this.inp_id, new IStreams.DoneEOS(){

            public void doneEOS(IToken token, Exception error) {
                if (error != null) {
                    TestStreams.this.exit(error);
                }
            }
        });
    }

    private void disposeStreams(final Runnable done) {
        final HashSet<IToken> cmds = new HashSet<IToken>();
        IStreams.DoneDisconnect done_disconnect = new IStreams.DoneDisconnect(){

            public void doneDisconnect(IToken token, Exception error) {
                if (error != null) {
                    TestStreams.this.exit(error);
                } else {
                    cmds.remove(token);
                    if (cmds.isEmpty() && TestStreams.this.test_suite.isActive(TestStreams.this)) {
                        done.run();
                    }
                }
            }
        };
        IDiagnostics.DoneDisposeTestStream done_dispose = new IDiagnostics.DoneDisposeTestStream(){

            public void doneDisposeTestStream(IToken token, Throwable error) {
                if (error != null) {
                    TestStreams.this.exit(error);
                } else {
                    cmds.remove(token);
                    if (cmds.isEmpty() && TestStreams.this.test_suite.isActive(TestStreams.this)) {
                        done.run();
                    }
                }
            }
        };
        cmds.add(this.streams.disconnect(this.inp_id, done_disconnect));
        cmds.add(this.diag.disposeTestStream(this.inp_id, done_dispose));
        cmds.add(this.diag.disposeTestStream(this.out_id, done_dispose));
        cmds.add(this.streams.disconnect(this.out_id, done_disconnect));
    }

    private void unsubscribe() {
        this.streams.unsubscribe("Diagnostics", (IStreams.StreamsListener)this, new IStreams.DoneUnsubscribe(){

            public void doneUnsubscribe(IToken token, Exception error) {
                if (error != null || TestStreams.this.test_count >= 10 || System.currentTimeMillis() - TestStreams.this.start_time >= 4000L) {
                    TestStreams.this.exit(error);
                } else {
                    TestStreams testStreams = TestStreams.this;
                    testStreams.test_count = testStreams.test_count + 1;
                    TestStreams.this.stream_ids.clear();
                    TestStreams.this.inp_id = null;
                    TestStreams.this.out_id = null;
                    TestStreams.this.connect();
                }
            }
        });
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        this.test_suite.done(this, x);
    }

    public void created(String stream_type, String stream_id, String context_id) {
        if (!"Diagnostics".equals(stream_type)) {
            this.exit(new Exception("Invalid stream type in Streams.created event"));
        }
        if (this.stream_ids.contains(stream_id)) {
            this.exit(new Exception("Invalid stream ID in Streams.created event"));
        }
        this.stream_ids.add(stream_id);
        if (this.inp_id != null) {
            if (this.inp_id.equals(stream_id)) {
                this.exit(new Exception("Invalid stream ID in Streams.created event"));
            }
            if (this.out_id.equals(stream_id)) {
                this.exit(new Exception("Invalid stream ID in Streams.created event"));
            }
            this.streams.disconnect(stream_id, new IStreams.DoneDisconnect(){

                public void doneDisconnect(IToken token, Exception error) {
                    if (error != null) {
                        TestStreams.this.exit(error);
                    }
                }
            });
        }
    }

    public void disposed(String stream_type, String stream_id) {
        if (!"Diagnostics".equals(stream_type)) {
            this.exit(new Exception("Invalid stream type in Streams.disposed event"));
        }
        if (!this.stream_ids.remove(stream_id)) {
            this.exit(new Exception("Invalid stream ID in Streams.disposed event"));
        }
    }

    public boolean canResume(String id) {
        return true;
    }
}

