/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.ISymbols;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolsProxy
implements ISymbols {
    private final IChannel channel;

    public SymbolsProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public String getName() {
        return "Symbols";
    }

    @Override
    public IToken getContext(String id, final ISymbols.DoneGetContext done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getContext", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                Context ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new Context((Map)args[1]);
                    }
                }
                done.doneGetContext(this.token, error, ctx);
            }
        }.token;
    }

    @Override
    public IToken getChildren(String parent_context_id, final ISymbols.DoneGetChildren done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getChildren", (Object[])new Object[]{parent_context_id}){

            public void done(Exception error, Object[] args) {
                String[] lst = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    lst = SymbolsProxy.this.toStringArray(args[1]);
                }
                done.doneGetChildren(this.token, error, lst);
            }
        }.token;
    }

    @Override
    public IToken find(String context_id, Number ip, String name, final ISymbols.DoneFind done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"find", (Object[])new Object[]{context_id, ip, name}){

            public void done(Exception error, Object[] args) {
                String id = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    id = (String)args[1];
                }
                done.doneFind(this.token, error, id);
            }
        }.token;
    }

    @Override
    public IToken findByName(String context_id, Number ip, String name, final ISymbols.DoneFindAll done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"findByName", (Object[])new Object[]{context_id, ip, name}){

            public void done(Exception error, Object[] args) {
                String[] ids = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    ids = SymbolsProxy.this.toStringArray(args[1]);
                }
                done.doneFind(this.token, error, ids);
            }
        }.token;
    }

    @Override
    public IToken findInScope(String context_id, Number ip, String scope_id, String name, final ISymbols.DoneFindAll done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"findInScope", (Object[])new Object[]{context_id, ip, scope_id, name}){

            public void done(Exception error, Object[] args) {
                String[] ids = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    ids = SymbolsProxy.this.toStringArray(args[1]);
                }
                done.doneFind(this.token, error, ids);
            }
        }.token;
    }

    @Override
    public IToken findByAddr(String context_id, Number addr, final ISymbols.DoneFind done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"findByAddr", (Object[])new Object[]{context_id, addr}){

            public void done(Exception error, Object[] args) {
                String id = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    id = (String)args[1];
                }
                done.doneFind(this.token, error, id);
            }
        }.token;
    }

    @Override
    public IToken list(String context_id, final ISymbols.DoneList done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"list", (Object[])new Object[]{context_id}){

            public void done(Exception error, Object[] args) {
                String[] lst = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    lst = SymbolsProxy.this.toStringArray(args[1]);
                }
                done.doneList(this.token, error, lst);
            }
        }.token;
    }

    @Override
    public IToken getLocationInfo(String symbol_id, final ISymbols.DoneGetLocationInfo done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getLocationInfo", (Object[])new Object[]{symbol_id}){

            public void done(Exception error, Object[] args) {
                Map props = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    props = (Map)args[1];
                }
                done.doneGetLocationInfo(this.token, error, props);
            }
        }.token;
    }

    @Override
    public IToken findFrameInfo(String context_id, Number address, final ISymbols.DoneFindFrameInfo done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"findFrameInfo", (Object[])new Object[]{context_id, address}){

            public void done(Exception error, Object[] args) {
                Number address = null;
                Number size = null;
                Object[] fp_cmds = null;
                Map reg_cmds = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 5) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    address = (Number)args[1];
                    size = (Number)args[2];
                    fp_cmds = SymbolsProxy.this.toObjectArray(args[3]);
                    reg_cmds = SymbolsProxy.this.toStringMap(args[4]);
                }
                done.doneFindFrameInfo(this.token, error, address, size, fp_cmds, reg_cmds);
            }
        }.token;
    }

    @Override
    public IToken getSymFileInfo(String context_id, Number address, final ISymbols.DoneGetSymFileInfo done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getSymFileInfo", (Object[])new Object[]{context_id, address}){

            public void done(Exception error, Object[] args) {
                Map props = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    props = (Map)args[1];
                }
                done.doneGetSymFileInfo(this.token, error, props);
            }
        }.token;
    }

    private String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    private Object[] toObjectArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new Object[c.size()]);
    }

    private Map<String, Object[]> toStringMap(Object o) {
        if (o == null) {
            return null;
        }
        Map c = (Map)o;
        HashMap<String, Object[]> m = new HashMap<String, Object[]>();
        for (Map.Entry e : c.entrySet()) {
            m.put((String)e.getKey(), this.toObjectArray(e.getValue()));
        }
        return m;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Context
    implements ISymbols.Symbol {
        private final byte[] value;
        private final Map<String, Object> props;

        Context(Map<String, Object> props) {
            this.props = props;
            this.value = JSON.toByteArray(props.get("Value"));
        }

        @Override
        public String getOwnerID() {
            return (String)this.props.get("OwnerID");
        }

        @Override
        public int getUpdatePolicy() {
            Number n = (Number)this.props.get("UpdatePolicy");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public Number getAddress() {
            return (Number)this.props.get("Address");
        }

        @Override
        public String getBaseTypeID() {
            return (String)this.props.get("BaseTypeID");
        }

        @Override
        public String getID() {
            return (String)this.props.get("ID");
        }

        @Override
        public String getIndexTypeID() {
            return (String)this.props.get("IndexTypeID");
        }

        @Override
        public String getContainerID() {
            return (String)this.props.get("ContainerID");
        }

        @Override
        public int getLength() {
            Number n = (Number)this.props.get("Length");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public Number getLowerBound() {
            return (Number)this.props.get("LowerBound");
        }

        @Override
        public Number getUpperBound() {
            return (Number)this.props.get("UpperBound");
        }

        @Override
        public String getName() {
            return (String)this.props.get("Name");
        }

        @Override
        public int getOffset() {
            Number n = (Number)this.props.get("Offset");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }

        @Override
        public int getSize() {
            Number n = (Number)this.props.get("Size");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public ISymbols.SymbolClass getSymbolClass() {
            Number n = (Number)this.props.get("Class");
            if (n != null) {
                switch (n.intValue()) {
                    case 1: {
                        return ISymbols.SymbolClass.value;
                    }
                    case 2: {
                        return ISymbols.SymbolClass.reference;
                    }
                    case 3: {
                        return ISymbols.SymbolClass.function;
                    }
                    case 4: {
                        return ISymbols.SymbolClass.type;
                    }
                }
            }
            return ISymbols.SymbolClass.unknown;
        }

        @Override
        public ISymbols.TypeClass getTypeClass() {
            Number n = (Number)this.props.get("TypeClass");
            if (n != null) {
                switch (n.intValue()) {
                    case 1: {
                        return ISymbols.TypeClass.cardinal;
                    }
                    case 2: {
                        return ISymbols.TypeClass.integer;
                    }
                    case 3: {
                        return ISymbols.TypeClass.real;
                    }
                    case 4: {
                        return ISymbols.TypeClass.pointer;
                    }
                    case 5: {
                        return ISymbols.TypeClass.array;
                    }
                    case 6: {
                        return ISymbols.TypeClass.composite;
                    }
                    case 7: {
                        return ISymbols.TypeClass.enumeration;
                    }
                    case 8: {
                        return ISymbols.TypeClass.function;
                    }
                    case 9: {
                        return ISymbols.TypeClass.member_pointer;
                    }
                }
            }
            return ISymbols.TypeClass.unknown;
        }

        @Override
        public String getTypeID() {
            return (String)this.props.get("TypeID");
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public boolean isBigEndian() {
            Boolean b = (Boolean)this.props.get("Length");
            if (b == null) {
                return false;
            }
            return b;
        }

        @Override
        public String getRegisterID() {
            return (String)this.props.get("Register");
        }

        @Override
        public int getFlags() {
            Number n = (Number)this.props.get("Flags");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public boolean getFlag(int flag) {
            Number n = (Number)this.props.get("Flags");
            if (n == null) {
                return false;
            }
            return (n.intValue() & flag) != 0;
        }
    }
}

