/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.internal.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class RefreshCommand
extends AbstractActionDelegate {
    protected void selectionChanged() {
        this.getAction().setEnabled(this.getRootNode() != null);
    }

    protected void run() {
        final TCFNode node = this.getRootNode();
        if (node == null) {
            return;
        }
        new TCFTask<Object>(node.getChannel()){

            public void run() {
                IViewPart part = RefreshCommand.this.getView();
                TCFModel model = node.getModel();
                TCFNode ref_node = node;
                if (part instanceof IMemoryRenderingSite) {
                    TCFDataCache<TCFNodeExecContext> mem_cache = model.searchMemoryContext(node);
                    if (mem_cache == null) {
                        this.done(null);
                        return;
                    }
                    if (!mem_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    ref_node = (TCFNode)mem_cache.getData();
                }
                if (ref_node != null) {
                    ref_node.refresh((IWorkbenchPart)part);
                    if (model.clearLock((IWorkbenchPart)part)) {
                        model.setLock((IWorkbenchPart)part);
                    }
                }
                this.done(null);
            }
        }.getE();
    }

    private TCFNode getRootNode() {
        Object input;
        Object obj;
        ISelection selection;
        IViewPart view = this.getView();
        if (view == null) {
            return null;
        }
        IWorkbenchPartSite site = view.getSite();
        if (site != null && "org.eclipse.debug.ui.DebugView".equals(site.getId())) {
            TCFNode n = this.getSelectedNode();
            if (n == null) {
                return null;
            }
            return n.getModel().getRootNode();
        }
        if (site != null && "org.eclipse.debug.ui.MemoryView".equals(site.getId()) && (selection = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow()).getActiveContext()) instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof TCFNode) {
            return (TCFNode)obj;
        }
        if (view instanceof IDebugView && (input = ((IDebugView)view).getViewer().getInput()) instanceof TCFNode) {
            return (TCFNode)input;
        }
        return null;
    }
}

