/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;

public class UpdatePolicyMenu
extends CompoundContributionItem {
    private static final String[] policy_names = new String[]{"Automatic", "Manual", "Breakpoint Hit"};

    protected IContributionItem[] getContributionItems() {
        IContributionItem[] items = new IContributionItem[policy_names.length];
        int i = 0;
        while (i < items.length) {
            final int n = i;
            items[i] = new ContributionItem(){

                public void fill(final Menu menu, int index) {
                    final MenuItem item = new MenuItem(menu, 16);
                    item.setText(policy_names[n]);
                    final MenuListener menu_listener = new MenuListener(){

                        public void menuShown(MenuEvent e) {
                            item.setSelection(UpdatePolicyMenu.this.getPolicy() == n);
                        }

                        public void menuHidden(MenuEvent e) {
                        }
                    };
                    menu.addMenuListener(menu_listener);
                    item.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            menu.removeMenuListener(menu_listener);
                        }
                    });
                    item.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (item.getSelection()) {
                                UpdatePolicyMenu.this.setPolicy(n);
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                }
            };
            ++i;
        }
        return items;
    }

    private IWorkbenchPart getPart() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
    }

    private TCFNode getRootNode(IWorkbenchPart part) {
        Object input;
        IWorkbenchPartSite site = part.getSite();
        if (site == null || "org.eclipse.debug.ui.DebugView".equals(site.getId())) {
            return null;
        }
        if (part instanceof IDebugView && (input = ((IDebugView)part).getViewer().getInput()) instanceof TCFNode) {
            return (TCFNode)input;
        }
        return null;
    }

    private int getPolicy() {
        final IWorkbenchPart part = this.getPart();
        if (part == null) {
            return 0;
        }
        final TCFNode node = this.getRootNode(part);
        if (node == null) {
            return 0;
        }
        return (Integer)new TCFTask<Integer>(node.getChannel()){

            public void run() {
                TCFModel model = node.getModel();
                if (!model.isLocked(part)) {
                    this.done(0);
                } else {
                    this.done(model.getLockPolicy(part));
                }
            }
        }.getE();
    }

    private void setPolicy(final int n) {
        final IWorkbenchPart part = this.getPart();
        if (part == null) {
            return;
        }
        final TCFNode node = this.getRootNode(part);
        if (node == null) {
            return;
        }
        new TCFTask<Object>(node.getChannel()){

            public void run() {
                TCFModel model = node.getModel();
                model.setLockPolicy(part, n);
                this.done(null);
            }
        }.getE();
    }
}

