/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tcf.core.ErrorReport;
import org.eclipse.tcf.internal.debug.model.TCFSymFileRef;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.IDetailsProvider;
import org.eclipse.tcf.internal.debug.ui.model.StyledStringBuffer;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelFonts;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFNodeModule
extends TCFNode
implements IDetailsProvider {
    private final TCFNode.TCFData<TCFNodeExecContext.MemoryRegion> region;
    private static final RGB rgb_error = new RGB(192, 0, 0);

    protected TCFNodeModule(final TCFNodeExecContext parent, String id, final int index) {
        super(parent, id);
        this.region = new TCFNode.TCFData<TCFNodeExecContext.MemoryRegion>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                TCFDataCache<TCFNodeExecContext.MemoryRegion[]> map_cache = parent.getMemoryMap();
                if (!map_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                Throwable error = map_cache.getError();
                TCFNodeExecContext.MemoryRegion[] map_data = (TCFNodeExecContext.MemoryRegion[])map_cache.getData();
                TCFNodeExecContext.MemoryRegion region = null;
                if (map_data != null && index < map_data.length) {
                    region = map_data[index];
                }
                this.set(null, error, region);
                return true;
            }
        };
    }

    public TCFDataCache<TCFNodeExecContext.MemoryRegion> getRegion() {
        return this.region;
    }

    void onMemoryMapChanged() {
        this.region.reset();
    }

    @Override
    protected boolean getData(ILabelUpdate update, Runnable done) {
        IMemoryMap.MemoryRegion r;
        if (!this.region.validate(done)) {
            return false;
        }
        TCFNodeExecContext.MemoryRegion mr = (TCFNodeExecContext.MemoryRegion)this.region.getData();
        IMemoryMap.MemoryRegion memoryRegion = r = mr != null ? mr.region : null;
        if (r == null) {
            update.setLabel("...", 0);
        } else {
            String[] col_ids = update.getColumnIds();
            if (col_ids == null) {
                update.setLabel(r.getFileName(), 0);
            } else {
                int i = 0;
                while (i < col_ids.length) {
                    String col_id = col_ids[i];
                    if ("Name".equals(col_id)) {
                        update.setLabel(r.getFileName(), i);
                    } else if ("Address".equals(col_id)) {
                        update.setLabel(this.toHexString(r.getAddress()), i);
                    } else if ("Size".equals(col_id)) {
                        update.setLabel(this.toHexString(r.getSize()), i);
                    } else if ("Flags".equals(col_id)) {
                        update.setLabel(this.getFlagsLabel(r.getFlags()), i);
                    } else if ("Offset".equals(col_id)) {
                        update.setLabel(this.toHexString(r.getOffset()), i);
                    } else if ("Section".equals(col_id)) {
                        String sectionName = r.getSectionName();
                        update.setLabel(sectionName != null ? sectionName : "", i);
                    }
                    ++i;
                }
            }
        }
        update.setImageDescriptor(ImageCache.getImageDescriptor("icons/memory-map.gif"), 0);
        return true;
    }

    @Override
    protected void getFontData(ILabelUpdate update, String view_id) {
        FontData fn = TCFModelFonts.getNormalFontData(view_id);
        String[] cols = update.getColumnIds();
        if (cols == null || cols.length == 0) {
            update.setFontData(fn, 0);
        } else {
            String[] ids = update.getColumnIds();
            int i = 0;
            while (i < cols.length) {
                if ("Address".equals(ids[i]) || "Offset".equals(ids[i]) || "Size".equals(ids[i])) {
                    update.setFontData(TCFModelFonts.getMonospacedFontData(view_id), i);
                } else {
                    update.setFontData(fn, i);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean getDetailText(StyledStringBuffer bf, Runnable done) {
        IMemoryMap.MemoryRegion r;
        if (!this.region.validate(done)) {
            return false;
        }
        TCFNodeExecContext.MemoryRegion mr = (TCFNodeExecContext.MemoryRegion)this.region.getData();
        IMemoryMap.MemoryRegion memoryRegion = r = mr != null ? mr.region : null;
        if (r == null) {
            return true;
        }
        String file_name = r.getFileName();
        if (file_name != null) {
            String section;
            bf.append("File name: ", 1).append(file_name).append('\n');
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent;
            TCFDataCache<TCFSymFileRef> sym_cache = exe.getSymFileInfo(JSON.toBigInteger((Number)r.getAddress()));
            if (sym_cache != null) {
                if (!sym_cache.validate(done)) {
                    return false;
                }
                TCFSymFileRef sym_data = (TCFSymFileRef)sym_cache.getData();
                if (sym_data != null) {
                    if (sym_data.props != null) {
                        Map map;
                        String sym_file_name = (String)sym_data.props.get("FileName");
                        if (sym_file_name != null) {
                            bf.append("Symbol file name: ", 1).append(sym_file_name).append('\n');
                        }
                        if ((map = (Map)sym_data.props.get("FileError")) != null) {
                            String msg = TCFModel.getErrorMessage((Throwable)new ErrorReport("", map), false);
                            bf.append("Symbol file error: ", 1).append(msg, 2, null, rgb_error).append('\n');
                        }
                    }
                    if (sym_data.error != null) {
                        bf.append("Symbol file error: ", 1).append(TCFModel.getErrorMessage(sym_data.error, false), 2, null, rgb_error).append('\n');
                    }
                }
            }
            if ((section = r.getSectionName()) != null) {
                bf.append("File section: ", 1).append(section).append('\n');
            } else {
                bf.append("File offset: ", 1).append(this.toHexString(r.getOffset()), 4).append('\n');
            }
        }
        bf.append("Address: ", 1).append(this.toHexString(r.getAddress()), 4).append('\n');
        bf.append("Size: ", 1).append(this.toHexString(r.getSize()), 4).append('\n');
        bf.append("Flags: ", 1).append(this.getFlagsLabel(r.getFlags())).append('\n');
        return true;
    }

    private String toHexString(Number address) {
        if (address == null) {
            return "";
        }
        BigInteger addr = JSON.toBigInteger((Number)address);
        String s = addr.toString(16);
        int sz = s.length() <= 8 ? 8 : 16;
        int l = sz - s.length();
        if (l < 0) {
            l = 0;
        }
        if (l > 16) {
            l = 16;
        }
        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
    }

    private String getFlagsLabel(int flags) {
        StringBuilder flagsLabel = new StringBuilder(3);
        if ((flags & 1) != 0) {
            flagsLabel.append('r');
        } else {
            flagsLabel.append('-');
        }
        if ((flags & 2) != 0) {
            flagsLabel.append('w');
        } else {
            flagsLabel.append('-');
        }
        if ((flags & 4) != 0) {
            flagsLabel.append('x');
        } else {
            flagsLabel.append('-');
        }
        return flagsLabel.toString();
    }
}

