/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.trace;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.core.AbstractChannel;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class TraceView
extends ViewPart
implements Protocol.ChannelOpenListener {
    private Composite parent;
    private CTabFolder tabs;
    private Label no_data;
    private final Map<CTabItem, Page> tab2page = new HashMap<CTabItem, Page>();
    private final ILaunchManager launch_manager = DebugPlugin.getDefault().getLaunchManager();
    private final ILaunchConfigurationListener launch_conf_listener = new ILaunchConfigurationListener(){

        public void launchConfigurationAdded(ILaunchConfiguration cfg) {
            cfg = TraceView.this.launch_manager.getMovedFrom(cfg);
            if (cfg != null) {
                this.launchConfigurationChanged(cfg);
            }
        }

        public void launchConfigurationChanged(ILaunchConfiguration cfg) {
            HashSet<IChannel> set = new HashSet<IChannel>();
            ILaunch[] iLaunchArray = TraceView.this.launch_manager.getLaunches();
            int n = iLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (launch instanceof TCFLaunch && cfg.equals(launch.getLaunchConfiguration())) {
                    set.add(((TCFLaunch)launch).getChannel());
                }
                ++n2;
            }
            for (final IChannel channel : set) {
                TraceView.this.parent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        for (final Page p : TraceView.this.tab2page.values()) {
                            if (p.channel != channel) continue;
                            p.tab.setToolTipText((String)new TCFTask<String>((IChannel)p.channel){

                                public void run() {
                                    this.done(TraceView.this.getPageToolTipText((IChannel)p.channel));
                                }
                            }.getE());
                        }
                    }
                });
            }
        }

        public void launchConfigurationRemoved(ILaunchConfiguration cfg) {
        }
    };

    public void createPartControl(Composite parent) {
        this.parent = parent;
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                IChannel[] arr;
                IChannel[] iChannelArray = arr = Protocol.getOpenChannels();
                int n = arr.length;
                int n2 = 0;
                while (n2 < n) {
                    IChannel c = iChannelArray[n2];
                    TraceView.this.onChannelOpen(c);
                    ++n2;
                }
                Protocol.addChannelOpenListener((Protocol.ChannelOpenListener)TraceView.this);
            }
        });
        if (this.tab2page.size() == 0) {
            this.hideTabs();
        }
        this.launch_manager.addLaunchConfigurationListener(this.launch_conf_listener);
    }

    public void setFocus() {
        if (this.tabs != null) {
            this.tabs.setFocus();
        }
    }

    public void dispose() {
        this.launch_manager.removeLaunchConfigurationListener(this.launch_conf_listener);
        Page[] pages = this.tab2page.values().toArray(new Page[this.tab2page.size()]);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                Protocol.removeChannelOpenListener((Protocol.ChannelOpenListener)TraceView.this);
            }
        });
        Page[] pageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            Page p = pageArray[n2];
            p.dispose();
            ++n2;
        }
        assert (this.tab2page.isEmpty());
        if (this.tabs != null) {
            this.tabs.dispose();
            this.tabs = null;
        }
        if (this.no_data != null) {
            this.no_data.dispose();
            this.no_data = null;
        }
        super.dispose();
    }

    private String getPageTitle(IChannel c) {
        IPeer rp = c.getRemotePeer();
        String title = rp.getName();
        String host = (String)rp.getAttributes().get("Host");
        String port = (String)rp.getAttributes().get("Port");
        if (host != null) {
            title = String.valueOf(title) + ", " + host;
            if (port != null) {
                title = String.valueOf(title) + ":" + port;
            }
        }
        return title;
    }

    private String getPageToolTipText(IChannel c) {
        StringBuffer bf = new StringBuffer();
        ILaunch[] iLaunchArray = this.launch_manager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof TCFLaunch && ((TCFLaunch)launch).getChannel() == c) {
                if (bf.length() > 0) {
                    bf.append('\n');
                }
                bf.append("Launch configuration: ");
                bf.append(launch.getLaunchConfiguration().getName());
            }
            ++n2;
        }
        IPeer rp = c.getRemotePeer();
        String host = (String)rp.getAttributes().get("Host");
        if (host != null) {
            if (bf.length() > 0) {
                bf.append('\n');
            }
            bf.append("Agent address: ");
            bf.append(host);
            String port = (String)rp.getAttributes().get("Port");
            if (port != null) {
                bf.append(':');
                bf.append(port);
            }
        }
        if (bf.length() > 0) {
            bf.append('\n');
        }
        bf.append("Agent name: ");
        bf.append(rp.getName());
        String user_name = (String)rp.getAttributes().get("UserName");
        if (user_name != null) {
            bf.append('\n');
            bf.append("Agent user: ");
            bf.append(user_name);
        }
        return bf.toString();
    }

    public void onChannelOpen(IChannel channel) {
        if (!(channel instanceof AbstractChannel)) {
            return;
        }
        AbstractChannel c = (AbstractChannel)channel;
        final Page p = new Page(c);
        c.addTraceListener((AbstractChannel.TraceListener)p);
        final String title = this.getPageTitle((IChannel)c);
        final String tool_tip = this.getPageToolTipText((IChannel)c);
        this.parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                TraceView.this.showTabs();
                p.tab = new CTabItem(TraceView.this.tabs, 0);
                TraceView.this.tab2page.put(p.tab, p);
                p.tab.setText(title);
                p.tab.setToolTipText(tool_tip);
                p.text = new Text((Composite)TraceView.this.tabs, 778);
                p.text.setBackground(TraceView.this.parent.getDisplay().getSystemColor(1));
                p.text.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                        if (p.key_pressed > 0) {
                            Page page = p;
                            page.key_pressed = page.key_pressed - 1;
                        }
                        if (e.character == '\u001b') {
                            p.key_pressed = 0;
                        }
                        p.updateScrollLock();
                    }

                    public void keyPressed(KeyEvent e) {
                        Page page = p;
                        page.key_pressed = page.key_pressed + 1;
                        p.updateScrollLock();
                        if (e.character == '\u001b') {
                            p.text.clearSelection();
                        }
                    }
                });
                p.text.addMouseListener(new MouseListener(){

                    public void mouseUp(MouseEvent e) {
                        Page page = p;
                        page.mouse_button_pressed = page.mouse_button_pressed - 1;
                        p.updateScrollLock();
                    }

                    public void mouseDown(MouseEvent e) {
                        Page page = p;
                        page.mouse_button_pressed = page.mouse_button_pressed + 1;
                        p.updateScrollLock();
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                    }
                });
                p.tab.setControl((Control)p.text);
                if (TraceView.this.tabs.getSelection() == null) {
                    TraceView.this.tabs.setSelection(p.tab);
                }
            }
        });
    }

    private void appendTime(StringBuffer bf) {
        String s = Long.toString(System.currentTimeMillis());
        int l = s.length();
        if (l < 6) {
            return;
        }
        bf.append(s.charAt(l - 6));
        bf.append(s.charAt(l - 5));
        bf.append(s.charAt(l - 4));
        bf.append('.');
        bf.append(s.charAt(l - 3));
        bf.append(s.charAt(l - 2));
        bf.append(s.charAt(l - 1));
        bf.append(' ');
    }

    /*
     * Unable to fully structure code
     */
    private void appendData(StringBuffer bf, byte[] data) throws UnsupportedEncodingException {
        block4: {
            pos = bf.length();
            try {
                o = JSON.parseSequence((byte[])data);
                i = 0;
                while (i < o.length) {
                    bf.append(' ');
                    this.appendJSON(bf, o[i]);
                    ++i;
                }
                break block4;
            }
            catch (Throwable v0) {
                bf.setLength(pos);
                i = 0;
                ** while (i < data.length)
            }
lbl-1000:
            // 1 sources

            {
                bf.append(' ');
                x = data[i] >> 4 & 15;
                y = data[i] & 15;
                bf.append((char)(x < 10 ? 48 + x : 97 + x - 10));
                bf.append((char)(y < 10 ? 48 + y : 97 + y - 10));
                ++i;
                continue;
            }
        }
    }

    private void appendJSON(StringBuffer bf, Object o) {
        if (o instanceof byte[]) {
            int l = ((byte[])o).length;
            bf.append('(');
            bf.append(l);
            bf.append(')');
        } else if (o instanceof Collection) {
            int cnt = 0;
            bf.append('[');
            for (Object i : (Collection)o) {
                if (cnt > 0) {
                    bf.append(',');
                }
                this.appendJSON(bf, i);
                ++cnt;
            }
            bf.append(']');
        } else if (o instanceof Map) {
            int cnt = 0;
            bf.append('{');
            for (Object k : ((Map)o).keySet()) {
                if (cnt > 0) {
                    bf.append(',');
                }
                bf.append(k.toString());
                bf.append(':');
                this.appendJSON(bf, ((Map)o).get(k));
                ++cnt;
            }
            bf.append('}');
        } else if (o instanceof String) {
            bf.append('\"');
            String s = (String)o;
            int l = s.length();
            int i = 0;
            while (i < l) {
                char ch = s.charAt(i);
                if (ch < ' ') {
                    bf.append('\\');
                    bf.append('u');
                    int j = 0;
                    while (j < 4) {
                        int x = ch >> 4 * (3 - j) & 0xF;
                        bf.append((char)(x < 10 ? 48 + x : 97 + x - 10));
                        ++j;
                    }
                } else {
                    bf.append(ch);
                }
                ++i;
            }
            bf.append('\"');
        } else {
            bf.append(o);
        }
    }

    private void showTabs() {
        boolean b = false;
        if (this.no_data != null) {
            this.no_data.dispose();
            this.no_data = null;
            b = true;
        }
        if (this.tabs == null) {
            this.tabs = new CTabFolder(this.parent, 0x800040);
            ColorRegistry reg = JFaceResources.getColorRegistry();
            Color c1 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
            Color c2 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
            this.tabs.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
            this.tabs.setSelectionForeground(reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
            this.tabs.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
            this.tabs.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                public void close(CTabFolderEvent event) {
                    CTabItem s = (CTabItem)event.item;
                    Page p = (Page)TraceView.this.tab2page.get(s);
                    if (p != null) {
                        p.dispose();
                    } else {
                        s.dispose();
                    }
                    event.doit = false;
                }
            });
            Menu menu = new Menu((Control)this.tabs);
            MenuItem mi_close = new MenuItem(menu, 0);
            mi_close.setText("Close");
            mi_close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (TraceView.this.tabs == null) {
                        return;
                    }
                    CTabItem s = TraceView.this.tabs.getSelection();
                    Page p = (Page)TraceView.this.tab2page.get(s);
                    if (p != null) {
                        p.dispose();
                    } else {
                        s.dispose();
                    }
                }
            });
            MenuItem mi_close_all = new MenuItem(menu, 0);
            mi_close_all.setText("Close All");
            mi_close_all.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    CTabItem[] s;
                    if (TraceView.this.tabs == null) {
                        return;
                    }
                    CTabItem[] cTabItemArray = s = TraceView.this.tabs.getItems();
                    int n = s.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CTabItem i = cTabItemArray[n2];
                        Page p = (Page)TraceView.this.tab2page.get(i);
                        if (p != null) {
                            p.dispose();
                        } else {
                            i.dispose();
                        }
                        ++n2;
                    }
                }
            });
            this.tabs.setMenu(menu);
            b = true;
        }
        if (b) {
            this.parent.layout();
        }
    }

    private void hideTabs() {
        boolean b = false;
        if (this.tabs != null) {
            this.tabs.dispose();
            this.tabs = null;
            b = true;
        }
        if (!this.parent.isDisposed()) {
            if (this.no_data == null) {
                this.no_data = new Label(this.parent, 0);
                this.no_data.setText("No open communication channels at this time.");
                b = true;
            }
            if (b) {
                this.parent.layout();
            }
        }
    }

    private class Page
    implements AbstractChannel.TraceListener {
        final AbstractChannel channel;
        private CTabItem tab;
        private Text text;
        private final StringBuffer bf = new StringBuffer();
        private int bf_line_cnt = 0;
        private boolean closed;
        private boolean scroll_locked;
        private int key_pressed;
        private int mouse_button_pressed;
        private final Thread update_thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Page page = Page.this;
                synchronized (page) {
                    while (!Page.this.closed) {
                        if (!(Page.this.bf_line_cnt <= 0 || Page.this.scroll_locked && Page.this.bf_line_cnt < 5000)) {
                            Runnable r = new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    String str = null;
                                    int cnt = 0;
                                    Page page = Page.this;
                                    synchronized (page) {
                                        str = Page.this.bf.toString();
                                        cnt = Page.this.bf_line_cnt;
                                        Page.this.bf.setLength(0);
                                        Page.this.bf_line_cnt = 0;
                                    }
                                    if (Page.this.text == null) {
                                        return;
                                    }
                                    if (Page.this.text.getLineCount() > 1000 - cnt) {
                                        String s = Page.this.text.getText();
                                        int n = 0;
                                        int i = -1;
                                        while (n < cnt) {
                                            int j = s.indexOf(10, i + 1);
                                            if (j < 0) break;
                                            i = j;
                                            ++n;
                                        }
                                        if (i >= 0) {
                                            Page.this.text.setText(s.substring(i + 1));
                                        }
                                    }
                                    Page.this.text.append(str);
                                }
                            };
                            TraceView.this.parent.getDisplay().asyncExec(r);
                        }
                        try {
                            Page.this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                }
            }
        };

        Page(AbstractChannel channel) {
            this.channel = channel;
            this.update_thread.setName("TCF Trace View");
            this.update_thread.start();
        }

        private void updateScrollLock() {
            this.scroll_locked = this.text == null ? false : this.key_pressed > 0 || this.mouse_button_pressed > 0 || this.text.getSelectionCount() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            if (this.closed) {
                return;
            }
            Protocol.invokeAndWait((Runnable)new Runnable(){

                public void run() {
                    Page.this.channel.removeTraceListener((AbstractChannel.TraceListener)Page.this);
                }
            });
            Page page = this;
            synchronized (page) {
                this.closed = true;
                this.update_thread.interrupt();
            }
            try {
                this.update_thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.tab != null) {
                TraceView.this.tab2page.remove(this.tab);
                this.tab.dispose();
                this.tab = null;
            }
            this.text = null;
            if (TraceView.this.tab2page.isEmpty()) {
                TraceView.this.hideTabs();
            }
        }

        public synchronized void onChannelClosed(Throwable error) {
            if (error == null) {
                TraceView.this.parent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Page.this.dispose();
                    }
                });
            } else {
                this.bf.append("Channel terminated: " + error);
                ++this.bf_line_cnt;
            }
        }

        public synchronized void onMessageReceived(char type, String token, String service, String name, byte[] data) {
            try {
                if ("Locator".equals(service) && "peerHeartBeat".equals(name)) {
                    return;
                }
                TraceView.this.appendTime(this.bf);
                this.bf.append("Inp: ");
                this.bf.append(type);
                if (token != null) {
                    this.bf.append(' ');
                    this.bf.append(token);
                }
                if (service != null) {
                    this.bf.append(' ');
                    this.bf.append(service);
                }
                if (name != null) {
                    this.bf.append(' ');
                    this.bf.append(name);
                }
                if (data != null) {
                    TraceView.this.appendData(this.bf, data);
                }
                this.bf.append('\n');
                ++this.bf_line_cnt;
            }
            catch (UnsupportedEncodingException x) {
                x.printStackTrace();
            }
        }

        public synchronized void onMessageSent(char type, String token, String service, String name, byte[] data) {
            try {
                if ("Locator".equals(service) && "peerHeartBeat".equals(name)) {
                    return;
                }
                TraceView.this.appendTime(this.bf);
                this.bf.append("Out: ");
                this.bf.append(type);
                if (token != null) {
                    this.bf.append(' ');
                    this.bf.append(token);
                }
                if (service != null) {
                    this.bf.append(' ');
                    this.bf.append(service);
                }
                if (name != null) {
                    this.bf.append(' ');
                    this.bf.append(name);
                }
                if (data != null) {
                    TraceView.this.appendData(this.bf, data);
                }
                this.bf.append('\n');
                ++this.bf_line_cnt;
            }
            catch (UnsupportedEncodingException x) {
                x.printStackTrace();
            }
        }
    }
}

