/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IEventQueue;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;

public class Main {
    private static IPeer getPeer(String[] arr) {
        ArrayList<Map<String, String>> l = new ArrayList<Map<String, String>>();
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            HashMap<String, String> map = new HashMap<String, String>();
            int len = s.length();
            int i = 0;
            while (i < len) {
                int i0 = i;
                while (i < len && s.charAt(i) != '=' && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int i1 = i;
                if (i >= len || s.charAt(i) == '=') {
                    // empty if block
                }
                int i2 = ++i;
                while (i < len && s.charAt(i) != ':') {
                    ++i;
                }
                int i3 = i;
                if (i < len && s.charAt(i) == ':') {
                    ++i;
                }
                String key = s.substring(i0, i1);
                String val = s.substring(i2, i3);
                map.put(key, val);
            }
            l.add(map);
            ++n2;
        }
        return new RemotePeer(l);
    }

    private static void runTestSuite(IPeer peer) {
        TCFTestSuite.TestListener listener = new TCFTestSuite.TestListener(){

            @Override
            public void done(Collection<Throwable> errors) {
                if (errors == null || errors.isEmpty()) {
                    System.out.println("No errors detected.");
                    System.exit(0);
                }
                for (Throwable x : errors) {
                    x.printStackTrace(System.out);
                }
                System.exit(3);
            }

            @Override
            public void progress(String label, int done, int total) {
                if (label != null) {
                    System.out.println(label);
                }
            }
        };
        try {
            new TCFTestSuite(peer, listener, null, null);
        }
        catch (Throwable x) {
            System.err.println("Cannot start test suite:");
            x.printStackTrace();
            System.exit(2);
        }
    }

    public static void main(final String[] args) {
        if (args.length < 1) {
            System.err.println("Missing command line argument - peer identification string");
            System.exit(4);
        }
        Protocol.setEventQueue((IEventQueue)new EventQueue());
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                Main.runTestSuite(Main.getPeer(args));
            }
        });
        Protocol.invokeLater((long)600000L, (Runnable)new Runnable(){

            public void run() {
                System.err.println("Error: timeout - test's not finished in 10 min");
                System.exit(5);
            }
        });
    }

    private static class EventQueue
    extends Thread
    implements IEventQueue {
        private final LinkedList<Runnable> queue = new LinkedList();

        EventQueue() {
            this.setName("TCF Event Dispatcher");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    Runnable r = null;
                    EventQueue eventQueue = this;
                    synchronized (eventQueue) {
                        while (this.queue.size() == 0) {
                            this.wait();
                        }
                        r = this.queue.removeFirst();
                    }
                    r.run();
                }
            }
            catch (Throwable x) {
                x.printStackTrace();
                System.exit(1);
                return;
            }
        }

        public synchronized int getCongestion() {
            int n = this.queue.size() - 100;
            if (n > 100) {
                n = 100;
            }
            return n;
        }

        public synchronized void invokeLater(Runnable runnable) {
            this.queue.add(runnable);
            this.notify();
        }

        public boolean isDispatchThread() {
            return Thread.currentThread() == this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemotePeer
    extends TransientPeer {
        private final ArrayList<Map<String, String>> attrs;

        public RemotePeer(ArrayList<Map<String, String>> attrs) {
            super(attrs.get(0));
            this.attrs = attrs;
        }

        public IChannel openChannel() {
            assert (Protocol.isDispatchThread());
            IChannel c = super.openChannel();
            int i = 1;
            while (i < this.attrs.size()) {
                c.redirect(this.attrs.get(i));
                ++i;
            }
            return c;
        }
    }
}

