/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.lm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchMode;

public class LaunchConfigHelper {
    public static String getUniqueLaunchConfigName(String name) {
        return DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(name);
    }

    public static String[] getLaunchConfigTypeModes(ILaunchConfigurationType launchConfigType, boolean reverse) {
        return LaunchConfigHelper.getLaunchConfigTypeModes(new ILaunchConfigurationType[]{launchConfigType}, reverse);
    }

    public static String[] getLaunchConfigTypeModes(ILaunchConfigurationType[] launchConfigTypes, boolean reverse) {
        ArrayList<String> modes = new ArrayList<String>();
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = launchConfigTypes;
        int n = launchConfigTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationType launchConfigType = iLaunchConfigurationTypeArray[n2];
            for (Object modeCombination : launchConfigType.getSupportedModeCombinations()) {
                String mode;
                if (((Set)modeCombination).size() != 1 || modes.contains(mode = (String)((Set)modeCombination).toArray()[0])) continue;
                modes.add(mode);
            }
            ++n2;
        }
        return LaunchConfigHelper.getLaunchModesSorted(modes.toArray(new String[modes.size()]), reverse);
    }

    public static String[] getLaunchModesSorted(ILaunchMode[] launchModes, boolean reverse) {
        Assert.isNotNull((Object)launchModes);
        String[] modes = new String[launchModes.length];
        int i = 0;
        while (i < launchModes.length) {
            modes[i] = launchModes[i].getIdentifier();
            ++i;
        }
        return LaunchConfigHelper.getLaunchModesSorted(modes, reverse);
    }

    public static String[] getLaunchModesSorted(String[] launchModes, final boolean reverse) {
        Assert.isNotNull((Object)launchModes);
        Arrays.sort(launchModes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.equals("run") && !o2.equals("run")) {
                    return reverse ? 1 : -1;
                }
                if (o2.equals("run") && !o1.equals("run")) {
                    return reverse ? -1 : 1;
                }
                if (o1.equals("debug") && !o2.equals("debug")) {
                    return reverse ? 1 : -1;
                }
                if (o2.equals("debug") && !o1.equals("debug")) {
                    return reverse ? -1 : 1;
                }
                return reverse ? o2.compareTo(o1) : o1.compareTo(o2);
            }
        });
        return launchModes;
    }
}

