/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.lm.delegates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.tcf.te.launch.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.launch.core.bindings.LaunchConfigTypeBindingsManager;
import org.eclipse.tcf.te.launch.core.exceptions.LaunchServiceException;
import org.eclipse.tcf.te.launch.core.interfaces.IReferencedProjectItem;
import org.eclipse.tcf.te.launch.core.lm.LaunchConfigSorter;
import org.eclipse.tcf.te.launch.core.lm.LaunchSpecification;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchAttribute;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchSpecification;
import org.eclipse.tcf.te.launch.core.nls.Messages;
import org.eclipse.tcf.te.launch.core.persistence.DefaultPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.filetransfer.FileTransfersPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.projects.ReferencedProjectsPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ILaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtension;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;

public class DefaultLaunchManagerDelegate
extends ExecutableExtension
implements ILaunchManagerDelegate {
    @Override
    public void initLaunchConfigAttributes(ILaunchConfigurationWorkingCopy wc, ILaunchSpecification launchSpec) {
        Assert.isNotNull((Object)wc);
        Assert.isNotNull((Object)launchSpec);
        if (!DefaultPersistenceDelegate.hasAttribute((ILaunchConfiguration)wc, "org.eclipse.tcf.te.launch.UUID")) {
            DefaultPersistenceDelegate.setAttribute(wc, "org.eclipse.tcf.te.launch.UUID", UUID.randomUUID().toString());
        }
        this.validateLaunchSpecification(launchSpec);
    }

    @Override
    public void updateLaunchConfigAttributes(ILaunchConfigurationWorkingCopy wc, ILaunchSpecification launchSpec) {
        Assert.isNotNull((Object)wc);
        Assert.isNotNull((Object)launchSpec);
        if (!DefaultPersistenceDelegate.hasAttribute((ILaunchConfiguration)wc, "org.eclipse.tcf.te.launch.UUID")) {
            DefaultPersistenceDelegate.setAttribute(wc, "org.eclipse.tcf.te.launch.UUID", UUID.randomUUID().toString());
        }
        this.validateLaunchSpecification(launchSpec);
    }

    @Override
    public void updateLaunchConfig(ILaunchConfigurationWorkingCopy wc, ISelectionContext selContext, boolean replace) {
        Assert.isNotNull((Object)wc);
        Assert.isNotNull((Object)selContext);
    }

    @Override
    public boolean isDefaultAttribute(String attributeKey, Object specValue, Object confValue, ILaunchSpecification launchSpec, ILaunchConfiguration launchConfig, String launchMode) {
        Assert.isNotNull((Object)attributeKey);
        Assert.isNotNull((Object)launchConfig);
        Assert.isNotNull((Object)launchSpec);
        Assert.isNotNull((Object)launchMode);
        return confValue == null && specValue != null;
    }

    @Override
    public final ILaunchConfiguration[] getMatchingLaunchConfigurations(ILaunchSpecification launchSpec, ILaunchConfiguration[] launchConfigs) throws LaunchServiceException {
        if (launchConfigs == null || launchConfigs.length == 0) {
            return new ILaunchConfiguration[0];
        }
        if (launchSpec != null) {
            ArrayList<LaunchConfigSorter> rankedList = new ArrayList<LaunchConfigSorter>();
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigs;
            int n = launchConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n2];
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/launchConfigurationMatching")) {
                    System.out.println("\n***\n");
                }
                int ranking = 0;
                try {
                    ranking = this.getLaunchConfigRanking(launchSpec, launchConfig);
                }
                catch (LaunchServiceException e) {
                    switch (e.getType()) {
                        case 1: {
                            ranking = 0;
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                }
                int fullMatchRanking = this.getFullMatchRanking();
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/launchConfigurationMatching")) {
                    StringBuilder message = new StringBuilder("Ranking launch spec (");
                    message.append(launchSpec.getLaunchConfigName());
                    message.append(") vs launch configuration (");
                    message.append(launchConfig.getName());
                    message.append(") = ");
                    message.append(ranking);
                    message.append(" ; full match ranking = ");
                    message.append(fullMatchRanking);
                    CoreBundleActivator.getTraceHandler().trace(message.toString(), 0, "trace/launchConfigurationMatching", 1, (Object)this);
                }
                if (ranking >= fullMatchRanking) {
                    rankedList.add(new LaunchConfigSorter(launchConfig, ranking));
                }
                ++n2;
            }
            Collections.sort(rankedList);
            ILaunchConfiguration[] matchingConfigs = new ILaunchConfiguration[rankedList.size()];
            int i = 0;
            while (i < rankedList.size()) {
                matchingConfigs[i] = ((LaunchConfigSorter)rankedList.get(i)).getConfig();
                ++i;
            }
            return matchingConfigs;
        }
        return launchConfigs;
    }

    @Override
    public final ILaunchSpecification getLaunchSpecification(String launchConfigTypeId, ILaunchSelection launchSelection) {
        ILaunchSpecification spec = null;
        if (this.isValidLaunchSelection(launchSelection)) {
            spec = new LaunchSpecification(launchConfigTypeId, launchSelection.getLaunchMode());
            ISelectionContext[] iSelectionContextArray = launchSelection.getSelectedContexts();
            int n = iSelectionContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionContext selectionContext = iSelectionContextArray[n2];
                boolean oldPref = selectionContext.isPreferredContext();
                selectionContext.setIsPreferredContext(true);
                if (LaunchConfigTypeBindingsManager.getInstance().isValidLaunchConfigType(launchConfigTypeId, launchSelection.getLaunchMode(), selectionContext)) {
                    spec = this.addLaunchSpecAttributes(spec, launchConfigTypeId, selectionContext);
                }
                selectionContext.setIsPreferredContext(oldPref);
                ++n2;
            }
            if (launchSelection.getSelectedContexts().length == 0) {
                spec = this.addLaunchSpecAttributes(spec, launchConfigTypeId, null);
            }
        }
        return spec;
    }

    @Override
    public String getDefaultLaunchName(ILaunchSpecification launchSpec) {
        return Messages.DefaultLaunchManagerDelegate_defaultLaunchName;
    }

    @Override
    public String getDefaultLaunchName(ILaunchConfiguration launchConfig) {
        return Messages.DefaultLaunchManagerDelegate_defaultLaunchName;
    }

    protected ILaunchSpecification addLaunchSpecAttributes(ILaunchSpecification launchSpec, String launchConfigTypeId, ISelectionContext selectionContext) {
        Assert.isNotNull((Object)launchSpec);
        Assert.isNotNull((Object)launchConfigTypeId);
        return launchSpec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getLaunchConfigRanking(ILaunchSpecification launchSpec, ILaunchConfiguration launchConfig) throws LaunchServiceException {
        int ranking = 0;
        int mandatorys = 0;
        Map configAttributes = null;
        Set configKeys = null;
        try {
            configAttributes = launchConfig.getAttributes();
            configKeys = configAttributes.keySet();
        }
        catch (Exception exception) {
            return 0;
        }
        int mode = CoreBundleActivator.getScopedPreferences().getInt("te.launch.core.launchConfigFindCreateMode");
        if (launchSpec.getAttribute("te.launch.core.launchConfigFindCreateMode", null) instanceof Integer) {
            mode = (Integer)launchSpec.getAttribute("te.launch.core.launchConfigFindCreateMode", null);
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/launchConfigurationMatching")) {
            StringBuilder message = new StringBuilder("Ranking launch spec (");
            message.append(launchSpec.getLaunchConfigName());
            message.append(") vs launch configuration (");
            message.append(launchConfig.getName());
            message.append("): Matching mode = ");
            if (mode == 0) {
                message.append(" ALWAYS_NEW ");
            } else if (mode == 3) {
                message.append(" FIRST_MATCHING ");
            } else if (mode == 2) {
                message.append(" FULL_MATCH_TARGET ");
            } else if (mode == 1) {
                message.append(" FULL_MATCH_LAUNCH_CONFIG ");
            }
            CoreBundleActivator.getTraceHandler().trace(message.toString(), 0, "trace/launchConfigurationMatching", 1, (Object)this);
        }
        ILaunchAttribute[] iLaunchAttributeArray = launchSpec.getAllAttributes();
        int n = iLaunchAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchAttribute specAttribute = iLaunchAttributeArray[n2];
            if (!specAttribute.isCreateOnlyAttribute()) {
                int attrRanking;
                String key = specAttribute.getKey();
                Object specValue = specAttribute.getValue();
                Object configValue = configAttributes.get(key);
                int match = this.compareAttributeValues(key, specValue, configValue, launchSpec, launchConfig);
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/launchConfigurationMatching")) {
                    StringBuilder message = new StringBuilder("Launch spec attribute '");
                    message.append(specAttribute.getKey());
                    message.append("': mandatory = ");
                    message.append(this.isMandatoryAttribute(key));
                    message.append("; match = ");
                    if (match == 0) {
                        message.append("NO_MATCH");
                    } else if (match == 1) {
                        message.append("PARTIAL_MATCH");
                    } else if (match == 2) {
                        message.append("FULL_MATCH");
                    }
                    if (match != 2) {
                        message.append("\n\t\tspecValue = ");
                        message.append(specValue != null ? specValue.toString() : "null");
                        message.append("\n\t\tconfigValue = ");
                        message.append(configValue != null ? configValue.toString() : "null");
                    }
                    CoreBundleActivator.getTraceHandler().trace(message.toString(), 0, "trace/launchConfigurationMatching", 1, (Object)this);
                }
                if (match == 1 && mode == 1) {
                    return 0;
                }
                if (match <= 0) return 0;
                ranking += attrRanking * ((attrRanking = this.getAttributeRanking(key)) > 1 ? 4 : 1);
                if (match == 2) {
                    ranking += attrRanking * (attrRanking > 1 ? 2 : 1);
                }
                configKeys.remove(key);
                if (this.isMandatoryAttribute(key)) {
                    ++mandatorys;
                }
            } else if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/launchConfigurationMatching")) {
                StringBuilder message = new StringBuilder("Skipped launch spec attribute '");
                message.append(specAttribute.getKey());
                message.append("': is create only attribute");
                CoreBundleActivator.getTraceHandler().trace(message.toString(), 0, "trace/launchConfigurationMatching", 1, (Object)this);
            }
            ++n2;
        }
        if (mandatorys < this.getNumMandatoryAttributes()) {
            throw new LaunchServiceException("missing mandatory attribute in ILaunchSpecification", 2);
        }
        for (String key : configKeys) {
            int attrRanking;
            Object configValue;
            Object specValue;
            int match = this.compareAttributeValues(key, specValue = launchSpec.getAttribute(key, null), configValue = configAttributes.get(key), launchSpec, launchConfig);
            if (match <= 0) continue;
            ranking += attrRanking * ((attrRanking = this.getAttributeRanking(key)) > 1 ? 4 : 1);
            if (match != 2) continue;
            ranking += attrRanking * (attrRanking > 1 ? 2 : 1);
        }
        return ranking;
    }

    protected int getNumAttributes() {
        return 0;
    }

    protected List<String> getMandatoryAttributes() {
        return Collections.emptyList();
    }

    private boolean validateLaunchSpecification(ILaunchSpecification launchSpec) {
        boolean valid = true;
        if (launchSpec == null || !launchSpec.isValid()) {
            return false;
        }
        for (String attribute : this.getMandatoryAttributes()) {
            if (launchSpec.hasAttribute(attribute)) continue;
            valid = false;
            break;
        }
        launchSpec.setIsValid(valid);
        return valid;
    }

    protected boolean isValidLaunchSelection(ILaunchSelection launchSelection) {
        return true;
    }

    @Override
    public void validate(String launchMode, ILaunchConfiguration launchConfig) throws LaunchServiceException {
        String missingAttributes = null;
        for (String attribute : this.getMandatoryAttributes()) {
            if (this.isValidAttribute(attribute, launchConfig, launchMode)) continue;
            String string = missingAttributes = missingAttributes == null ? attribute : String.valueOf(missingAttributes) + ", " + attribute;
        }
        if (missingAttributes != null) {
            throw new LaunchServiceException("Missing launch configuration attributes: \n" + missingAttributes, 1);
        }
    }

    protected boolean isValidAttribute(String attributeKey, ILaunchConfiguration launchConfig, String launchMode) {
        try {
            return launchConfig != null && launchConfig.hasAttribute(attributeKey);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public void validate(ILaunchSpecification launchSpec) throws LaunchServiceException {
        String missingAttributes = null;
        for (String attribute : this.getMandatoryAttributes()) {
            if (launchSpec != null && launchSpec.hasAttribute(attribute)) continue;
            String string = missingAttributes = missingAttributes == null ? attribute : String.valueOf(missingAttributes) + ", " + attribute;
        }
        if (missingAttributes != null) {
            throw new LaunchServiceException("Missing launch specification attributes: \n" + missingAttributes, 2);
        }
    }

    protected final int getNumMandatoryAttributes() {
        return this.getMandatoryAttributes().size();
    }

    protected final boolean isMandatoryAttribute(String attributeKey) {
        return this.getMandatoryAttributes().contains(attributeKey);
    }

    protected int getAttributeRanking(String attributeKey) {
        return 1;
    }

    protected int getFullMatchRanking() {
        return 1;
    }

    protected int compareAttributeValues(String attributeKey, Object specValue, Object confValue, ILaunchSpecification launchSpec, ILaunchConfiguration launchConfig) {
        Assert.isNotNull((Object)attributeKey);
        Assert.isNotNull((Object)launchSpec);
        Assert.isNotNull((Object)launchConfig);
        if (specValue == null && confValue == null) {
            return 2;
        }
        if (specValue == null || confValue == null) {
            return this.isDefaultAttribute(attributeKey, specValue, confValue, launchSpec, launchConfig, launchSpec.getLaunchMode()) ? 1 : 0;
        }
        if (this.isDefaultAttribute(attributeKey, specValue, confValue, launchSpec, launchConfig, launchSpec.getLaunchMode())) {
            return 2;
        }
        Assert.isNotNull((Object)specValue);
        Assert.isNotNull((Object)confValue);
        return this.equals(attributeKey, specValue, confValue, launchSpec, launchConfig, launchSpec.getLaunchMode());
    }

    protected int equals(String attributeKey, Object specValue, Object confValue, ILaunchSpecification launchSpec, ILaunchConfiguration launchConfig, String launchMode) {
        Assert.isNotNull((Object)specValue);
        Assert.isNotNull((Object)confValue);
        if ("org.eclipse.tcf.te.launch.launch_contexts".equals(attributeKey)) {
            int match;
            int n = match = specValue.equals(confValue) ? 2 : 0;
            if (match != 2) {
                List<IModelNode> confItems = Arrays.asList(LaunchContextsPersistenceDelegate.decodeLaunchContexts(confValue.toString()));
                IModelNode[] specItems = LaunchContextsPersistenceDelegate.decodeLaunchContexts(specValue.toString());
                int i = 0;
                IModelNode[] iModelNodeArray = specItems;
                int n2 = specItems.length;
                int n3 = 0;
                while (n3 < n2) {
                    IModelNode item = iModelNodeArray[n3];
                    if (confItems.contains(item)) {
                        if (match == 0) {
                            match = i == 0 ? 2 : 1;
                        }
                    } else if (match == 2) {
                        match = 1;
                    }
                    ++i;
                    ++n3;
                }
                if (match == 2 && specItems.length != confItems.size()) {
                    match = 1;
                }
            }
            return match;
        }
        if ("org.eclipse.tcf.te.launch.file_transfers".equals(attributeKey)) {
            int match;
            int n = match = specValue.equals(confValue) ? 2 : 0;
            if (match != 2) {
                List<IFileTransferItem> confItems = Arrays.asList(FileTransfersPersistenceDelegate.decodeFileTransferItems(confValue.toString()));
                IFileTransferItem[] specItems = FileTransfersPersistenceDelegate.decodeFileTransferItems(specValue.toString());
                int i = 0;
                IFileTransferItem[] iFileTransferItemArray = specItems;
                int n4 = specItems.length;
                int n5 = 0;
                while (n5 < n4) {
                    IFileTransferItem item = iFileTransferItemArray[n5];
                    if (confItems.contains(item)) {
                        if (match == 0) {
                            match = i == 0 ? 2 : 1;
                        }
                    } else if (match == 2) {
                        match = 1;
                    }
                    ++i;
                    ++n5;
                }
                if (match == 2 && specItems.length != confItems.size()) {
                    match = 1;
                }
            }
            return match;
        }
        if ("org.eclipse.tcf.te.launch.referencedProjects".equals(attributeKey)) {
            int match;
            int n = match = specValue.equals(confValue) ? 2 : 0;
            if (match != 2) {
                List<IReferencedProjectItem> confItems = Arrays.asList(ReferencedProjectsPersistenceDelegate.decodeReferencedProjectItems(confValue.toString()));
                IReferencedProjectItem[] specItems = ReferencedProjectsPersistenceDelegate.decodeReferencedProjectItems(specValue.toString());
                int i = 0;
                IReferencedProjectItem[] iReferencedProjectItemArray = specItems;
                int n6 = specItems.length;
                int n7 = 0;
                while (n7 < n6) {
                    IReferencedProjectItem item = iReferencedProjectItemArray[n7];
                    if (confItems.contains(item)) {
                        if (match == 0) {
                            match = i == 0 ? 2 : 1;
                        }
                    } else if (match == 2) {
                        match = 1;
                    }
                    ++i;
                    ++n7;
                }
                if (match == 2 && specItems.length != confItems.size()) {
                    match = 1;
                }
            }
            return match;
        }
        return specValue.equals(confValue) ? 2 : 0;
    }

    @Override
    public boolean showLaunchDialog(int situation) {
        return true;
    }

    @Override
    public boolean equals(ISelectionContext ctx1, ISelectionContext ctx2) {
        return ctx1 == null && ctx2 == null || ctx1 != null && ctx1.equals(ctx2);
    }

    @Override
    public String getDescription(ILaunchConfiguration config) {
        return config.getName();
    }
}

