/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.core.interfaces.IViewerInput;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNodeProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class BaseTitledSection
extends AbstractPropertySection
implements PropertyChangeListener {
    protected Composite composite;
    protected IViewerInput viewerInput;
    protected IModelNodeProvider provider;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.viewerInput != null) {
            this.viewerInput.removePropertyChangeListener((PropertyChangeListener)this);
        }
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof IAdaptable) {
            this.viewerInput = (IViewerInput)((IAdaptable)input).getAdapter(IViewerInput.class);
            if (this.viewerInput != null) {
                this.viewerInput.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
        if (this.viewerInput == null && input instanceof IModelNodeProvider) {
            this.provider = (IModelNodeProvider)input;
            IModelNode modelNode = this.provider.getModelNode();
            this.viewerInput = (IViewerInput)modelNode.getAdapter(IViewerInput.class);
            if (this.viewerInput != null) {
                this.viewerInput.addPropertyChangeListener((PropertyChangeListener)this);
            }
        } else {
            this.provider = null;
            this.viewerInput = null;
        }
        this.updateInput(this.provider);
    }

    protected void updateInput(IModelNodeProvider input) {
    }

    public void aboutToBeHidden() {
        if (this.viewerInput != null) {
            this.viewerInput.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        parent.setLayout((Layout)new FormLayout());
        Section section = this.getWidgetFactory().createSection(parent, 256);
        section.setText(this.getText());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 6);
        data.right = new FormAttachment(100, -6);
        data.top = new FormAttachment(0, 12);
        section.setLayoutData((Object)data);
        this.composite = this.getWidgetFactory().createComposite(parent);
        FormLayout layout = new FormLayout();
        layout.spacing = 6;
        this.composite.setLayout((Layout)layout);
        data = new FormData();
        data.left = new FormAttachment(0, 12);
        data.right = new FormAttachment(100, -12);
        data.top = new FormAttachment((Control)section, 4);
        data.bottom = new FormAttachment(100, 0);
        this.composite.setLayoutData((Object)data);
    }

    protected void createLabel(Control control, String text) {
        CLabel nameLabel = this.getWidgetFactory().createCLabel(this.composite, text);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(control, -5);
        data.top = new FormAttachment(control, 0, 0x1000000);
        nameLabel.setLayoutData((Object)data);
    }

    protected Text createTextField(Control control, String label) {
        Text text = this.createText(control);
        this.createLabel((Control)text, label);
        return text;
    }

    protected Text createWrapTextField(Control control, String label) {
        Text text = this.createWrapText(control);
        this.createLabel((Control)text, label);
        return text;
    }

    private Text createText(Control control) {
        Text text = this.getWidgetFactory().createText(this.composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = control == null ? new FormAttachment(0, 4) : new FormAttachment(control, 4);
        text.setLayoutData((Object)data);
        text.setEditable(false);
        return text;
    }

    private Text createWrapText(Control control) {
        Text text = this.getWidgetFactory().createText(this.composite, "", 64);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = control == null ? new FormAttachment(0, 4) : new FormAttachment(control, 4);
        data.width = 200;
        text.setLayoutData((Object)data);
        text.setEditable(false);
        return text;
    }

    public void refresh() {
        if (this.composite != null) {
            this.composite.layout();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.provider) {
            this.updateInput(this.provider);
            Display display = this.getPart().getSite().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    BaseTitledSection.this.refresh();
                }
            });
        }
    }

    protected abstract String getText();
}

