/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtension;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistenceDelegate;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;

public abstract class AbstractGsonMapPersistenceDelegate
extends ExecutableExtension
implements IPersistenceDelegate {
    private final String defaultFileExtension;

    public AbstractGsonMapPersistenceDelegate() {
        this("json");
    }

    public AbstractGsonMapPersistenceDelegate(String defaultFileExtension) {
        Assert.isNotNull((Object)defaultFileExtension);
        this.defaultFileExtension = defaultFileExtension;
    }

    protected String getDefaultFileExtension() {
        return this.defaultFileExtension;
    }

    @Override
    public Object write(Object context, Object container, String key) throws IOException {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)container);
        if (container instanceof URI) {
            URI uri = (URI)container;
            if (!"file".equalsIgnoreCase(uri.getScheme())) {
                throw new IOException("Unsupported URI schema '" + uri.getScheme() + "'");
            }
            File file = new File(uri.normalize());
            if (!file.isAbsolute()) {
                throw new IOException("URI must denote an absolute file path.");
            }
            Path path = new Path(file.getCanonicalPath());
            if (path.getFileExtension() == null) {
                file = path.addFileExtension(this.getDefaultFileExtension()).toFile();
            }
            Writer writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson(this.toMap(context), Map.class, (Appendable)writer);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        } else if (container instanceof String || String.class.equals(container)) {
            Gson gson = new GsonBuilder().create();
            container = gson.toJson(this.toMap(context));
        }
        return container;
    }

    @Override
    public Object read(Object context, Object container, String key) throws IOException {
        Assert.isNotNull((Object)container);
        Gson gson = new GsonBuilder().create();
        Map data = null;
        if (container instanceof URI) {
            URI uri = (URI)container;
            if (!"file".equalsIgnoreCase(uri.getScheme())) {
                throw new IOException("Unsupported URI schema '" + uri.getScheme() + "'");
            }
            File file = new File(uri.normalize());
            if (!file.isAbsolute()) {
                throw new IOException("URI must denote an absolute file path.");
            }
            Reader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                data = (Map)gson.fromJson(reader, Map.class);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        } else if (container instanceof String) {
            data = (Map)gson.fromJson((String)container, Map.class);
        }
        return data != null ? this.fromMap(data, context) : context;
    }

    @Override
    public boolean delete(Object context, Object container, String key) throws IOException {
        Assert.isNotNull((Object)container);
        if (container instanceof URI) {
            URI uri = (URI)container;
            if (!"file".equalsIgnoreCase(uri.getScheme())) {
                throw new IOException("Unsupported URI schema '" + uri.getScheme() + "'");
            }
            File file = new File(uri.normalize());
            if (!file.isAbsolute()) {
                throw new IOException("URI must denote an absolute file path.");
            }
            Path path = new Path(file.getCanonicalPath());
            if (path.getFileExtension() == null) {
                file = path.addFileExtension(this.getDefaultFileExtension()).toFile();
            }
            return file.delete();
        }
        return false;
    }

    protected Map<String, Object> toMap(Object context) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap attrs = null;
        if (context instanceof Map) {
            attrs = (HashMap)context;
        } else if (context instanceof IPropertiesContainer) {
            IPropertiesContainer container = (IPropertiesContainer)context;
            attrs = new HashMap(container.getProperties());
        }
        if (attrs != null) {
            for (Map.Entry entry : attrs.entrySet()) {
                if (((String)entry.getKey()).endsWith(".transient")) continue;
                result.put((String)entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    protected Object fromMap(Map<String, Object> map, Object context) throws IOException {
        if (context == null || Map.class.equals(context.getClass())) {
            return map;
        }
        if (context instanceof Map) {
            HashMap<String, Object> newMap = new HashMap<String, Object>((Map)context);
            newMap.putAll(map);
            return newMap;
        }
        if (IPropertiesContainer.class.equals(context.getClass())) {
            PropertiesContainer container = new PropertiesContainer();
            container.setProperties(map);
            return container;
        }
        if (context instanceof IPropertiesContainer) {
            IPropertiesContainer container = (IPropertiesContainer)context;
            container.setProperties(map);
            return container;
        }
        return null;
    }
}

