/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.nls.Messages;
import org.eclipse.tcf.te.runtime.services.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.services.interfaces.IService;
import org.osgi.framework.Bundle;

public abstract class AbstractServiceManager {
    private Map<String, ServiceProxy> services = new HashMap<String, ServiceProxy>();

    protected AbstractServiceManager() {
        this.loadServices();
    }

    protected ServiceProxy getServiceProxy(IConfigurationElement config) {
        ServiceProxy proxy;
        block2: {
            Assert.isNotNull((Object)config);
            proxy = new ServiceProxy();
            try {
                proxy.setInitializationData(config, null, null);
            }
            catch (CoreException e) {
                if (!Platform.inDebugMode()) break block2;
                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log(e.getStatus());
            }
        }
        return proxy;
    }

    public <V extends IService> V getService(Object context, Class<? extends V> serviceType) {
        return this.getService(context, serviceType, false);
    }

    public <V extends IService> V getService(Object context, Class<? extends V> serviceType, boolean unique) {
        Assert.isNotNull(serviceType);
        Collection<ServiceProxy> proxies = this.services.values();
        if (proxies != null && !proxies.isEmpty()) {
            ArrayList<ServiceProxy> candidates = new ArrayList<ServiceProxy>();
            boolean isInterface = serviceType.isInterface();
            for (ServiceProxy proxy : proxies) {
                if (!proxy.isMatching(serviceType) || !proxy.isEnabled(context)) continue;
                if (!isInterface) {
                    IService service = proxy.getService(unique);
                    service.setId(proxy.getId());
                    return (V)service;
                }
                candidates.add(proxy);
            }
            IService service = null;
            if (!candidates.isEmpty()) {
                service = ((ServiceProxy)candidates.get(0)).getService(unique);
                service.setId(((ServiceProxy)candidates.get(0)).getId());
            }
            return (V)service;
        }
        return null;
    }

    public IService[] getServices(Object context, Class<? extends IService> serviceType, boolean unique) {
        Assert.isNotNull(serviceType);
        Collection<ServiceProxy> proxies = this.services.values();
        ArrayList<IService> services = new ArrayList<IService>();
        if (proxies != null && !proxies.isEmpty()) {
            ArrayList<ServiceProxy> candidates = new ArrayList<ServiceProxy>();
            for (ServiceProxy proxy : proxies) {
                if (!proxy.isMatching(serviceType) || !proxy.isEnabled(context)) continue;
                candidates.add(proxy);
            }
            for (ServiceProxy serviceProxy : candidates) {
                IService service = serviceProxy.getService(unique);
                service.setId(serviceProxy.getId());
                services.add(service);
            }
        }
        return services.toArray(new IService[services.size()]);
    }

    protected void addService(ServiceProxy proxy) {
        Assert.isNotNull(this.services);
        Assert.isNotNull((Object)proxy);
        String id = proxy.getId();
        Assert.isNotNull((Object)id);
        this.services.put(id, proxy);
    }

    public boolean hasService(Object context, String serviceTypeName) {
        Assert.isNotNull((Object)serviceTypeName);
        Collection<ServiceProxy> proxies = this.services.values();
        if (proxies != null && !proxies.isEmpty()) {
            for (ServiceProxy proxy : proxies) {
                if (!proxy.isMatching(serviceTypeName) || !proxy.isEnabled(context)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void loadServices();

    protected class ServiceProxy
    implements IExecutableExtension {
        private IConfigurationElement configElement = null;
        public String id;
        public String clazz;
        private IService service = null;
        private List<Class<? extends IService>> serviceTypes = new ArrayList<Class<? extends IService>>();
        private Expression expression;

        protected ServiceProxy() {
        }

        public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
            IConfigurationElement[] children;
            Assert.isNotNull((Object)config);
            this.configElement = config;
            this.id = config.getAttribute("id");
            if (this.id == null || "".equals(this.id.trim())) {
                throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.Extension_error_missingRequiredAttribute, (Object)"id", (Object)config.getContributor().getName())));
            }
            this.clazz = config.getAttribute("class");
            if (this.clazz == null && (children = config.getChildren("class")).length > 0) {
                this.clazz = children[0].getAttribute("class");
            }
            if (this.clazz == null || "".equals(this.clazz.trim())) {
                throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.Extension_error_missingRequiredAttribute, (Object)"class", (Object)config.getContributor().getName())));
            }
            children = this.configElement.getChildren("enablement");
            if (children != null && children.length > 0) {
                this.expression = ExpressionConverter.getDefault().perform(children[0]);
            }
        }

        public void addType(Class<? extends IService> serviceType) {
            Assert.isNotNull(serviceType);
            if (this.service == null && this.serviceTypes != null && !this.serviceTypes.contains(serviceType)) {
                this.serviceTypes.add(serviceType);
            }
        }

        protected IService getService(boolean unique) {
            if ((this.service == null || unique) && this.configElement != null) {
                try {
                    Object service = this.configElement.createExecutableExtension("class");
                    if (service instanceof IService) {
                        if (unique) {
                            return (IService)service;
                        }
                        this.service = (IService)service;
                    } else {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), "Service '" + service.getClass().getName() + "' not of type IService.");
                        Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                    }
                }
                catch (CoreException e) {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), "Cannot create service '" + this.clazz + "'.", (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
                if (this.serviceTypes != null) {
                    this.serviceTypes.clear();
                }
                this.serviceTypes = null;
            }
            return this.service;
        }

        protected boolean isMatching(Class<? extends IService> serviceType) {
            Assert.isNotNull(serviceType);
            if (this.service != null) {
                return serviceType.isInstance(this.service);
            }
            if (this.configElement != null) {
                if (serviceType.getClass().getName().equals(this.clazz)) {
                    return true;
                }
                for (Class<? extends IService> type : this.serviceTypes) {
                    if (!type.equals(serviceType)) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean isMatching(String serviceTypeName) {
            block5: {
                block4: {
                    Class<?>[] interfaces;
                    Assert.isNotNull((Object)serviceTypeName);
                    if (this.service == null) break block4;
                    Class<?>[] classArray = interfaces = this.service.getClass().getInterfaces();
                    int n = interfaces.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> interfaze = classArray[n2];
                        if (serviceTypeName.equals(interfaze.getName())) {
                            return true;
                        }
                        ++n2;
                    }
                    break block5;
                }
                if (this.configElement == null) break block5;
                if (serviceTypeName.equals(this.clazz)) {
                    return true;
                }
                for (Class<? extends IService> type : this.serviceTypes) {
                    if (!serviceTypeName.equals(type.getName())) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean isEnabled(Object context) {
            boolean enabled;
            if (context == null) {
                return this.getEnablement() == null;
            }
            Expression enablement = this.getEnablement();
            boolean bl = enabled = enablement == null;
            if (enablement != null) {
                EvaluationContext evalContext = new EvaluationContext(null, context);
                evalContext.setAllowPluginActivation(true);
                try {
                    enabled = enablement.evaluate((IEvaluationContext)evalContext).equals(EvaluationResult.TRUE);
                }
                catch (CoreException e) {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
            }
            return enabled;
        }

        protected String getId() {
            return this.id;
        }

        protected Expression getEnablement() {
            return this.expression;
        }

        public boolean equals(IService service) {
            Assert.isNotNull((Object)service);
            return this.clazz != null ? this.clazz.equals(service.getClass().getCanonicalName()) : false;
        }

        public boolean equals(ServiceProxy proxy) {
            Assert.isNotNull((Object)proxy);
            return this.clazz != null ? this.clazz.equals(proxy.clazz) : false;
        }
    }
}

