/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFFileSystemException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCreate;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSModel;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;

public class OpCreateFolder
extends OpCreate {
    public OpCreateFolder(FSTreeNode folder, String name) {
        super(folder, name);
    }

    @Override
    protected void create(IFileSystem service) throws TCFFileSystemException {
        String path = this.folder.getLocation(true);
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        path = String.valueOf(path) + this.name;
        final IFileSystem.FileSystemException[] errors = new IFileSystem.FileSystemException[1];
        service.mkdir(path, null, new IFileSystem.DoneMkDir(){

            public void doneMkDir(IToken token, IFileSystem.FileSystemException error) {
                if (error != null) {
                    errors[0] = error;
                }
            }
        });
        if (errors[0] != null) {
            TCFFileSystemException exception = new TCFFileSystemException(errors[0].toString());
            exception.initCause((Throwable)errors[0]);
            throw exception;
        }
    }

    @Override
    protected FSTreeNode newTreeNode() {
        FSTreeNode node = FSModel.createFolderNode(this.name, this.folder);
        node.queryDone();
        return node;
    }
}

