/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.te.runtime.utils.Host;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.NullOpExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpRefreshRoots;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.testers.TargetPropertyTester;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSModel;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.model.Model;

public class OpParsePath
extends Operation {
    IPeerModel peer;
    String path;
    FSTreeNode result;

    public OpParsePath(IPeerModel peer, String path) {
        this.peer = peer;
        this.path = path;
    }

    public OpParsePath(String filePath) {
        int slash;
        String cache_root = CacheManager.getCacheRoot().getAbsolutePath();
        if (filePath.startsWith(cache_root) && (slash = (filePath = filePath.substring(cache_root.length() + 1)).indexOf(File.separator)) != -1) {
            String peerId = filePath.substring(0, slash);
            peerId = peerId.replace('$', ':');
            Map peers = (Map)Model.getModel().getAdapter(Map.class);
            this.peer = (IPeerModel)peers.get(peerId);
            if (this.peer != null) {
                boolean hostWindows = Host.isWindowsHost();
                boolean windows = TargetPropertyTester.isWindows(this.peer);
                filePath = filePath.substring(slash + 1);
                if (hostWindows) {
                    if (windows) {
                        slash = filePath.indexOf(File.separator);
                        if (slash != -1) {
                            String disk = filePath.substring(0, slash);
                            filePath = filePath.substring(slash + 1);
                            disk = disk.replace('$', ':');
                            filePath = String.valueOf(disk) + File.separator + filePath;
                        }
                    } else {
                        filePath = "/" + filePath.replace('\\', '/');
                    }
                } else if (windows) {
                    slash = filePath.indexOf(File.separator);
                    if (slash != -1) {
                        String disk = filePath.substring(0, slash);
                        filePath = filePath.substring(slash + 1);
                        disk = disk.replace('$', ':');
                        filePath = String.valueOf(disk) + File.separator + filePath;
                    }
                    filePath = filePath.replace(File.separatorChar, '\\');
                } else {
                    filePath = "/" + filePath;
                }
                this.path = filePath;
            }
        }
    }

    public FSTreeNode getResult() {
        return this.result;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.peer != null && this.path != null) {
            Object[] elements;
            FSTreeNode root = FSModel.getFSModel(this.peer).getRoot();
            if (!root.childrenQueried) {
                new NullOpExecutor().execute(new OpRefreshRoots(root));
            }
            if ((elements = root.getChildren().toArray()) != null && elements.length != 0 && this.path.length() != 0) {
                final FSTreeNode[] children = new FSTreeNode[elements.length];
                System.arraycopy(elements, 0, children, 0, elements.length);
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                    }

                    public void run() throws Exception {
                        OpParsePath.this.result = OpParsePath.this.findPath(OpParsePath.this.peer.getPeer(), children, OpParsePath.this.path);
                    }
                });
            }
        }
    }

    FSTreeNode findPath(IPeer peer, FSTreeNode[] children, String path) throws TCFException, InterruptedException {
        Assert.isTrue((children != null && children.length != 0 ? 1 : 0) != 0);
        Assert.isTrue((path != null && path.length() != 0 ? 1 : 0) != 0);
        FSTreeNode node = children[0];
        String osPathSep = node.isWindowsNode() ? "\\" : "/";
        int delim = path.indexOf(osPathSep);
        String segment = null;
        if (delim != -1) {
            segment = path.substring(0, delim);
            path = path.substring(delim + 1);
            if (node.isRoot()) {
                segment = String.valueOf(segment) + osPathSep;
            }
        } else {
            segment = path;
            path = null;
        }
        node = this.findPathSeg(children, segment);
        if (path == null || path.trim().length() == 0) {
            return node;
        }
        if (node != null) {
            if (node.isDirectory()) {
                List<FSTreeNode> nodes = new Operation().getChildren(node);
                children = nodes.toArray(new FSTreeNode[nodes.size()]);
            } else {
                children = null;
            }
            if (children != null && children.length != 0) {
                return this.findPath(peer, children, path);
            }
        }
        return null;
    }

    private FSTreeNode findPathSeg(FSTreeNode[] children, String name) {
        FSTreeNode[] fSTreeNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            FSTreeNode child = fSTreeNodeArray[n2];
            if (child.isWindowsNode() ? child.name.equalsIgnoreCase(name) : child.name.equals(name)) {
                return child;
            }
            ++n2;
        }
        return null;
    }
}

