/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCopy;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpMove;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.dnd.CommonDnD;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers.MoveCopyCallback;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.FsClipboard;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.ui.handlers.HandlerUtil;

public class PasteFilesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FsClipboard cb = UIPlugin.getClipboard();
        if (!cb.isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            List nodes = cb.getFiles();
            UiExecutor executor = null;
            OpMove operation = null;
            if (cb.isCutOp()) {
                FSTreeNode dest = (FSTreeNode)selection.getFirstElement();
                operation = new OpMove(nodes, dest, (IConfirmCallback)new MoveCopyCallback());
                executor = new UiExecutor((ICallback)new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        UIPlugin.getClipboard().clear();
                    }
                });
            } else if (cb.isCopyOp()) {
                FSTreeNode hovered = (FSTreeNode)selection.getFirstElement();
                FSTreeNode dest = this.getCopyDestination(hovered, nodes);
                boolean cpPerm = UIPlugin.isCopyPermission();
                boolean cpOwn = UIPlugin.isCopyOwnership();
                operation = new OpCopy(nodes, dest, cpPerm, cpOwn, (IConfirmCallback)new MoveCopyCallback());
                executor = new UiExecutor();
            }
            if (executor != null && operation != null) {
                executor.execute((IOperation)operation);
            }
        } else {
            Clipboard clipboard = cb.getSystemClipboard();
            Object contents = clipboard.getContents((Transfer)FileTransfer.getInstance());
            if (contents != null) {
                String[] files = (String[])contents;
                IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
                FSTreeNode hovered = (FSTreeNode)selection.getFirstElement();
                CommonDnD dnd = new CommonDnD();
                dnd.dropFiles(null, files, 1, hovered);
            }
        }
        return null;
    }

    private FSTreeNode getCopyDestination(FSTreeNode hovered, List<FSTreeNode> nodes) {
        if (hovered.isFile()) {
            return hovered.getParent();
        }
        if (hovered.isDirectory()) {
            for (FSTreeNode node : nodes) {
                if (node != hovered) continue;
                return hovered.getParent();
            }
        }
        return hovered;
    }
}

