/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards.NewNodeWizardPage;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.Validator;

public class NameValidator
extends Validator {
    NewNodeWizardPage wizard;

    public NameValidator(NewNodeWizardPage wizard) {
        super(1);
        this.wizard = wizard;
    }

    public boolean isValid(String newText) {
        String formatRegex;
        FSTreeNode folder = this.wizard.getInputDir();
        if (folder == null) {
            this.setMessage(Messages.NameValidator_SpecifyFolder, 1);
            return false;
        }
        if (newText == null || newText.trim().length() == 0) {
            this.setMessage(Messages.FSRenamingAssistant_SpecifyNonEmptyName, 3);
            return false;
        }
        String text = newText.trim();
        if (this.hasChild(text)) {
            this.setMessage(Messages.FSRenamingAssistant_NameAlreadyExists, 3);
            return false;
        }
        String string = formatRegex = folder.isWindowsNode() ? "[^(\\?|\\\\|/|:|\\*|<|>|\\|)]+" : "[^/]+";
        if (!text.matches(formatRegex)) {
            this.setMessage(folder.isWindowsNode() ? Messages.FSRenamingAssistant_WinIllegalCharacters : Messages.FSRenamingAssistant_UnixIllegalCharacters, 3);
            return false;
        }
        this.setMessage(null, 0);
        return true;
    }

    private boolean hasChild(String name) {
        List<FSTreeNode> nodes = this.getChildren();
        for (FSTreeNode node : nodes) {
            if (!(node.isWindowsNode() ? node.name.equalsIgnoreCase(name) : node.name.equals(name))) continue;
            return true;
        }
        return false;
    }

    private List<FSTreeNode> getChildren() {
        final FSTreeNode folder = this.wizard.getInputDir();
        if (folder.childrenQueried) {
            return folder.getChildren();
        }
        final ArrayList<FSTreeNode> result = new ArrayList<FSTreeNode>();
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                result.addAll(new Operation().getChildren(folder));
            }
        });
        return result;
    }
}

