/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.steps;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IDebugService;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.launch.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.launch.core.steps.AbstractTcfLaunchStep;

public class AttachDebuggerStep
extends AbstractTcfLaunchStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        if (StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.launch.process_context", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data) == null) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing process context"));
        }
    }

    public void execute(IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, final ICallback callback) {
        IDebugService dbgService = (IDebugService)ServiceManager.getInstance().getService((Object)this.getActivePeerModel(data), IDebugService.class, false);
        if (dbgService != null) {
            Callback cb = new Callback();
            dbgService.attach((Object)this.getActivePeerModel(data), (IPropertiesContainer)new PropertiesContainer(), (ICallback)cb);
            ExecutorsUtil.waitAndExecute((long)0L, (IConditionTester)cb.getDoneConditionTester(monitor));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IProcesses.ProcessContext processContext = (IProcesses.ProcessContext)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.launch.process_context", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
                    IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.launch.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
                    Assert.isNotNull((Object)channel);
                    IRunControl runControl = (IRunControl)channel.getRemoteService(IRunControl.class);
                    if (runControl != null) {
                        runControl.getContext(processContext.getID(), new IRunControl.DoneGetContext(){

                            public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
                                if (error == null) {
                                    context.resume(0, 1, new IRunControl.DoneCommand(){

                                        public void doneCommand(IToken token, Exception error) {
                                            callback.done((Object)AttachDebuggerStep.this, StatusHelper.getStatus((Throwable)error));
                                        }
                                    });
                                } else {
                                    callback.done((Object)AttachDebuggerStep.this, StatusHelper.getStatus((Throwable)error));
                                }
                            }
                        });
                    } else {
                        callback.done((Object)this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing run control service"));
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeLater((Runnable)runnable);
            }
        } else {
            callback.done((Object)this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing debugger service"));
        }
    }
}

