/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelPeerNodeQueryService;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;

public class LocatorModelPropertyTester
extends PropertyTester {
    public boolean test(final Object receiver, final String property, final Object[] args, final Object expectedValue) {
        if (receiver instanceof IPeerModel) {
            final AtomicBoolean result = new AtomicBoolean();
            if ("hasLocalService".equals(property) || "hasRemoteService".equals(property)) {
                if (!Protocol.isDispatchThread()) {
                    result.set(this.testServices((IPeerModel)receiver, property, args, expectedValue));
                }
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        result.set(LocatorModelPropertyTester.this.testPeerModel((IPeerModel)receiver, property, args, expectedValue));
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
            }
            return result.get();
        }
        return false;
    }

    protected boolean testPeerModel(IPeerModel node, String property, Object[] args, Object expectedValue) {
        String value;
        Assert.isNotNull((Object)node);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if ("name".equals(property) && node.getPeer().getName() != null && node.getPeer().getName().equals(expectedValue)) {
            return true;
        }
        if ("isStaticPeer".equals(property)) {
            boolean isStaticPeer;
            value = (String)node.getPeer().getAttributes().get("static.transient");
            boolean bl = isStaticPeer = value != null && Boolean.parseBoolean(value.trim());
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isStaticPeer;
            }
        }
        if ("isRedirected".equals(property)) {
            boolean isRedirected = node.getPeer() instanceof PeerRedirector;
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isRedirected;
            }
        }
        if ("isProxy".equals(property)) {
            boolean isProxy = node.getPeer().getAttributes().containsKey("Proxy");
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isProxy;
            }
        }
        if ("isValueAdd".equals(property)) {
            boolean isValueAdd;
            value = (String)node.getPeer().getAttributes().get("ValueAdd");
            boolean bl = isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isValueAdd;
            }
        }
        return false;
    }

    protected boolean testServices(IPeerModel node, String property, Object[] args, Object expectedValue) {
        Assert.isNotNull((Object)node);
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        String services = null;
        ILocatorModel model = node.getModel();
        ILocatorModelPeerNodeQueryService queryService = model.getService(ILocatorModelPeerNodeQueryService.class);
        services = "hasLocalService".equals(property) ? queryService.queryLocalServices(node) : queryService.queryRemoteServices(node);
        if (services != null) {
            String[] stringArray = services.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String service = stringArray[n2];
                if (service != null && service.trim().equals(expectedValue)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

