/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.locator.ScannerRunnable;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.model.ModelLocationUtil;
import org.eclipse.tcf.te.tcf.locator.nodes.LocatorModel;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerModel;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;
import org.eclipse.tcf.te.tcf.locator.services.AbstractLocatorModelService;

public class LocatorModelRefreshService
extends AbstractLocatorModelService
implements ILocatorModelRefreshService {
    private final AtomicBoolean REFRESH_STATIC_PEERS_GUARD = new AtomicBoolean(false);

    public LocatorModelRefreshService(ILocatorModel parentModel) {
        super(parentModel);
    }

    @Override
    public void refresh() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ILocatorModel model = this.getLocatorModel();
        if (model.isDisposed()) {
            return;
        }
        if (!Tcf.isRunning()) {
            return;
        }
        ArrayList<IPeerModel> oldChildren = new ArrayList<IPeerModel>(Arrays.asList(model.getPeers()));
        ILocator locatorService = Protocol.getLocator();
        if (locatorService != null) {
            if (model instanceof LocatorModel) {
                ((LocatorModel)model).checkLocatorListener();
            }
            Map peers = locatorService.getPeers();
            this.processPeers(peers, oldChildren, model);
        }
        this.refreshStaticPeers(oldChildren, model);
        for (IPeerModel oldChild : oldChildren) {
            model.getService(ILocatorModelUpdateService.class).remove(oldChild);
        }
    }

    protected void processPeers(Map<String, IPeer> peers, List<IPeerModel> oldChildren, ILocatorModel model) {
        Assert.isNotNull(peers);
        Assert.isNotNull(oldChildren);
        Assert.isNotNull((Object)model);
        for (Map.Entry<String, IPeer> entry : peers.entrySet()) {
            boolean isStatic;
            IPeer peer = entry.getValue();
            IPeerModel peerNode = model.getService(ILocatorModelLookupService.class).lkupPeerModelById(entry.getKey());
            if (peerNode == null) {
                peerNode = new PeerModel(model, peer);
            } else {
                oldChildren.remove(peerNode);
            }
            model.getService(ILocatorModelUpdateService.class).mergeUserDefinedAttributes(peerNode, peer, false);
            peerNode = model.validatePeerNodeForAdd(peerNode);
            if (peerNode == null) continue;
            String value = (String)peerNode.getPeer().getAttributes().get("static.transient");
            boolean bl = isStatic = value != null && Boolean.parseBoolean(value.trim());
            if (isStatic) {
                for (IPeerModel candidate : oldChildren) {
                    String port2;
                    if (peerNode.getPeer().getTransportName() == null || !peerNode.getPeer().getTransportName().equals(candidate.getPeer().getTransportName())) continue;
                    if ("PIPE".equals(candidate.getPeer().getTransportName())) {
                        String name1 = (String)peerNode.getPeer().getAttributes().get("PipeName");
                        String name2 = (String)candidate.getPeer().getAttributes().get("PipeName");
                        if (name1 == null || !name1.equals(name2)) continue;
                        model.getService(ILocatorModelUpdateService.class).mergeUserDefinedAttributes(candidate, peerNode.getPeer(), true);
                        peerNode = null;
                        break;
                    }
                    if ("Loop".equals(candidate.getPeer().getTransportName())) {
                        model.getService(ILocatorModelUpdateService.class).mergeUserDefinedAttributes(candidate, peerNode.getPeer(), true);
                        peerNode = null;
                        break;
                    }
                    String ip1 = (String)peerNode.getPeer().getAttributes().get("Host");
                    String ip2 = (String)candidate.getPeer().getAttributes().get("Host");
                    if (!IPAddressUtil.getInstance().isSameHost(ip1, ip2)) continue;
                    String port1 = (String)peerNode.getPeer().getAttributes().get("Port");
                    if (port1 == null || "".equals(port1)) {
                        port1 = "1534";
                    }
                    if ((port2 = (String)candidate.getPeer().getAttributes().get("Port")) == null || "".equals(port2)) {
                        port2 = "1534";
                    }
                    if (!port1.equals(port2)) continue;
                    model.getService(ILocatorModelUpdateService.class).mergeUserDefinedAttributes(candidate, peerNode.getPeer(), true);
                    peerNode = null;
                    break;
                }
            }
            if (peerNode == null) continue;
            model.getService(ILocatorModelUpdateService.class).add(peerNode);
            ScannerRunnable runnable = new ScannerRunnable(model.getScanner(), peerNode);
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    @Override
    public void refreshStaticPeers() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (this.REFRESH_STATIC_PEERS_GUARD.get()) {
            return;
        }
        this.REFRESH_STATIC_PEERS_GUARD.set(true);
        ILocatorModel model = this.getLocatorModel();
        if (model.isDisposed()) {
            return;
        }
        ArrayList<IPeerModel> oldChildren = new ArrayList<IPeerModel>(Arrays.asList(model.getPeers()));
        this.refreshStaticPeers(oldChildren, model);
        this.REFRESH_STATIC_PEERS_GUARD.set(false);
    }

    protected void refreshStaticPeers(List<IPeerModel> oldChildren, ILocatorModel model) {
        Assert.isNotNull(oldChildren);
        Assert.isNotNull((Object)model);
        File[] roots = this.getStaticPeerLookupDirectories();
        if (roots.length > 0) {
            HashMap<String, IPeer> peers = new HashMap<String, IPeer>();
            ArrayList<HashMap<String, String>> postponed = new ArrayList<HashMap<String, String>>();
            File[] fileArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                File[] candidates = file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        Path path = new Path(pathname.getAbsolutePath());
                        return path.getFileExtension() != null && path.getFileExtension().toLowerCase().equals("json");
                    }
                });
                if (candidates != null && candidates.length > 0) {
                    File[] fileArray2 = candidates;
                    int n3 = candidates.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File candidate = fileArray2[n4];
                        try {
                            String id;
                            IURIPersistenceService service = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                            IPeer tempPeer = (IPeer)service.read(IPeer.class, candidate.getAbsoluteFile().toURI());
                            HashMap<String, String> attrs = new HashMap<String, String>(tempPeer.getAttributes());
                            attrs.put("URI.transient", candidate.getAbsoluteFile().toURI().toString());
                            attrs.put("static.transient", "true");
                            String name = (String)attrs.get("Name");
                            if (name == null || "".equals(name.trim())) {
                                name = new Path(candidate.getAbsolutePath()).removeFileExtension().lastSegment();
                                attrs.put("Name", name);
                            }
                            if ((id = (String)attrs.get("ID")) == null || "".equals(id.trim()) || "USR:".equals(id.trim())) {
                                String transport = (String)attrs.get("TransportName");
                                String host = (String)attrs.get("Host");
                                String port = (String)attrs.get("Port");
                                if (!(transport == null || host == null || id != null && "USR:".equals(id.trim()))) {
                                    id = String.valueOf(transport.trim()) + ":" + host.trim();
                                    id = String.valueOf(id) + (port != null ? ":" + port.trim() : ":1534");
                                } else {
                                    id = "USR:" + System.currentTimeMillis();
                                    while (peers.containsKey(id)) {
                                        try {
                                            Thread.sleep(20L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                        id = "USR:" + System.currentTimeMillis();
                                    }
                                }
                                attrs.put("ID", id);
                            }
                            if (attrs.get("redirect.proxy") == null) {
                                TransientPeer peer = new TransientPeer(attrs);
                                peers.put(peer.getID(), (IPeer)peer);
                            } else {
                                IPeerModel peerModel;
                                String proxyId = (String)attrs.get("redirect.proxy");
                                IPeer proxy = (IPeer)peers.get(proxyId);
                                if (proxy == null && (peerModel = model.getService(ILocatorModelLookupService.class).lkupPeerModelById(proxyId)) != null) {
                                    proxy = peerModel.getPeer();
                                }
                                if (proxy != null) {
                                    PeerRedirector redirector = new PeerRedirector(proxy, attrs);
                                    peers.put(redirector.getID(), redirector);
                                } else {
                                    postponed.add(attrs);
                                }
                            }
                        }
                        catch (IOException iOException) {}
                        ++n4;
                    }
                }
                ++n2;
            }
            if (!postponed.isEmpty()) {
                for (Map map : postponed) {
                    IPeerModel peerModel;
                    IPeer proxy;
                    String proxyId = (String)map.get("redirect.proxy");
                    IPeer iPeer = proxy = proxyId != null ? (IPeer)peers.get(proxyId) : null;
                    if (proxy == null && (peerModel = model.getService(ILocatorModelLookupService.class).lkupPeerModelById(proxyId)) != null) {
                        proxy = peerModel.getPeer();
                    }
                    if (proxy != null) {
                        PeerRedirector redirector = new PeerRedirector(proxy, map);
                        peers.put(redirector.getID(), redirector);
                        continue;
                    }
                    map.remove("redirect.proxy");
                    TransientPeer peer = new TransientPeer(map);
                    peers.put(peer.getID(), (IPeer)peer);
                }
            }
            if (!peers.isEmpty()) {
                this.processPeers(peers, oldChildren, model);
            }
            for (Map.Entry entry : peers.entrySet()) {
                IPeer peer = (IPeer)entry.getValue();
                if (!(peer instanceof PeerRedirector)) continue;
                IPeerModel peerModel = model.getService(ILocatorModelLookupService.class).lkupPeerModelById((String)entry.getKey());
                Assert.isNotNull((Object)peerModel);
                String proxyPeerId = ((PeerRedirector)peer).getParent().getID();
                IPeerModel proxy = model.getService(ILocatorModelLookupService.class).lkupPeerModelById(proxyPeerId);
                Assert.isNotNull((Object)proxy);
                peerModel.setParent(proxy);
                model.getService(ILocatorModelUpdateService.class).addChild(peerModel);
            }
        }
    }

    protected File[] getStaticPeerLookupDirectories() {
        File file;
        IPath defaultPath;
        ArrayList<File> rootLocations = new ArrayList<File>();
        String roots = Platform.getPreferencesService().getString(CoreBundleActivator.getUniqueIdentifier(), "te.tcf.locator.core.model.peers.rootLocations", null, null);
        if (roots != null) {
            String[] candidates;
            String[] stringArray = candidates = roots.split(File.pathSeparator);
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                String candidate = stringArray[n2];
                File file2 = new File(candidate);
                if (file2.canRead() && file2.isDirectory() && !rootLocations.contains(file2)) {
                    rootLocations.add(file2);
                }
                ++n2;
            }
        }
        if ((defaultPath = ModelLocationUtil.getStaticPeersRootLocation()) != null && (file = defaultPath.toFile()).canRead() && file.isDirectory() && !rootLocations.contains(file)) {
            rootLocations.add(file);
        }
        return rootLocations.toArray(new File[rootLocations.size()]);
    }
}

