/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.callbacks;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.QueryDoneGetChildren;
import org.eclipse.tcf.te.tcf.processes.core.model.ProcessTreeNode;

public class QueryDoneOpenChannel
implements IChannelManager.DoneOpenChannel {
    ProcessTreeNode parentNode;
    ICallback callback;

    public QueryDoneOpenChannel(ProcessTreeNode parentNode) {
        this(parentNode, null);
    }

    public QueryDoneOpenChannel(ProcessTreeNode parentNode, ICallback callback) {
        this.parentNode = parentNode;
        this.callback = callback;
    }

    public void doneOpenChannel(Throwable error, final IChannel channel) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        if (error == null && channel != null) {
            ISysMonitor service = (ISysMonitor)channel.getRemoteService(ISysMonitor.class);
            if (service != null) {
                service.getChildren(this.parentNode.id, (ISysMonitor.DoneGetChildren)new QueryDoneGetChildren((ICallback)new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        QueryDoneOpenChannel.this.parentNode.queryDone();
                        Tcf.getChannelManager().closeChannel(channel);
                        if (QueryDoneOpenChannel.this.callback != null) {
                            QueryDoneOpenChannel.this.callback.done(caller, status);
                        }
                    }
                }, channel, service, this.parentNode));
            } else if (this.callback != null) {
                this.callback.done((Object)this, Status.OK_STATUS);
            }
        } else if (this.callback != null) {
            IStatus status = error == null ? Status.OK_STATUS : new Status(4, CoreBundleActivator.getUniqueIdentifier(), error.getMessage(), error);
            this.callback.done((Object)this, status);
        }
    }
}

