/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.callbacks;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.CallbackMonitor;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.RefreshDoneGetChildren;
import org.eclipse.tcf.te.tcf.processes.core.model.ProcessTreeNode;

public class RefreshChildrenDoneOpenChannel
implements IChannelManager.DoneOpenChannel {
    ProcessTreeNode parentNode;

    public RefreshChildrenDoneOpenChannel(ProcessTreeNode parentNode) {
        this.parentNode = parentNode;
    }

    public void doneOpenChannel(Throwable error, final IChannel channel) {
        ISysMonitor service;
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        if (error == null && channel != null && (service = (ISysMonitor)channel.getRemoteService(ISysMonitor.class)) != null) {
            final CallbackMonitor monitor = new CallbackMonitor((ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    Tcf.getChannelManager().closeChannel(channel);
                }
            }, this.getChildrenIds());
            for (ProcessTreeNode child : this.parentNode.getChildren()) {
                if (child.childrenQueried || child.childrenQueryRunning) continue;
                final String contextId = child.id;
                Callback callback = new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        monitor.unlock(contextId, status);
                    }
                };
                ConcurrentLinkedQueue<ProcessTreeNode> queue = new ConcurrentLinkedQueue<ProcessTreeNode>();
                RefreshDoneGetChildren done = new RefreshDoneGetChildren((ICallback)callback, queue, channel, service, child);
                service.getChildren(child.id, (ISysMonitor.DoneGetChildren)done);
            }
        }
    }

    private Object[] getChildrenIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (ProcessTreeNode child : this.parentNode.getChildren()) {
            ids.add(child.id);
        }
        return ids.toArray(new Object[ids.size()]);
    }
}

