/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.activator;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.ui.jface.images.AbstractImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends AbstractUIPlugin {
    private static UIPlugin plugin;
    private IWorkbenchListener listener;

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (UIPlugin.getDefault() != null && UIPlugin.getDefault().getBundle() != null) {
            return UIPlugin.getDefault().getBundle().getSymbolicName();
        }
        return "org.eclipse.tcf.te.tcf.ui";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.listener = new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                Tcf.getChannelManager().closeAll();
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        };
        PlatformUI.getWorkbench().addWorkbenchListener(this.listener);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.listener != null) {
            PlatformUI.getWorkbench().removeWorkbenchListener(this.listener);
            this.listener = null;
        }
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        URL url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/peer.gif");
        registry.put("PeerObject", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/peer_discovered.gif");
        registry.put("PeerObjectDiscovered", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/discovery_root.gif");
        registry.put("RemotePeerDiscoverRootNodeObject", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/gold_ovr.gif");
        registry.put("GoldOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/green_ovr.gif");
        registry.put("GreenOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/grey_ovr.gif");
        registry.put("GreyOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/red_ovr.gif");
        registry.put("RedOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/redX_ovr.gif");
        registry.put("RedXOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/link_ovr.gif");
        registry.put("LinkOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/dtool16/run_exc.gif");
        registry.put("RunDisabled", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/etool16/run_exc.gif");
        registry.put("RunEnabled", ImageDescriptor.createFromURL((URL)url));
    }

    public static Image getImage(String key) {
        return UIPlugin.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return UIPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }

    public static Image getSharedImage(AbstractImageDescriptor descriptor) {
        String imageKey;
        ImageRegistry registry = UIPlugin.getDefault().getImageRegistry();
        Image image = registry.get(imageKey = descriptor.getDecriptorKey());
        if (image == null) {
            registry.put(imageKey, (ImageDescriptor)descriptor);
            image = registry.get(imageKey);
        }
        return image;
    }
}

