/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.tabs;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.ui.terminals.nls.Messages;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;

public class TabTerminalListener
implements ITerminalListener {
    private final CTabItem tabItem;
    private static final Pattern TERMINAL_TITLE_TERMINATED_PATTERN = Pattern.compile(Messages.TabTerminalListener_consoleTerminated.replaceAll("\\{[0-9]+\\}", ".*"));

    public TabTerminalListener(CTabItem tabItem) {
        Assert.isNotNull((Object)tabItem);
        this.tabItem = tabItem;
    }

    protected final CTabItem getTabItem() {
        return this.tabItem;
    }

    public void setState(final TerminalState state) {
        final CTabItem item = this.getTabItem();
        if (item == null || item.isDisposed()) {
            return;
        }
        item.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String newTitle = TabTerminalListener.this.getTerminalConsoleTabTitle(state);
                if (newTitle != null) {
                    item.setText(newTitle);
                }
            }
        });
    }

    protected String getTerminalConsoleTabTitle(TerminalState state) {
        Assert.isNotNull((Object)state);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        CTabItem item = this.getTabItem();
        if (item == null || item.isDisposed()) {
            return null;
        }
        String oldTitle = item.getText();
        String newTitle = null;
        if (TerminalState.CLOSED.equals(state)) {
            newTitle = !TERMINAL_TITLE_TERMINATED_PATTERN.matcher(oldTitle).matches() ? NLS.bind((String)Messages.TabTerminalListener_consoleTerminated, (Object)oldTitle) : oldTitle;
        }
        return newTitle != null && !newTitle.equals(oldTitle) ? newTitle : null;
    }

    public void setTerminalTitle(String title) {
    }
}

