/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.editor.pages;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.tcf.te.ui.views.nls.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.menus.IMenuService;

public abstract class AbstractCustomFormToolkitEditorPage
extends AbstractEditorPage {
    private CustomFormToolkit toolkit = null;

    protected final CustomFormToolkit getFormToolkit() {
        return this.toolkit;
    }

    protected final void setFormToolkit(CustomFormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        Assert.isNotNull((Object)managedForm);
        this.toolkit = new CustomFormToolkit(managedForm.getToolkit());
        this.configureManagedForm(managedForm);
        this.doCreateFormContent(managedForm.getForm().getBody(), this.getFormToolkit());
        managedForm.reflow(true);
    }

    protected void configureManagedForm(IManagedForm managedForm) {
        Assert.isNotNull((Object)managedForm);
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout((boolean)false, (int)1));
        if (this.getContextHelpId() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)managedForm.getForm(), this.getContextHelpId());
        }
        this.getFormToolkit().getFormToolkit().decorateFormHeading(managedForm.getForm().getForm());
        if (this.getFormTitle() != null) {
            managedForm.getForm().getForm().setText(this.getFormTitle());
        }
        managedForm.getForm().getForm().setImage(this.getFormImage());
        IToolBarManager manager = managedForm.getForm().getForm().getToolBarManager();
        manager.add((IContributionItem)new Separator("additions"));
        this.createToolbarContributionItems(manager);
        IMenuService service = (IMenuService)this.getSite().getService(IMenuService.class);
        if (service != null) {
            service.populateContributionManager((ContributionManager)((ToolBarManager)manager), "toolbar:" + this.getId());
        }
        manager.update(true);
    }

    protected String getContextHelpId() {
        return null;
    }

    protected String getFormTitle() {
        return null;
    }

    protected Image getFormImage() {
        return null;
    }

    protected void createToolbarContributionItems(IToolBarManager manager) {
        Assert.isNotNull((Object)manager);
        if (this.getContextHelpId() != null) {
            HelpAction helpAction = new HelpAction(this.getContextHelpId());
            manager.add((IAction)helpAction);
        }
    }

    protected abstract void doCreateFormContent(Composite var1, CustomFormToolkit var2);

    protected static class HelpAction
    extends Action {
        final String helpID;

        public HelpAction(String helpID) {
            super(Messages.AbstractCustomFormToolkitEditorPage_HelpAction_label, 1);
            Assert.isNotNull((Object)helpID);
            this.helpID = helpID;
            this.setToolTipText(Messages.AbstractCustomFormToolkitEditorPage_HelpAction_tooltip);
            this.setImageDescriptor(UIPlugin.getImageDescriptor("HelpAction"));
        }

        public void run() {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp(HelpAction.this.helpID);
                }
            });
        }
    }
}

