/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.internal.utils;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.te.ui.internal.utils.QuickFilterPopup;
import org.eclipse.tcf.te.ui.internal.utils.TablePatternFilter;

public class QuickFilter
extends TablePatternFilter {
    private TreeViewer viewer;
    private Object root;

    public QuickFilter(TreeViewer viewer) {
        super((ILabelProvider)viewer.getLabelProvider());
        this.viewer = viewer;
    }

    public void showFilterPopup(Object root) {
        this.root = root;
        if (!this.isFiltering()) {
            this.viewer.addFilter((ViewerFilter)this);
        }
        QuickFilterPopup popup = new QuickFilterPopup(this.viewer, this);
        Point location = null;
        if (root != null) {
            TreeItem[] items = this.viewer.getTree().getSelection();
            if (items != null && items.length > 0) {
                Rectangle bounds = items[0].getBounds();
                location = new Point(bounds.x, bounds.y);
            } else {
                location = new Point(0, 0);
            }
        } else {
            location = new Point(0, 0);
        }
        location.y -= this.viewer.getTree().getItemHeight();
        location = this.viewer.getTree().toDisplay(location);
        popup.open();
        popup.getShell().setLocation(location);
    }

    public void resetViewer() {
        this.viewer.removeFilter((ViewerFilter)this);
        this.root = null;
        this.setPattern(null);
    }

    public boolean isFiltering() {
        ViewerFilter[] filters = this.viewer.getFilters();
        if (filters != null) {
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (filter == this) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.skipMatching(parentElement) || super.select(viewer, parentElement, element);
    }

    private boolean skipMatching(Object parentElement) {
        if (this.root == null || parentElement == null) {
            return true;
        }
        if (parentElement instanceof TreePath) {
            if (this.root instanceof TreePath) {
                return !this.root.equals(parentElement);
            }
            Object parent = ((TreePath)parentElement).getLastSegment();
            return !this.root.equals(parent);
        }
        if (this.root instanceof TreePath) {
            Object rootElement = ((TreePath)this.root).getLastSegment();
            return !parentElement.equals(rootElement);
        }
        return !this.root.equals(parentElement);
    }
}

