/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.concurrent.executors;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.concurrent.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.concurrent.interfaces.IExecutor;
import org.eclipse.tcf.te.runtime.concurrent.nls.Messages;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtension;
import org.osgi.framework.Bundle;

public abstract class AbstractDelegatingExecutorService
extends ExecutableExtension
implements IExecutor,
ExecutorService {
    private ExecutorService delegate;
    private String threadPoolNamePrefix;

    public void doSetInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.doSetInitializationData(config, propertyName, data);
        if (config != null && data instanceof Map) {
            Map params = (Map)data;
            this.threadPoolNamePrefix = (String)params.get("threadPoolNamePrefix");
            if (this.threadPoolNamePrefix == null || this.threadPoolNamePrefix.trim().length() == 0) {
                this.threadPoolNamePrefix = "";
            }
        }
        this.delegate = this.createExecutorServiceDelegate();
        Assert.isNotNull((Object)this.delegate);
    }

    public String getThreadPoolNamePrefix() {
        return this.threadPoolNamePrefix != null ? this.threadPoolNamePrefix : "";
    }

    protected abstract ExecutorService createExecutorServiceDelegate();

    protected final ExecutorService getExecutorServiceDelegate() {
        return this.delegate;
    }

    protected void logException(Throwable e) {
        if (e != null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.AbstractDelegatingExecutorService_unhandledException, (Object)e.getLocalizedMessage()), e);
            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
        }
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(command);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks, timeout, unit);
    }
}

