/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.rse.processes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.processes.AbstractProcessService;
import org.eclipse.rse.services.processes.IProcessService;
import org.eclipse.tcf.internal.rse.ITCFService;
import org.eclipse.tcf.internal.rse.TCFConnectorService;
import org.eclipse.tcf.internal.rse.TCFConnectorServiceManager;
import org.eclipse.tcf.internal.rse.TCFRSETask;
import org.eclipse.tcf.internal.rse.processes.TCFProcessResource;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IProcesses;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFProcessService
extends AbstractProcessService
implements IProcessService {
    private final TCFConnectorService connector;
    private final TCFProcessResource root;
    private final Map<Long, TCFProcessResource> pid2res = new HashMap<Long, TCFProcessResource>();
    private final Map<String, Long> signals = new HashMap<String, Long>();
    private final List<Runnable> get_signals_wait_list = new ArrayList<Runnable>();

    public TCFProcessService(IHost host) {
        this.connector = (TCFConnectorService)TCFConnectorServiceManager.getInstance().getConnectorService(host, ITCFService.class);
        this.root = new TCFProcessResource(this, null, null, null);
    }

    public TCFConnectorService getTCFConnectorService() {
        return this.connector;
    }

    public String getDescription() {
        return "The TCF Process Service uses the Target Communication Framework to provide service for the Processes subsystem. It requires a TCF agent to be running on the remote machine.";
    }

    public String getName() {
        return "TCF Process Service";
    }

    public IHostProcess getParentProcess(long PID, IProgressMonitor monitor) throws SystemMessageException {
        return this.getProcess(this.getProcess(PID, monitor).getPPid(), monitor);
    }

    public IHostProcess getProcess(final long PID, IProgressMonitor monitor) throws SystemMessageException {
        return (IHostProcess)new TCFRSETask<IHostProcess>(){

            public void run() {
                if (!TCFProcessService.this.root.loadChildren((Runnable)((Object)this))) {
                    return;
                }
                if (TCFProcessService.this.root.getChildrenError() != null) {
                    this.error(TCFProcessService.this.root.getChildrenError());
                    return;
                }
                this.done((IHostProcess)TCFProcessService.this.pid2res.get(PID));
            }
        }.getS(monitor, "Get process properties");
    }

    public String[] getSignalTypes() {
        return (String[])new TCFRSETask<String[]>(){

            public void run() {
                if (TCFProcessService.this.signals.isEmpty()) {
                    if (TCFProcessService.this.get_signals_wait_list.contains((Object)this)) {
                        this.done(TCFProcessService.this.signals.keySet().toArray(new String[TCFProcessService.this.signals.size()]));
                    } else {
                        if (TCFProcessService.this.get_signals_wait_list.isEmpty()) {
                            TCFProcessService.this.connector.getService(IProcesses.class).getSignalList(null, new IProcesses.DoneGetSignalList(){

                                public void doneGetSignalList(IToken token, Exception error, Collection<Map<String, Object>> list) {
                                    if (list != null) {
                                        for (Map<String, Object> m : list) {
                                            String name = (String)m.get("Name");
                                            Number code = (Number)m.get("Code");
                                            if (name == null || code == null) continue;
                                            TCFProcessService.this.signals.put(name, code.longValue());
                                        }
                                    }
                                    for (Runnable r : TCFProcessService.this.get_signals_wait_list) {
                                        r.run();
                                    }
                                    TCFProcessService.this.get_signals_wait_list.clear();
                                }
                            });
                        }
                        TCFProcessService.this.get_signals_wait_list.add(this);
                    }
                } else {
                    this.done(TCFProcessService.this.signals.keySet().toArray(new String[TCFProcessService.this.signals.size()]));
                }
            }
        }.getE();
    }

    public boolean kill(final long PID, final String signal, IProgressMonitor monitor) throws SystemMessageException {
        return (Boolean)new TCFRSETask<Boolean>(){

            public void run() {
                if (!TCFProcessService.this.root.loadChildren((Runnable)((Object)this))) {
                    return;
                }
                if (TCFProcessService.this.root.getChildrenError() != null) {
                    this.error(TCFProcessService.this.root.getChildrenError());
                    return;
                }
                TCFProcessResource prs = (TCFProcessResource)((Object)TCFProcessService.this.pid2res.get(PID));
                if (prs == null) {
                    this.done(false);
                    return;
                }
                Long signo = (Long)TCFProcessService.this.signals.get(signal);
                if (signal.equals("default")) {
                    if (signo == null) {
                        signo = (Long)TCFProcessService.this.signals.get("SIGTERM");
                    }
                    if (signo == null) {
                        signo = (Long)TCFProcessService.this.signals.get("SIGKILL");
                    }
                }
                if (signo == null) {
                    this.error(new Exception("Unknown signal: " + signal));
                    return;
                }
                TCFProcessService.this.connector.getService(IProcesses.class).signal(prs.getID(), signo.longValue(), new IProcesses.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            this.error(error);
                        } else {
                            this.done(true);
                        }
                    }
                });
            }
        }.getS(monitor, "Sending signal to a process");
    }

    private void sort(IHostProcess[] arr) {
        Comparator<IHostProcess> c = new Comparator<IHostProcess>(){

            @Override
            public int compare(IHostProcess o1, IHostProcess o2) {
                long p2;
                long p1 = o1.getPid();
                if (p1 < (p2 = o2.getPid())) {
                    return -1;
                }
                if (p1 > p2) {
                    return 1;
                }
                return 0;
            }
        };
        Arrays.sort(arr, c);
    }

    public IHostProcess[] listAllProcesses(IProgressMonitor monitor) throws SystemMessageException {
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        return this.listAllProcesses((IHostProcessFilter)rpfs, monitor);
    }

    public IHostProcess[] listAllProcesses(IHostProcessFilter filter, IProgressMonitor monitor) throws SystemMessageException {
        return this.listAllProcesses(filter, this.root, monitor);
    }

    private boolean eqaulIDs(String x, String y) {
        if (x == null) {
            return y == null;
        }
        return x.equals(y);
    }

    public IHostProcess[] listAllProcesses(final IHostProcessFilter filter, final IHostProcess up, IProgressMonitor monitor) throws SystemMessageException {
        new TCFRSETask<Boolean>(){

            public void run() {
                TCFProcessResource parent = (TCFProcessResource)up;
                if (parent != null && (filter.getPpid() == null || filter.getPpid().equals("*") || parent.getChildrenError() != null)) {
                    parent.flushChildrenCache();
                }
                this.done(true);
            }
        }.getE();
        return (IHostProcess[])new TCFRSETask<IHostProcess[]>(){

            public void run() {
                TCFProcessResource parent = (TCFProcessResource)up;
                if (parent == null) {
                    this.error(new IOException("Invalid parent"));
                    return;
                }
                if (!parent.loadChildren((Runnable)((Object)this))) {
                    return;
                }
                if (parent.getChildrenError() != null) {
                    this.error(parent.getChildrenError());
                    return;
                }
                ArrayList<TCFProcessResource> l = new ArrayList<TCFProcessResource>();
                for (TCFProcessResource p : TCFProcessService.this.pid2res.values()) {
                    if (!TCFProcessService.this.eqaulIDs(parent.getID(), p.getParentID()) || p.getError() != null || !filter.allows(p.getStatusLine())) continue;
                    l.add(p);
                }
                IHostProcess[] arr = new IHostProcess[l.size()];
                l.toArray(arr);
                TCFProcessService.this.sort(arr);
                this.done(arr);
            }
        }.getS(monitor, "List processes");
    }

    public IHostProcess[] listAllProcesses(String exeNameFilter, String userNameFilter, String stateFilter, IProgressMonitor monitor) throws SystemMessageException {
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        rpfs.setName(exeNameFilter);
        rpfs.setUsername(userNameFilter);
        rpfs.setSpecificState(stateFilter);
        return this.listAllProcesses((IHostProcessFilter)rpfs, monitor);
    }

    public IHostProcess[] listChildProcesses(long parentPID, IProgressMonitor monitor) throws SystemMessageException {
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        return this.listChildProcesses(parentPID, (IHostProcessFilter)rpfs, monitor);
    }

    public IHostProcess[] listChildProcesses(long parentPID, IHostProcessFilter filter, IProgressMonitor monitor) throws SystemMessageException {
        filter.setPpid(Long.toString(parentPID));
        return this.listAllProcesses(filter, monitor);
    }

    public IHostProcess[] listRootProcesses(IProgressMonitor monitor) throws SystemMessageException {
        IHostProcess[] roots = new IHostProcess[]{this.getProcess(1L, monitor)};
        return roots;
    }

    Map<Long, TCFProcessResource> getProcessCache() {
        return this.pid2res;
    }
}

