/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.controls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.validator.NameOrIPValidator;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.controls.wire.network.NetworkAddressControl;
import org.eclipse.tcf.te.ui.controls.wire.network.NetworkCablePanel;
import org.eclipse.tcf.te.ui.controls.wire.network.NetworkPortControl;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;

public class TcpTransportPanel
extends NetworkCablePanel {
    public TcpTransportPanel(BaseDialogPageControl parentPageControl) {
        super(parentPageControl);
    }

    protected NetworkAddressControl doCreateAddressControl(NetworkCablePanel parentPanel) {
        return new MyNetworkAddressControl(parentPanel);
    }

    protected String getDefaultPort() {
        return "1534";
    }

    public boolean dataChanged(IPropertiesContainer data, TypedEvent e) {
        String port;
        NetworkPortControl portControl;
        String address;
        Assert.isNotNull((Object)data);
        boolean isDirty = false;
        NetworkAddressControl addressControl = this.getAddressControl();
        if (addressControl != null && (address = addressControl.getEditFieldControlText()) != null) {
            isDirty |= !address.equals(data.getStringProperty("Host"));
        }
        if ((portControl = this.getPortControl()) != null && (port = portControl.getEditFieldControlText()) != null) {
            isDirty |= !port.equals(data.getStringProperty("Port"));
        }
        return isDirty;
    }

    public void setupData(IPropertiesContainer data) {
        NetworkPortControl portControl;
        if (data == null) {
            return;
        }
        NetworkAddressControl addressControl = this.getAddressControl();
        if (addressControl != null) {
            addressControl.setEditFieldControlText(data.getStringProperty("Host"));
        }
        if ((portControl = this.getPortControl()) != null) {
            portControl.setEditFieldControlText(data.getStringProperty("Port"));
        }
    }

    public void extractData(IPropertiesContainer data) {
        NetworkPortControl portControl;
        if (data == null) {
            return;
        }
        NetworkAddressControl addressControl = this.getAddressControl();
        if (addressControl != null) {
            String host = addressControl.getEditFieldControlText();
            data.setProperty("Host", (Object)(!"".equals(host) ? host : null));
        }
        if ((portControl = this.getPortControl()) != null) {
            String port = portControl.getEditFieldControlText();
            data.setProperty("Port", (Object)(!"".equals(port) ? port : null));
        }
    }

    public void removeData(IPropertiesContainer data) {
        if (data == null) {
            return;
        }
        data.setProperty("Host", null);
        data.setProperty("Port", null);
    }

    public void copyData(IPropertiesContainer src, IPropertiesContainer dst) {
        Assert.isNotNull((Object)src);
        Assert.isNotNull((Object)dst);
        dst.setProperty("Host", (Object)src.getStringProperty("Host"));
        dst.setProperty("Port", (Object)src.getStringProperty("Port"));
    }

    protected class MyNetworkAddressControl
    extends NetworkAddressControl {
        public MyNetworkAddressControl(NetworkCablePanel networkPanel) {
            super(networkPanel);
            this.setEditFieldLabel(Messages.MyNetworkAddressControl_label);
        }

        protected void configureEditFieldValidator(Validator validator) {
            if (validator instanceof NameOrIPValidator) {
                validator.setMessageText("NameOrIPValidator_Information_MissingNameOrIP", Messages.MyNetworkAddressControl_information_missingTargetNameAddress);
                validator.setMessageText("NameOrIPValidator_Error.InvalidNameOrIP", Messages.MyNetworkAddressControl_error_invalidTargetNameAddress);
                validator.setMessageText("NameOrIPValidator_Error_InvalidName", Messages.MyNetworkAddressControl_error_invalidTargetNameAddress);
                validator.setMessageText("NameOrIPValidator_Error_InvalidIP", Messages.MyNetworkAddressControl_error_invalidTargetIpAddress);
                validator.setMessageText("NameOrIPValidator_Information_CheckName", this.getUserInformationTextCheckNameAddress());
            }
        }

        protected String getUserInformationTextCheckNameAddress() {
            return Messages.MyNetworkAddressControl_information_checkNameAddressUserInformation;
        }

        public IValidatingContainer getValidatingContainer() {
            return TcpTransportPanel.this.getParentControl().getValidatingContainer();
        }

        public void modifyText(ModifyEvent e) {
            super.modifyText(e);
            if (TcpTransportPanel.this.getParentControl() instanceof ModifyListener) {
                ((ModifyListener)TcpTransportPanel.this.getParentControl()).modifyText(e);
            }
        }
    }
}

